/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport;

import com.aliyun.sdk.service.oss2.transport.ByteArrayBinaryData;
import com.aliyun.sdk.service.oss2.transport.ByteBufferBinaryData;
import com.aliyun.sdk.service.oss2.transport.ByteChannelBinaryData;
import com.aliyun.sdk.service.oss2.transport.InputStreamBinaryData;
import com.aliyun.sdk.service.oss2.transport.StringBinaryData;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public abstract class BinaryData {
    static final int STREAM_READ_SIZE = 8192;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    static final String TOO_LARGE_FOR_BYTE_ARRAY = "The content length is too large for a byte array. Content length is: ";

    public static BinaryData fromStream(InputStream inputStream) {
        return BinaryData.fromStream(inputStream, null);
    }

    public static BinaryData fromStream(InputStream inputStream, Long length) {
        return new InputStreamBinaryData(inputStream, length);
    }

    public static BinaryData fromString(String data) {
        return new StringBinaryData(data);
    }

    public static BinaryData fromBytes(byte[] data) {
        return new ByteArrayBinaryData(data);
    }

    public static BinaryData fromByteBuffer(ByteBuffer data) {
        return new ByteBufferBinaryData(data);
    }

    public static BinaryData fromByteChannel(ReadableByteChannel channel) {
        return BinaryData.fromByteChannel(channel, null);
    }

    public static BinaryData fromByteChannel(ReadableByteChannel channel, Long length) {
        return new ByteChannelBinaryData(channel, length);
    }

    public abstract byte[] toBytes();

    public abstract String toString();

    public abstract InputStream toStream();

    public abstract ByteBuffer toByteBuffer();

    public abstract ReadableByteChannel toByteChannel();

    public abstract Long getLength();

    public abstract boolean isReplayable();
}

