/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport;

import java.time.Duration;

public class HttpClientOptions {
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration DEFAULT_READWRITE_TIMEOUT = Duration.ofSeconds(20L);
    private static final Duration DEFAULT_IDLE_CONNECTION_TIMEOUT = Duration.ofSeconds(50L);
    private static final Duration DEFAULT_EXPECT_CONTINUE_TIMEOUT = Duration.ofSeconds(1L);
    private static final Duration DEFAULT_KEEP_ALIVE_TIMEOUT = Duration.ofSeconds(30L);
    private static final int DEFAULT_MAX_CONNECTIONS = 1024;
    private final String proxyHost;
    private final boolean redirectsEnabled;
    private final Duration connectTimeout;
    private final Duration readWriteTimeout;
    private final Duration keepAliveTimeout;
    private final boolean insecureSkipVerify;
    private final int maxConnections;

    HttpClientOptions(Builder builder) {
        this.proxyHost = builder.proxyHost;
        this.redirectsEnabled = builder.redirectsEnabled;
        this.insecureSkipVerify = builder.insecureSkipVerify;
        this.connectTimeout = builder.connectTimeout;
        this.readWriteTimeout = builder.readWriteTimeout;
        this.keepAliveTimeout = builder.keepAliveTimeout;
        this.maxConnections = builder.maxConnections;
    }

    public static Builder custom() {
        return new Builder();
    }

    public String proxyHost() {
        return this.proxyHost;
    }

    public boolean redirectsEnabled() {
        return this.redirectsEnabled;
    }

    public boolean insecureSkipVerify() {
        return this.insecureSkipVerify;
    }

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public Duration readWriteTimeout() {
        return this.readWriteTimeout;
    }

    public Duration keepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public int maxConnections() {
        return this.maxConnections;
    }

    static /* synthetic */ Duration access$700() {
        return DEFAULT_CONNECTION_TIMEOUT;
    }

    static /* synthetic */ Duration access$800() {
        return DEFAULT_READWRITE_TIMEOUT;
    }

    static /* synthetic */ Duration access$900() {
        return DEFAULT_KEEP_ALIVE_TIMEOUT;
    }

    public static class Builder {
        private String proxyHost;
        private boolean redirectsEnabled = false;
        private boolean insecureSkipVerify = false;
        private Duration connectTimeout = HttpClientOptions.access$700();
        private Duration readWriteTimeout = HttpClientOptions.access$800();
        private Duration keepAliveTimeout = HttpClientOptions.access$900();
        private int maxConnections = 1024;

        Builder() {
        }

        public Builder proxyHost(String value) {
            this.proxyHost = value;
            return this;
        }

        public Builder redirectsEnabled(boolean value) {
            this.redirectsEnabled = value;
            return this;
        }

        public Builder insecureSkipVerify(boolean value) {
            this.insecureSkipVerify = value;
            return this;
        }

        public Builder connectTimeout(Duration value) {
            this.connectTimeout = value;
            return this;
        }

        public Builder readWriteTimeout(Duration value) {
            this.readWriteTimeout = value;
            return this;
        }

        public Builder keepAliveTimeout(Duration value) {
            this.keepAliveTimeout = value;
            return this;
        }

        public Builder maxConnections(int value) {
            this.maxConnections = value;
            return this;
        }

        public HttpClientOptions build() {
            return new HttpClientOptions(this);
        }
    }
}

