/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport;

import com.aliyun.sdk.service.oss2.transport.BinaryData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public final class InputStreamBinaryData
extends BinaryData {
    private static final int INITIAL_BUFFER_CHUNK_SIZE = 8192;
    private static final int MAX_BUFFER_CHUNK_SIZE = 0x800000;
    private static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private static final AtomicReferenceFieldUpdater<InputStreamBinaryData, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(InputStreamBinaryData.class, byte[].class, "bytes");
    private final Supplier<InputStream> content;
    private final Long length;
    private final boolean isReplayable;
    private final InputStream is;
    private volatile byte[] bytes;

    public InputStreamBinaryData(InputStream inputStream, Long length) {
        Objects.requireNonNull(inputStream, "'inputStream' cannot be null.");
        this.length = length;
        this.is = inputStream;
        this.isReplayable = InputStreamBinaryData.canMarkReset(inputStream);
        if (this.isReplayable) {
            inputStream.mark(Optional.ofNullable(length).orElse(0L).intValue());
            this.content = () -> InputStreamBinaryData.resettableContent(inputStream);
        } else {
            this.content = () -> inputStream;
        }
    }

    private static boolean canMarkReset(InputStream inputStream) {
        return inputStream.markSupported();
    }

    private static InputStream resettableContent(InputStream stream) {
        try {
            stream.reset();
            return stream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void tryClose() {
        try {
            this.is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public InputStream unwrap() {
        return this.is;
    }

    @Override
    public byte[] toBytes() {
        if (this.length != null && this.length > 0x7FFFFFF7L) {
            throw new RuntimeException("The content length is too large for a byte array. Content length is: " + this.length);
        }
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public InputStream toStream() {
        return this.content.get();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public ReadableByteChannel toByteChannel() {
        return Channels.newChannel(this.toStream());
    }

    @Override
    public Long getLength() {
        byte[] data = BYTES_UPDATER.get(this);
        if (data != null) {
            return data.length;
        }
        return this.length;
    }

    @Override
    public boolean isReplayable() {
        return this.isReplayable;
    }

    private byte[] getBytes() {
        try {
            int nRead;
            AccessibleByteArrayOutputStream dataOutputBuffer = new AccessibleByteArrayOutputStream();
            byte[] data = new byte[8192];
            InputStream inputStream = this.content.get();
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                dataOutputBuffer.write(data, 0, nRead);
            }
            return dataOutputBuffer.toByteArrayUnsafe();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static class AccessibleByteArrayOutputStream
    extends ByteArrayOutputStream {
        public AccessibleByteArrayOutputStream() {
        }

        public AccessibleByteArrayOutputStream(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public byte[] toByteArray() {
            return Arrays.copyOf(this.buf, this.count);
        }

        public byte[] toByteArrayUnsafe() {
            return this.buf.length == this.count ? this.buf : this.toByteArray();
        }

        public ByteBuffer toByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.count).asReadOnlyBuffer();
        }

        public int count() {
            return this.count;
        }
    }
}

