/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport;

import com.aliyun.sdk.service.oss2.transport.BinaryDataConsumerSupplier;
import com.aliyun.sdk.service.oss2.transport.ObservableByteChannel;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RequestContext {
    private final Map<Key<?>, Object> attributes;

    private RequestContext(Map<? extends Key<?>, ?> attributes) {
        this.attributes = new HashMap(attributes);
    }

    public static RequestContext empty() {
        return new RequestContext(new HashMap());
    }

    public <T> boolean containsKey(Key<T> typedKey) {
        return this.attributes.containsKey(typedKey);
    }

    public <T> T get(Key<T> key) {
        Objects.requireNonNull(key, "Key to retrieve must not be null.");
        return key.convertValue(this.attributes.get(key));
    }

    public <T> RequestContext put(Key<T> key, T value) {
        Objects.requireNonNull(key, "Key to set must not be null.");
        this.attributes.put(key, value);
        return this;
    }

    public <T> RequestContext putIfAbsent(Key<T> key, T value) {
        Objects.requireNonNull(key, "Key to set must not be null.");
        this.attributes.putIfAbsent(key, value);
        return this;
    }

    public RequestContext merge(RequestContext lowerPrecedence) {
        HashMap copiedConfiguration = new HashMap(this.attributes);
        lowerPrecedence.attributes.forEach(copiedConfiguration::putIfAbsent);
        return new RequestContext(copiedConfiguration);
    }

    public RequestContext copy() {
        HashMap map = new HashMap();
        this.attributes.forEach((key, value) -> {
            key.validateValue(value);
            map.put(key, value);
        });
        return new RequestContext(map);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RequestContext)) {
            return false;
        }
        RequestContext rhs = (RequestContext)obj;
        if (this.attributes.size() != rhs.attributes.size()) {
            return false;
        }
        for (Key<?> lhsKey : this.attributes.keySet()) {
            Object rhsValue;
            Object lhsValue = this.get(lhsKey);
            if (Objects.equals(lhsValue, rhsValue = rhs.get(lhsKey))) continue;
            return false;
        }
        return true;
    }

    public static class Key<T> {
        public static final Key<HttpCompletionOption> HTTP_COMPLETION_OPTION = new Key(new UnsafeValueType(HttpCompletionOption.class));
        public static final Key<Duration> READWRITE_TIMEOUT = new Key(new UnsafeValueType(Duration.class));
        public static final Key<List<ObservableByteChannel>> UPLOAD_OBSERVER_CHANNEL = new Key(new UnsafeValueType(List.class));
        public static final Key<BinaryDataConsumerSupplier> RESPONSE_CONSUMER_SUPPLIER = new Key(new UnsafeValueType(BinaryDataConsumerSupplier.class));
        private final Class<?> valueType;

        protected Key(Class<T> valueType) {
            this.valueType = valueType;
        }

        protected Key(UnsafeValueType unsafeValueType) {
            this.valueType = unsafeValueType.valueType;
        }

        final void validateValue(Object value) {
            if (value != null && !this.valueType.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException(String.format("Invalid option: %s. Required value of type %s, but was %s.", this, this.valueType, value.getClass()));
            }
        }

        public final T convertValue(Object value) {
            this.validateValue(value);
            return (T)this.valueType.cast(value);
        }

        protected static class UnsafeValueType {
            private final Class<?> valueType;

            public UnsafeValueType(Class<?> valueType) {
                this.valueType = valueType;
            }
        }
    }

    public static enum HttpCompletionOption {
        ResponseContentRead,
        ResponseHeadersRead;

    }
}

