/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport;

import com.aliyun.sdk.service.oss2.transport.BinaryData;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class RequestMessage {
    private final String method;
    private final URI uri;
    private final Map<String, String> headers;
    private final BinaryData body;

    private RequestMessage(Builder builder) {
        this.method = builder.method;
        this.uri = builder.uri;
        this.headers = builder.headers != null ? builder.headers : new TreeMap();
        this.body = builder.body;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String method() {
        return this.method;
    }

    public URI uri() {
        return this.uri;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public BinaryData body() {
        return this.body;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String method;
        private URI uri;
        private Map<String, String> headers;
        private BinaryData body;

        protected Builder() {
        }

        protected Builder(RequestMessage request) {
            this.method = request.method;
            this.uri = request.uri;
            this.headers = request.headers;
            this.body = request.body;
        }

        public Builder method(String value) {
            Objects.requireNonNull(value);
            this.method = value;
            return this;
        }

        public Builder uri(URI value) {
            Objects.requireNonNull(value);
            this.uri = value;
            return this;
        }

        public Builder uri(String value) {
            Objects.requireNonNull(value);
            try {
                this.uri = new URI(value);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder headers(Map<String, String> value) {
            Objects.requireNonNull(value);
            this.headers = value;
            return this;
        }

        public Builder body(BinaryData value) {
            Objects.requireNonNull(value);
            this.body = value;
            return this;
        }

        public RequestMessage build() {
            return new RequestMessage(this);
        }
    }
}

