/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport;

import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.transport.InputStreamBinaryData;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import java.io.Closeable;
import java.util.Map;
import java.util.Objects;

public class ResponseMessage
implements Closeable {
    private final Map<String, String> headers;
    private final RequestMessage request;
    private final int statusCode;
    private final BinaryData body;

    private ResponseMessage(Builder builder) {
        this.headers = builder.headers;
        this.request = builder.request;
        this.statusCode = builder.statusCode;
        this.body = builder.body;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public RequestMessage request() {
        return this.request;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public BinaryData body() {
        return this.body;
    }

    @Override
    public void close() {
        if (this.body != null && this.body instanceof InputStreamBinaryData) {
            ((InputStreamBinaryData)this.body).tryClose();
        }
    }

    public static class Builder {
        private Map<String, String> headers;
        private RequestMessage request;
        private int statusCode;
        private BinaryData body;

        protected Builder() {
        }

        protected Builder(ResponseMessage response) {
            this.headers = response.headers;
            this.request = response.request;
            this.statusCode = response.statusCode;
            this.body = response.body;
        }

        public Builder headers(Map<String, String> value) {
            Objects.requireNonNull(value);
            this.headers = value;
            return this;
        }

        public Builder request(RequestMessage value) {
            Objects.requireNonNull(value);
            this.request = value;
            return this;
        }

        public Builder statusCode(int value) {
            this.statusCode = value;
            return this;
        }

        public Builder body(BinaryData value) {
            Objects.requireNonNull(value);
            this.body = value;
            return this;
        }

        public ResponseMessage build() {
            return new ResponseMessage(this);
        }
    }
}

