/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport.apache4client;

import com.aliyun.sdk.service.oss2.transport.AbortableInputStream;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.transport.ByteArrayBinaryData;
import com.aliyun.sdk.service.oss2.transport.ByteBufferBinaryData;
import com.aliyun.sdk.service.oss2.transport.HttpClient;
import com.aliyun.sdk.service.oss2.transport.RequestContext;
import com.aliyun.sdk.service.oss2.transport.RequestException;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import com.aliyun.sdk.service.oss2.transport.ResponseMessage;
import com.aliyun.sdk.service.oss2.transport.StringBinaryData;
import com.aliyun.sdk.service.oss2.transport.apache4client.Apache4HttpClientBuilder;
import com.aliyun.sdk.service.oss2.transport.apache4client.HttpDeleteWithBody;
import com.aliyun.sdk.service.oss2.transport.apache4client.IdleConnectionReaper;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class Apache4HttpClient
implements HttpClient,
AutoCloseable {
    private final CloseableHttpClient httpClient;
    private final HttpClientConnectionManager connectionManager;
    private final RequestConfig requestConfig;

    Apache4HttpClient(CloseableHttpClient httpClient, HttpClientConnectionManager connectionManager, RequestConfig requestConfig) {
        this.httpClient = httpClient;
        this.connectionManager = connectionManager;
        this.requestConfig = requestConfig;
    }

    public static Apache4HttpClientBuilder custom() {
        return Apache4HttpClientBuilder.create();
    }

    public static Apache4HttpClient createDefault() {
        return Apache4HttpClientBuilder.create().build();
    }

    @Override
    public ResponseMessage send(RequestMessage request, RequestContext context) {
        if (RequestContext.HttpCompletionOption.ResponseHeadersRead.equals((Object)context.get(RequestContext.Key.HTTP_COMPLETION_OPTION))) {
            return this.sendReturnStream(request, context);
        }
        return this.sendReturnBytes(request, context);
    }

    public ResponseMessage sendReturnStream(RequestMessage request, RequestContext context) {
        CloseableHttpResponse httpResponse = null;
        try {
            HttpRequestBase httpRequest = this.toHttpRequest(request, context);
            HttpClientContext httpContext = this.toHttpClientContext(context);
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
            ResponseMessage.Builder respBuilder = ResponseMessage.newBuilder().request(request).statusCode(httpResponse.getStatusLine().getStatusCode()).headers(this.fromHttpHeaders(httpResponse.getAllHeaders()));
            if (httpResponse.getEntity() != null) {
                if (Apache4HttpClient.determineReturnBytes((HttpResponse)httpResponse)) {
                    respBuilder.body(BinaryData.fromBytes(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity())));
                } else {
                    CloseableHttpResponse closeableResponse = httpResponse;
                    respBuilder.body(BinaryData.fromStream(AbortableInputStream.create(httpResponse.getEntity().getContent(), () -> Apache4HttpClient.closeQuietly((AutoCloseable)closeableResponse))));
                }
            }
            return respBuilder.build();
        }
        catch (Exception e) {
            Apache4HttpClient.closeQuietly(httpResponse);
            throw new RequestException("Send request raised an exception", e);
        }
    }

    private ResponseMessage sendReturnBytes(RequestMessage request, RequestContext context) {
        try {
            HttpRequestBase httpRequest = this.toHttpRequest(request, context);
            HttpClientContext httpContext = this.toHttpClientContext(context);
            return (ResponseMessage)this.httpClient.execute((HttpUriRequest)httpRequest, response -> {
                ResponseMessage.Builder respBuilder = ResponseMessage.newBuilder().request(request).statusCode(response.getStatusLine().getStatusCode()).headers(this.fromHttpHeaders(response.getAllHeaders()));
                if (response.getEntity() != null) {
                    respBuilder.body(BinaryData.fromBytes(EntityUtils.toByteArray((HttpEntity)response.getEntity())));
                }
                return respBuilder.build();
            }, (HttpContext)httpContext);
        }
        catch (Exception e) {
            throw new RequestException("Send request raised an exception", e);
        }
    }

    @Override
    public String name() {
        return "Apache HttpClient 4.x";
    }

    @Override
    public void close() throws Exception {
        IdleConnectionReaper.getInstance().deregisterConnectionManager(this.connectionManager);
        this.connectionManager.shutdown();
    }

    public HttpClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    private HttpRequestBase toHttpRequest(RequestMessage request, RequestContext context) {
        Object httpRequest;
        String uri = request.uri().toString();
        String method = request.method();
        BinaryData body = request.body();
        switch (method.toLowerCase()) {
            case "post": {
                HttpPost postMethod = new HttpPost(uri);
                if (body != null) {
                    postMethod.setEntity(this.toHttpEntity(body));
                }
                httpRequest = postMethod;
                break;
            }
            case "put": {
                HttpPut putMethod = new HttpPut(uri);
                if (body != null) {
                    putMethod.setEntity(this.toHttpEntity(body));
                }
                httpRequest = putMethod;
                break;
            }
            case "get": {
                httpRequest = new HttpGet(uri);
                break;
            }
            case "delete": {
                if (body != null) {
                    HttpDeleteWithBody deleteMethod = new HttpDeleteWithBody(uri);
                    deleteMethod.setEntity(this.toHttpEntity(body));
                    httpRequest = deleteMethod;
                    break;
                }
                httpRequest = new HttpDelete(uri);
                break;
            }
            case "head": {
                httpRequest = new HttpHead(uri);
                break;
            }
            case "options": {
                httpRequest = new HttpOptions(uri);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown HTTP method name: " + method);
            }
        }
        request.headers().forEach((arg_0, arg_1) -> ((HttpRequestBase)httpRequest).addHeader(arg_0, arg_1));
        return httpRequest;
    }

    private HttpClientContext toHttpClientContext(RequestContext context) {
        RequestConfig config = this.requestConfig;
        Duration rwTimeout = context.get(RequestContext.Key.READWRITE_TIMEOUT);
        if (rwTimeout != null) {
            config = RequestConfig.copy((RequestConfig)config).setSocketTimeout((int)rwTimeout.toMillis()).build();
        }
        HttpClientContext httpClientContext = HttpClientContext.create();
        httpClientContext.setRequestConfig(config);
        return httpClientContext;
    }

    private HttpEntity toHttpEntity(BinaryData body) {
        if (body != null) {
            if (body instanceof StringBinaryData) {
                return new StringEntity(body.toString(), (ContentType)null);
            }
            if (body instanceof ByteArrayBinaryData || body instanceof ByteBufferBinaryData) {
                return new ByteArrayEntity(body.toBytes(), (ContentType)null);
            }
            long length = Optional.ofNullable(body.getLength()).orElse(-1L);
            return new InputStreamEntity(body.toStream(), length, (ContentType)null);
        }
        return null;
    }

    private Map<String, String> fromHttpHeaders(Header[] headers) {
        TreeMap<String, String> h = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : headers) {
            h.put(header.getName(), header.getValue());
        }
        return h;
    }

    private static boolean determineReturnBytes(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 300 || statusCode == 203) {
            return true;
        }
        return !response.getEntity().isChunked() && response.getEntity().getContentLength() <= 32768L;
    }

    private static void closeQuietly(AutoCloseable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

