/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport.apache4client;

import com.aliyun.sdk.service.oss2.transport.HttpClientOptions;
import com.aliyun.sdk.service.oss2.transport.apache4client.Apache4HttpClient;
import com.aliyun.sdk.service.oss2.transport.apache4client.IdleConnectionReaper;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class Apache4HttpClientBuilder {
    private static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = -1;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 50000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 50000;
    private static final int DEFAULT_MAX_CONNECTIONS = 1024;
    private static final long DEFAULT_CONNECTION_TTL = -1L;
    private static final long DEFAULT_IDLE_CONNECTION_TIME = 50000L;
    private static final int DEFAULT_VALIDATE_AFTER_INACTIVITY = 2000;
    private static final boolean DEFAULT_USE_REAPER = true;
    private HttpClientOptions options;
    private DnsResolver dnsResolver;
    private HttpClientConnectionManager connectionManager;
    private RequestConfig requestConfig;
    private boolean useReaper = true;
    private long connectionTTL = -1L;
    private int connectionRequestTimeout = -1;
    private long idleConnectionTime = 50000L;
    private int maxConnections = 1024;
    private int connectionTimeout;
    private int socketTimeout;
    private KeyManager[] keyManagers;
    private X509TrustManager[] x509TrustManagers;
    private HostnameVerifier hostnameVerifier;
    private KeyStore keyStore;
    private SecureRandom secureRandom = null;

    protected Apache4HttpClientBuilder() {
    }

    public static Apache4HttpClientBuilder create() {
        return new Apache4HttpClientBuilder();
    }

    protected static String resolveStringValue(String value, String key, boolean flag) {
        if (value == null && flag) {
            try {
                return System.getProperty(key);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return value;
    }

    protected static int resolveIntValue(int value, String key, boolean flag) {
        if (value == -1 && flag) {
            try {
                return Integer.parseInt(System.getProperty(key));
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return value;
    }

    public Apache4HttpClientBuilder options(HttpClientOptions value) {
        this.options = value;
        return this;
    }

    public Apache4HttpClientBuilder dnsResolver(DnsResolver value) {
        this.dnsResolver = value;
        return this;
    }

    public Apache4HttpClientBuilder connectionManager(HttpClientConnectionManager value) {
        this.connectionManager = value;
        return this;
    }

    public Apache4HttpClientBuilder requestConfig(RequestConfig value) {
        this.requestConfig = value;
        return this;
    }

    public Apache4HttpClientBuilder maxConnections(int value) {
        this.maxConnections = value;
        return this;
    }

    public Apache4HttpClientBuilder useReaper(boolean value) {
        this.useReaper = value;
        return this;
    }

    public Apache4HttpClientBuilder connectionTTL(long value) {
        this.connectionTTL = value;
        return this;
    }

    public Apache4HttpClientBuilder idleConnectionTime(long value) {
        this.idleConnectionTime = value;
        return this;
    }

    public Apache4HttpClientBuilder connectionRequestTimeout(int value) {
        this.connectionRequestTimeout = value;
        return this;
    }

    public Apache4HttpClientBuilder keyManagers(KeyManager[] value) {
        this.keyManagers = value;
        return this;
    }

    public Apache4HttpClientBuilder x509TrustManagers(X509TrustManager[] value) {
        this.x509TrustManagers = value;
        return this;
    }

    public Apache4HttpClientBuilder hostnameVerifier(HostnameVerifier value) {
        this.hostnameVerifier = value;
        return this;
    }

    public Apache4HttpClientBuilder secureRandom(SecureRandom value) {
        this.secureRandom = value;
        return this;
    }

    public Apache4HttpClientBuilder keyStore(KeyStore value) {
        this.keyStore = value;
        return this;
    }

    public Apache4HttpClient build() {
        this.options = Optional.ofNullable(this.options).orElse(HttpClientOptions.custom().build());
        this.connectionTimeout = (int)this.options.connectTimeout().toMillis();
        this.socketTimeout = (int)this.options.readWriteTimeout().toMillis();
        HttpClientConnectionManager connectionManager = Optional.ofNullable(this.connectionManager).orElse(this.createHttpClientConnectionManager());
        RequestConfig requestConfig = Optional.ofNullable(this.requestConfig).orElse(this.createRequestConfig());
        HttpClientBuilder builder = HttpClients.custom().disableAutomaticRetries().disableContentCompression().disableRedirectHandling().setUserAgent("").setConnectionManager(connectionManager);
        if (this.useReaper) {
            IdleConnectionReaper.getInstance().registerConnectionManager(connectionManager, this.idleConnectionTime);
        }
        return new Apache4HttpClient(builder.build(), connectionManager, requestConfig);
    }

    protected RequestConfig createRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(this.connectionTimeout);
        builder.setSocketTimeout(this.socketTimeout);
        builder.setConnectionRequestTimeout(this.connectionRequestTimeout);
        builder.setRedirectsEnabled(this.options.redirectsEnabled());
        builder.setNormalizeUri(false);
        return builder.build();
    }

    protected HttpClientConnectionManager createHttpClientConnectionManager() {
        SSLConnectionSocketFactory sslSocketFactory = null;
        try {
            ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
            X509TrustManager[] trustManagers = this.x509TrustManagers;
            if (null != trustManagers) {
                trustManagerList.addAll(Arrays.asList(trustManagers));
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (this.keyStore != null) {
                tmf.init(this.keyStore);
            } else {
                tmf.init((KeyStore)null);
            }
            trustManagerList.addAll(Arrays.asList(tmf.getTrustManagers()));
            ArrayList<X509TrustManager> finalTrustManagerList = new ArrayList<X509TrustManager>();
            for (TrustManager tm : trustManagerList) {
                if (!(tm instanceof X509TrustManager)) continue;
                finalTrustManagerList.add((X509TrustManager)tm);
            }
            boolean isVerifySSLEnable = !this.options.insecureSkipVerify();
            CompositeX509TrustManager compositeX509TrustManager = new CompositeX509TrustManager(finalTrustManagerList);
            compositeX509TrustManager.setVerifySSL(isVerifySSLEnable);
            KeyManager[] keyManagers = null;
            if (this.keyManagers != null) {
                keyManagers = this.keyManagers;
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{compositeX509TrustManager}, this.secureRandom);
            Object hostnameVerifier = null;
            hostnameVerifier = !isVerifySSLEnable ? new NoopHostnameVerifier() : (this.hostnameVerifier != null ? this.hostnameVerifier : new DefaultHostnameVerifier());
            sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
        }
        catch (Exception e) {
            throw new RuntimeException("SSLContext fail", e);
        }
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, this.dnsResolver);
        connectionManager.setDefaultMaxPerRoute(this.maxConnections);
        connectionManager.setMaxTotal(this.maxConnections);
        connectionManager.setValidateAfterInactivity(2000);
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.socketTimeout).setTcpNoDelay(true).build());
        return connectionManager;
    }

    private static class CompositeX509TrustManager
    implements X509TrustManager {
        private final List<X509TrustManager> trustManagers;
        private boolean verifySSL = true;

        public CompositeX509TrustManager(List<X509TrustManager> trustManagers) {
            this.trustManagers = trustManagers;
        }

        public boolean isVerifySSL() {
            return this.verifySSL;
        }

        public void setVerifySSL(boolean verifySSL) {
            this.verifySSL = verifySSL;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (!this.verifySSL) {
                return;
            }
            for (X509TrustManager trustManager : this.trustManagers) {
                try {
                    trustManager.checkServerTrusted(chain, authType);
                    return;
                }
                catch (CertificateException certificateException) {
                }
            }
            throw new CertificateException("None of the TrustManagers trust this certificate chain");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            for (X509TrustManager trustManager : this.trustManagers) {
                X509Certificate[] accepts = trustManager.getAcceptedIssuers();
                if (accepts == null || accepts.length <= 0) continue;
                certificates.addAll(Arrays.asList(accepts));
            }
            X509Certificate[] certificatesArray = new X509Certificate[certificates.size()];
            return certificates.toArray(certificatesArray);
        }
    }
}

