/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport.apache4client;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.http.conn.HttpClientConnectionManager;

public final class IdleConnectionReaper {
    private static final Duration REAP_INTERVAL = Duration.ofSeconds(10L);
    private static final IdleConnectionReaper INSTANCE = new IdleConnectionReaper();
    private final Map<HttpClientConnectionManager, Long> connectionManagers;
    private final Supplier<ExecutorService> executorServiceSupplier;
    private final long sleepPeriod;
    private volatile ExecutorService exec;
    private volatile ReaperTask reaperTask;

    private IdleConnectionReaper() {
        this.connectionManagers = Collections.synchronizedMap(new WeakHashMap());
        this.executorServiceSupplier = () -> Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "idle-connection-reaper");
            t.setDaemon(true);
            return t;
        });
        this.sleepPeriod = REAP_INTERVAL.toMillis();
    }

    IdleConnectionReaper(Map<HttpClientConnectionManager, Long> connectionManagers, Supplier<ExecutorService> executorServiceSupplier, long sleepPeriod) {
        this.connectionManagers = connectionManagers;
        this.executorServiceSupplier = executorServiceSupplier;
        this.sleepPeriod = sleepPeriod;
    }

    public static IdleConnectionReaper getInstance() {
        return INSTANCE;
    }

    public synchronized boolean registerConnectionManager(HttpClientConnectionManager manager, long maxIdleTime) {
        boolean notPreviouslyRegistered = this.connectionManagers.put(manager, maxIdleTime) == null;
        this.setupExecutorIfNecessary();
        return notPreviouslyRegistered;
    }

    public synchronized boolean deregisterConnectionManager(HttpClientConnectionManager manager) {
        boolean wasRemoved = this.connectionManagers.remove(manager) != null;
        this.cleanupExecutorIfNecessary();
        return wasRemoved;
    }

    private void setupExecutorIfNecessary() {
        if (this.exec != null) {
            return;
        }
        ExecutorService e = this.executorServiceSupplier.get();
        this.reaperTask = new ReaperTask(this.connectionManagers, this.sleepPeriod);
        e.execute(this.reaperTask);
        this.exec = e;
    }

    private void cleanupExecutorIfNecessary() {
        if (this.exec == null || !this.connectionManagers.isEmpty()) {
            return;
        }
        this.reaperTask.stop();
        this.reaperTask = null;
        this.exec.shutdownNow();
        this.exec = null;
    }

    private static final class ReaperTask
    implements Runnable {
        private final Map<HttpClientConnectionManager, Long> connectionManagers;
        private final long sleepPeriod;
        private volatile boolean stopping = false;

        private ReaperTask(Map<HttpClientConnectionManager, Long> connectionManagers, long sleepPeriod) {
            this.connectionManagers = connectionManagers;
            this.sleepPeriod = sleepPeriod;
        }

        @Override
        public void run() {
            while (!this.stopping) {
                try {
                    Thread.sleep(this.sleepPeriod);
                    for (Map.Entry<HttpClientConnectionManager, Long> entry : this.connectionManagers.entrySet()) {
                        try {
                            entry.getKey().closeIdleConnections(entry.getValue().longValue(), TimeUnit.MILLISECONDS);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }

        private void stop() {
            this.stopping = true;
        }
    }
}

