/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport.apache5client;

import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.transport.BinaryDataConsumerSupplier;
import com.aliyun.sdk.service.oss2.transport.ByteArrayBinaryData;
import com.aliyun.sdk.service.oss2.transport.ByteChannelBinaryData;
import com.aliyun.sdk.service.oss2.transport.HttpClient;
import com.aliyun.sdk.service.oss2.transport.InputStreamBinaryData;
import com.aliyun.sdk.service.oss2.transport.RequestContext;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import com.aliyun.sdk.service.oss2.transport.ResponseMessage;
import com.aliyun.sdk.service.oss2.transport.StringBinaryData;
import com.aliyun.sdk.service.oss2.transport.apache5client.Apache5AsyncHttpClientBuilder;
import com.aliyun.sdk.service.oss2.transport.apache5client.ByteBufferAsyncEntityProducer;
import com.aliyun.sdk.service.oss2.transport.apache5client.ByteChannelAsyncEntityProducer;
import com.aliyun.sdk.service.oss2.transport.apache5client.CustomAsyncResponseConsumer;
import com.aliyun.sdk.service.oss2.transport.apache5client.ObservableEntityProducer;
import java.nio.channels.Channels;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityProducer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;

public class Apache5AsyncHttpClient
implements HttpClient,
AutoCloseable {
    private static final List<String> IGNORE_HEADERS = Collections.singletonList("Content-Length");
    private final CloseableHttpAsyncClient httpClient;
    private final AsyncClientConnectionManager connectionManager;
    private final RequestConfig requestConfig;

    Apache5AsyncHttpClient(CloseableHttpAsyncClient httpClient, AsyncClientConnectionManager connectionManager, RequestConfig requestConfig) {
        this.httpClient = httpClient;
        this.connectionManager = connectionManager;
        this.requestConfig = requestConfig;
        this.httpClient.start();
    }

    public static Apache5AsyncHttpClientBuilder custom() {
        return Apache5AsyncHttpClientBuilder.create();
    }

    public static Apache5AsyncHttpClient createDefault() {
        return Apache5AsyncHttpClientBuilder.create().build();
    }

    @Override
    public CompletableFuture<ResponseMessage> sendAsync(final RequestMessage request, RequestContext context) {
        final CompletableFuture<ResponseMessage> cf = new CompletableFuture<ResponseMessage>();
        try {
            if (RequestContext.HttpCompletionOption.ResponseHeadersRead.equals((Object)context.get(RequestContext.Key.HTTP_COMPLETION_OPTION))) {
                throw new UnsupportedOperationException(this.name() + " does not support ResponseHeadersRead.");
            }
            AsyncRequestProducer requestProducer = this.toRequestProducer(request, context);
            HttpClientContext httpContext = this.toHttpClientContext(context);
            BinaryDataConsumerSupplier dataConsumerSupplier = context.get(RequestContext.Key.RESPONSE_CONSUMER_SUPPLIER);
            this.httpClient.execute(requestProducer, (AsyncResponseConsumer)new CustomAsyncResponseConsumer(dataConsumerSupplier), null, (HttpContext)httpContext, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void completed(SimpleHttpResponse response) {
                    ResponseMessage.Builder respBuilder = ResponseMessage.newBuilder().request(request).statusCode(response.getCode()).headers(Apache5AsyncHttpClient.this.fromHttpHeaders(response.getHeaders()));
                    byte[] body = response.getBodyBytes();
                    if (body != null) {
                        respBuilder.body(BinaryData.fromBytes(body));
                    }
                    cf.complete(respBuilder.build());
                }

                public void failed(Exception ex) {
                    cf.completeExceptionally(ex);
                }

                public void cancelled() {
                    cf.cancel(true);
                }
            });
        }
        catch (Exception e) {
            cf.completeExceptionally(e);
        }
        return cf;
    }

    @Override
    public String name() {
        return "Apache Async HttpClient 5.x";
    }

    @Override
    public void close() throws Exception {
        this.httpClient.close();
    }

    public AsyncClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    private AsyncRequestProducer toRequestProducer(RequestMessage request, RequestContext context) {
        SimpleHttpRequest httpRequest = new SimpleHttpRequest(request.method(), request.uri());
        request.headers().forEach((name, value) -> {
            if (IGNORE_HEADERS.stream().noneMatch(name::equalsIgnoreCase)) {
                httpRequest.addHeader(name, value);
            }
        });
        AsyncEntityProducer entityProducer = this.toEntityProducer(request.body());
        if (entityProducer != null && context.containsKey(RequestContext.Key.UPLOAD_OBSERVER_CHANNEL)) {
            entityProducer = new ObservableEntityProducer(entityProducer, context.get(RequestContext.Key.UPLOAD_OBSERVER_CHANNEL));
        }
        return new BasicRequestProducer((HttpRequest)httpRequest, entityProducer);
    }

    private AsyncEntityProducer toEntityProducer(BinaryData body) {
        Object entityProducer = body != null ? (body instanceof ByteArrayBinaryData ? new BasicAsyncEntityProducer(body.toBytes(), null) : (body instanceof StringBinaryData ? new StringAsyncEntityProducer((CharSequence)body.toString(), null) : (body instanceof InputStreamBinaryData ? new ByteChannelAsyncEntityProducer(Channels.newChannel(body.toStream()), body.getLength()) : (body instanceof ByteChannelBinaryData ? new ByteChannelAsyncEntityProducer(body.toByteChannel(), body.getLength()) : new ByteBufferAsyncEntityProducer(body.toByteBuffer(), null))))) : null;
        return entityProducer;
    }

    private HttpClientContext toHttpClientContext(RequestContext context) {
        RequestConfig config = this.requestConfig;
        Duration rwTimeout = context.get(RequestContext.Key.READWRITE_TIMEOUT);
        if (rwTimeout != null) {
            config = RequestConfig.copy((RequestConfig)config).setResponseTimeout(Timeout.ofMilliseconds((long)rwTimeout.toMillis())).build();
        }
        HttpClientContext clientContext = new HttpClientContext();
        clientContext.setRequestConfig(config);
        return clientContext;
    }

    private Map<String, String> fromHttpHeaders(Header[] headers) {
        TreeMap<String, String> h = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : headers) {
            h.put(header.getName(), header.getValue());
        }
        return h;
    }
}

