/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport.apache5client;

import com.aliyun.sdk.service.oss2.transport.AbortableInputStream;
import com.aliyun.sdk.service.oss2.transport.BinaryData;
import com.aliyun.sdk.service.oss2.transport.ByteArrayBinaryData;
import com.aliyun.sdk.service.oss2.transport.ByteBufferBinaryData;
import com.aliyun.sdk.service.oss2.transport.HttpClient;
import com.aliyun.sdk.service.oss2.transport.RequestContext;
import com.aliyun.sdk.service.oss2.transport.RequestException;
import com.aliyun.sdk.service.oss2.transport.RequestMessage;
import com.aliyun.sdk.service.oss2.transport.ResponseMessage;
import com.aliyun.sdk.service.oss2.transport.StringBinaryData;
import com.aliyun.sdk.service.oss2.transport.apache5client.Apache5HttpClientBuilder;
import com.aliyun.sdk.service.oss2.transport.apache5client.IdleConnectionReaper;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Timeout;

public class Apache5HttpClient
implements HttpClient,
AutoCloseable {
    private static final List<String> IGNORE_HEADERS = Collections.singletonList("Content-Length");
    private final CloseableHttpClient httpClient;
    private final HttpClientConnectionManager connectionManager;
    private final RequestConfig requestConfig;

    Apache5HttpClient(CloseableHttpClient httpClient, HttpClientConnectionManager connectionManager, RequestConfig requestConfig) {
        this.httpClient = httpClient;
        this.connectionManager = connectionManager;
        this.requestConfig = requestConfig;
    }

    public static Apache5HttpClientBuilder custom() {
        return Apache5HttpClientBuilder.create();
    }

    public static Apache5HttpClient createDefault() {
        return Apache5HttpClientBuilder.create().build();
    }

    @Override
    public ResponseMessage send(RequestMessage request, RequestContext context) {
        if (RequestContext.HttpCompletionOption.ResponseHeadersRead.equals((Object)context.get(RequestContext.Key.HTTP_COMPLETION_OPTION))) {
            return this.sendReturnStream(request, context);
        }
        return this.sendReturnBytes(request, context);
    }

    private ResponseMessage sendReturnStream(RequestMessage request, RequestContext context) {
        CloseableHttpResponse httpResponse = null;
        try {
            HttpUriRequestBase httpRequest = this.toHttpRequest(request, context);
            HttpClientContext httpContext = this.toHttpClientContext(context);
            httpResponse = this.httpClient.execute((ClassicHttpRequest)httpRequest, (HttpContext)httpContext);
            ResponseMessage.Builder respBuilder = ResponseMessage.newBuilder().request(request).statusCode(httpResponse.getCode()).headers(this.fromHttpHeaders(httpResponse.getHeaders()));
            if (httpResponse.getEntity() != null) {
                if (Apache5HttpClient.determineReturnBytes(httpResponse)) {
                    respBuilder.body(BinaryData.fromBytes(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity())));
                } else {
                    CloseableHttpResponse closeableResponse = httpResponse;
                    respBuilder.body(BinaryData.fromStream(AbortableInputStream.create(httpResponse.getEntity().getContent(), () -> Apache5HttpClient.closeQuietly((AutoCloseable)closeableResponse))));
                }
            }
            return respBuilder.build();
        }
        catch (Exception e) {
            Apache5HttpClient.closeQuietly(httpResponse);
            throw new RequestException("Send request raised an exception", e);
        }
    }

    private ResponseMessage sendReturnBytes(RequestMessage request, RequestContext context) {
        try {
            HttpUriRequestBase httpRequest = this.toHttpRequest(request, context);
            HttpClientContext httpContext = this.toHttpClientContext(context);
            return (ResponseMessage)this.httpClient.execute((ClassicHttpRequest)httpRequest, (HttpContext)httpContext, response -> {
                ResponseMessage.Builder respBuilder = ResponseMessage.newBuilder().request(request).statusCode(response.getCode()).headers(this.fromHttpHeaders(response.getHeaders()));
                if (response.getEntity() != null) {
                    respBuilder.body(BinaryData.fromBytes(EntityUtils.toByteArray((HttpEntity)response.getEntity())));
                }
                return respBuilder.build();
            });
        }
        catch (Exception e) {
            throw new RequestException("Send request raised an exception", e);
        }
    }

    @Override
    public String name() {
        return "Apache HttpClient 5.x";
    }

    @Override
    public void close() throws Exception {
        IdleConnectionReaper.getInstance().deregisterConnectionManager(this.connectionManager);
        this.connectionManager.close(CloseMode.IMMEDIATE);
    }

    public HttpClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    private HttpUriRequestBase toHttpRequest(RequestMessage request, RequestContext context) {
        HttpUriRequestBase httpRequest = new HttpUriRequestBase(request.method(), request.uri());
        request.headers().forEach((name, value) -> {
            if (IGNORE_HEADERS.stream().noneMatch(name::equalsIgnoreCase)) {
                httpRequest.addHeader(name, value);
            }
        });
        httpRequest.setEntity(this.toHttpEntity(request.body()));
        return httpRequest;
    }

    private HttpClientContext toHttpClientContext(RequestContext context) {
        RequestConfig config = this.requestConfig;
        Duration rwTimeout = context.get(RequestContext.Key.READWRITE_TIMEOUT);
        if (rwTimeout != null) {
            config = RequestConfig.copy((RequestConfig)config).setResponseTimeout(Timeout.ofMilliseconds((long)rwTimeout.toMillis())).build();
        }
        HttpClientContext clientContext = new HttpClientContext();
        clientContext.setRequestConfig(config);
        return clientContext;
    }

    private HttpEntity toHttpEntity(BinaryData body) {
        if (body == null) {
            return null;
        }
        if (body instanceof StringBinaryData) {
            return new StringEntity(body.toString(), (ContentType)null);
        }
        if (body instanceof ByteArrayBinaryData || body instanceof ByteBufferBinaryData) {
            return new ByteArrayEntity(body.toBytes(), null);
        }
        long length = Optional.ofNullable(body.getLength()).orElse(-1L);
        return new InputStreamEntity(body.toStream(), length, null);
    }

    private Map<String, String> fromHttpHeaders(Header[] headers) {
        TreeMap<String, String> h = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : headers) {
            h.put(header.getName(), header.getValue());
        }
        return h;
    }

    private static boolean determineReturnBytes(CloseableHttpResponse response) {
        int statusCode = response.getCode();
        if (statusCode >= 300 || statusCode == 203) {
            return true;
        }
        return !response.getEntity().isChunked() && response.getEntity().getContentLength() <= 32768L;
    }

    private static void closeQuietly(AutoCloseable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

