/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport.apache5client;

import com.aliyun.sdk.service.oss2.transport.HttpClientOptions;
import com.aliyun.sdk.service.oss2.transport.apache5client.Apache5HttpClient;
import com.aliyun.sdk.service.oss2.transport.apache5client.IdleConnectionReaper;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class Apache5HttpClientBuilder {
    private static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = -1;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 50000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 50000;
    private static final int DEFAULT_MAX_CONNECTIONS = 1024;
    private static final long DEFAULT_CONNECTION_TTL = -1L;
    private static final long DEFAULT_IDLE_CONNECTION_TIME = 50000L;
    private static final int DEFAULT_VALIDATE_AFTER_INACTIVITY = 2000;
    private static final boolean DEFAULT_USE_REAPER = true;
    private HttpClientOptions options;
    private DnsResolver dnsResolver;
    private PoolingHttpClientConnectionManager connectionManager;
    private RequestConfig requestConfig;
    private boolean useReaper = true;
    private long connectionTTL = -1L;
    private int connectionRequestTimeout = -1;
    private long idleConnectionTime = 50000L;
    private int maxConnections = 1024;
    private long connectionTimeout;
    private long responseTimeout;
    private KeyManager[] keyManagers;
    private X509TrustManager[] x509TrustManagers;
    private HostnameVerifier hostnameVerifier;
    private KeyStore keyStore;
    private SecureRandom secureRandom = null;

    protected Apache5HttpClientBuilder() {
    }

    public static Apache5HttpClientBuilder create() {
        return new Apache5HttpClientBuilder();
    }

    private static Timeout millistoTimeout(long value) {
        if (value < 0L) {
            return Timeout.INFINITE;
        }
        return Timeout.ofMilliseconds((long)value);
    }

    public Apache5HttpClientBuilder options(HttpClientOptions value) {
        this.options = value;
        return this;
    }

    public Apache5HttpClientBuilder dnsResolver(DnsResolver value) {
        this.dnsResolver = value;
        return this;
    }

    public Apache5HttpClientBuilder connectionManager(PoolingHttpClientConnectionManager value) {
        this.connectionManager = value;
        return this;
    }

    public Apache5HttpClientBuilder requestConfig(RequestConfig value) {
        this.requestConfig = value;
        return this;
    }

    public Apache5HttpClientBuilder maxConnections(int value) {
        this.maxConnections = value;
        return this;
    }

    public Apache5HttpClientBuilder useReaper(boolean value) {
        this.useReaper = value;
        return this;
    }

    public Apache5HttpClientBuilder connectionTTL(long value) {
        this.connectionTTL = value;
        return this;
    }

    public Apache5HttpClientBuilder idleConnectionTime(long value) {
        this.idleConnectionTime = value;
        return this;
    }

    public Apache5HttpClientBuilder connectionRequestTimeout(int value) {
        this.connectionRequestTimeout = value;
        return this;
    }

    public Apache5HttpClientBuilder keyManagers(KeyManager[] value) {
        this.keyManagers = value;
        return this;
    }

    public Apache5HttpClientBuilder x509TrustManagers(X509TrustManager[] value) {
        this.x509TrustManagers = value;
        return this;
    }

    public Apache5HttpClientBuilder hostnameVerifier(HostnameVerifier value) {
        this.hostnameVerifier = value;
        return this;
    }

    public Apache5HttpClientBuilder secureRandom(SecureRandom value) {
        this.secureRandom = value;
        return this;
    }

    public Apache5HttpClientBuilder keyStore(KeyStore value) {
        this.keyStore = value;
        return this;
    }

    public Apache5HttpClient build() {
        this.options = Optional.ofNullable(this.options).orElse(HttpClientOptions.custom().build());
        this.connectionTimeout = this.options.connectTimeout().toMillis();
        this.responseTimeout = this.options.readWriteTimeout().toMillis();
        PoolingHttpClientConnectionManager connectionManager = Optional.ofNullable(this.connectionManager).orElse(this.createHttpClientConnectionManager());
        RequestConfig requestConfig = Optional.ofNullable(this.requestConfig).orElse(this.createRequestConfig());
        HttpClientBuilder builder = HttpClients.custom().disableAutomaticRetries().disableRedirectHandling().disableContentCompression().setUserAgent("").setKeepAliveStrategy(this.createKeepAliveStrategy()).setConnectionManager((HttpClientConnectionManager)connectionManager);
        if (this.useReaper) {
            IdleConnectionReaper.getInstance().registerConnectionManager(connectionManager, this.idleConnectionTime);
        }
        return new Apache5HttpClient(builder.build(), (HttpClientConnectionManager)connectionManager, requestConfig);
    }

    private ConnectionKeepAliveStrategy createKeepAliveStrategy() {
        return this.idleConnectionTime > 0L ? new SdkConnectionKeepAliveStrategy(this.idleConnectionTime) : null;
    }

    private PoolingHttpClientConnectionManager createHttpClientConnectionManager() {
        TlsSocketStrategy tlsStrategy = null;
        try {
            ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
            X509TrustManager[] trustManagers = this.x509TrustManagers;
            if (null != trustManagers) {
                trustManagerList.addAll(Arrays.asList(trustManagers));
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (this.keyStore != null) {
                tmf.init(this.keyStore);
            } else {
                tmf.init((KeyStore)null);
            }
            trustManagerList.addAll(Arrays.asList(tmf.getTrustManagers()));
            ArrayList<X509TrustManager> finalTrustManagerList = new ArrayList<X509TrustManager>();
            for (TrustManager tm : trustManagerList) {
                if (!(tm instanceof X509TrustManager)) continue;
                finalTrustManagerList.add((X509TrustManager)tm);
            }
            boolean isVerifySSLEnable = !this.options.insecureSkipVerify();
            CompositeX509TrustManager compositeX509TrustManager = new CompositeX509TrustManager(finalTrustManagerList);
            compositeX509TrustManager.setVerifySSL(isVerifySSLEnable);
            KeyManager[] keyManagers = null;
            if (this.keyManagers != null) {
                keyManagers = this.keyManagers;
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{compositeX509TrustManager}, this.secureRandom);
            Object hostnameVerifier = null;
            hostnameVerifier = !isVerifySSLEnable ? new NoopHostnameVerifier() : (this.hostnameVerifier != null ? this.hostnameVerifier : new DefaultHostnameVerifier());
            tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(sslContext).setHostnameVerifier((HostnameVerifier)hostnameVerifier).buildClassic();
        }
        catch (Exception e) {
            throw new RuntimeException("SSLContext fail", e);
        }
        ConnectionConfig.Builder connConfigBuilder = ConnectionConfig.custom().setConnectTimeout(Apache5HttpClientBuilder.millistoTimeout(this.connectionTimeout)).setValidateAfterInactivity((TimeValue)Apache5HttpClientBuilder.millistoTimeout(2000L)).setSocketTimeout(Apache5HttpClientBuilder.millistoTimeout(this.responseTimeout));
        if (this.connectionTTL > 0L) {
            connConfigBuilder.setTimeToLive((TimeValue)Apache5HttpClientBuilder.millistoTimeout(this.connectionTTL));
        }
        ConnectionConfig connConfig = connConfigBuilder.build();
        PoolingHttpClientConnectionManagerBuilder builder = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy(tlsStrategy).setDnsResolver(this.dnsResolver).setDefaultConnectionConfig(connConfig).setMaxConnPerRoute(this.maxConnections).setMaxConnTotal(this.maxConnections);
        return builder.build();
    }

    private RequestConfig createRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setResponseTimeout(Apache5HttpClientBuilder.millistoTimeout(this.responseTimeout));
        builder.setConnectionRequestTimeout(Apache5HttpClientBuilder.millistoTimeout(this.connectionRequestTimeout));
        builder.setRedirectsEnabled(this.options.redirectsEnabled());
        return builder.build();
    }

    private static class SdkConnectionKeepAliveStrategy
    implements ConnectionKeepAliveStrategy {
        private final TimeValue maxIdleTime;

        public SdkConnectionKeepAliveStrategy(long maxIdleTime) {
            this.maxIdleTime = TimeValue.of((long)maxIdleTime, (TimeUnit)TimeUnit.MILLISECONDS);
        }

        public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
            TimeValue duration = DefaultConnectionKeepAliveStrategy.INSTANCE.getKeepAliveDuration(response, context);
            if (TimeValue.isPositive((TimeValue)duration) && duration.compareTo(this.maxIdleTime) < 0) {
                return duration;
            }
            return this.maxIdleTime;
        }
    }

    private static class CompositeX509TrustManager
    implements X509TrustManager {
        private final List<X509TrustManager> trustManagers;
        private boolean verifySSL = true;

        public CompositeX509TrustManager(List<X509TrustManager> trustManagers) {
            this.trustManagers = trustManagers;
        }

        public boolean isVerifySSL() {
            return this.verifySSL;
        }

        public void setVerifySSL(boolean verifySSL) {
            this.verifySSL = verifySSL;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (!this.verifySSL) {
                return;
            }
            for (X509TrustManager trustManager : this.trustManagers) {
                try {
                    trustManager.checkServerTrusted(chain, authType);
                    return;
                }
                catch (CertificateException certificateException) {
                }
            }
            throw new CertificateException("None of the TrustManagers trust this certificate chain");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            for (X509TrustManager trustManager : this.trustManagers) {
                X509Certificate[] accepts = trustManager.getAcceptedIssuers();
                if (accepts == null || accepts.length <= 0) continue;
                certificates.addAll(Arrays.asList(accepts));
            }
            X509Certificate[] certificatesArray = new X509Certificate[certificates.size()];
            return certificates.toArray(certificatesArray);
        }
    }
}

