/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport.apache5client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;

public class ByteBufferAsyncEntityProducer
implements AsyncEntityProducer {
    private final ByteBuffer bytebuf;
    private final int length;
    private final ContentType contentType;
    private final boolean chunked;
    private final AtomicReference<Exception> exception;

    public ByteBufferAsyncEntityProducer(ByteBuffer content, ContentType contentType, boolean chunked) {
        Args.notNull((Object)content, (String)"Content");
        this.bytebuf = content;
        this.length = this.bytebuf.remaining();
        this.contentType = contentType;
        this.chunked = chunked;
        this.exception = new AtomicReference();
    }

    public ByteBufferAsyncEntityProducer(ByteBuffer content, ContentType contentType) {
        this(content, contentType, false);
    }

    public boolean isRepeatable() {
        return true;
    }

    public final String getContentType() {
        return Objects.toString(this.contentType, null);
    }

    public long getContentLength() {
        return this.length;
    }

    public int available() {
        return Integer.MAX_VALUE;
    }

    public String getContentEncoding() {
        return null;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    public final void produce(DataStreamChannel channel) throws IOException {
        if (this.bytebuf.hasRemaining()) {
            channel.write(this.bytebuf);
        }
        if (!this.bytebuf.hasRemaining()) {
            channel.endStream();
        }
    }

    public final void failed(Exception cause) {
        if (this.exception.compareAndSet(null, cause)) {
            this.releaseResources();
        }
    }

    public final Exception getException() {
        return this.exception.get();
    }

    public void releaseResources() {
        this.bytebuf.clear();
        this.bytebuf.limit(this.length);
    }
}

