/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport.apache5client;

import com.aliyun.sdk.service.oss2.transport.BinaryDataConsumerSupplier;
import com.aliyun.sdk.service.oss2.transport.apache5client.ByteChannelAsyncEntityConsumer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.concurrent.CallbackContribution;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.ByteArrayBuffer;

public class CustomAsyncResponseConsumer
implements AsyncResponseConsumer<SimpleHttpResponse> {
    private final BinaryDataConsumerSupplier dataConsumerSupplier;
    private final AtomicReference<AsyncEntityConsumer<byte[]>> dataConsumerRef;

    public CustomAsyncResponseConsumer(BinaryDataConsumerSupplier dataConsumerSupplier) {
        this.dataConsumerSupplier = dataConsumerSupplier;
        this.dataConsumerRef = new AtomicReference();
    }

    private SimpleHttpResponse buildResult(HttpResponse response, byte[] entity, ContentType contentType) {
        SimpleHttpResponse simpleResponse = SimpleHttpResponse.copy((HttpResponse)response);
        if (entity != null) {
            simpleResponse.setBody(entity, contentType);
        }
        return simpleResponse;
    }

    private AsyncEntityConsumer<byte[]> getEntityConsumer(int statusCode) {
        if (this.dataConsumerSupplier == null || statusCode == 203 || statusCode / 100 != 2) {
            return new SimpleAsyncEntityConsumer();
        }
        Object inst = this.dataConsumerSupplier.get();
        if (inst instanceof WritableByteChannel) {
            return new ByteChannelAsyncEntityConsumer((WritableByteChannel)inst, this.dataConsumerSupplier.autoRelease());
        }
        throw new UnsupportedOperationException("Only supports WritableByteChannel, but got " + inst.getClass().getName());
    }

    public final void consumeResponse(final HttpResponse response, final EntityDetails entityDetails, HttpContext httpContext, final FutureCallback<SimpleHttpResponse> resultCallback) throws HttpException, IOException {
        if (entityDetails != null) {
            AsyncEntityConsumer<byte[]> dataConsumer = this.getEntityConsumer(response.getCode());
            if (dataConsumer == null) {
                throw new HttpException("Supplied data consumer is null");
            }
            this.dataConsumerRef.set(dataConsumer);
            dataConsumer.streamStart(entityDetails, (FutureCallback)new CallbackContribution<byte[]>(resultCallback){

                public void completed(byte[] entity) {
                    block3: {
                        try {
                            ContentType contentType = ContentType.parse((CharSequence)entityDetails.getContentType());
                            SimpleHttpResponse result = CustomAsyncResponseConsumer.this.buildResult(response, entity, contentType);
                            if (resultCallback != null) {
                                resultCallback.completed((Object)result);
                            }
                        }
                        catch (UnsupportedCharsetException ex) {
                            if (resultCallback == null) break block3;
                            resultCallback.failed((Exception)ex);
                        }
                    }
                }
            });
        } else {
            SimpleHttpResponse result = this.buildResult(response, null, null);
            if (resultCallback != null) {
                resultCallback.completed((Object)result);
            }
        }
    }

    public void informationResponse(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
    }

    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        AsyncEntityConsumer<byte[]> dataConsumer = this.dataConsumerRef.get();
        if (dataConsumer != null) {
            dataConsumer.updateCapacity(capacityChannel);
        } else {
            capacityChannel.update(Integer.MAX_VALUE);
        }
    }

    public final void consume(ByteBuffer src) throws IOException {
        AsyncEntityConsumer<byte[]> dataConsumer = this.dataConsumerRef.get();
        if (dataConsumer != null) {
            dataConsumer.consume(src);
        }
    }

    public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        AsyncEntityConsumer<byte[]> dataConsumer = this.dataConsumerRef.get();
        if (dataConsumer != null) {
            dataConsumer.streamEnd(trailers);
        }
    }

    public final void failed(Exception cause) {
        this.releaseResources();
    }

    public final void releaseResources() {
        AsyncEntityConsumer dataConsumer = this.dataConsumerRef.getAndSet(null);
        if (dataConsumer != null) {
            dataConsumer.releaseResources();
        }
    }

    static class SimpleAsyncEntityConsumer
    extends AbstractBinAsyncEntityConsumer<byte[]> {
        private final ByteArrayBuffer buffer = new ByteArrayBuffer(1024);

        SimpleAsyncEntityConsumer() {
        }

        protected void streamStart(ContentType contentType) throws HttpException, IOException {
        }

        protected int capacityIncrement() {
            return Integer.MAX_VALUE;
        }

        protected void data(ByteBuffer src, boolean endOfStream) throws IOException {
            if (src == null) {
                return;
            }
            if (src.hasArray()) {
                this.buffer.append(src.array(), src.arrayOffset() + src.position(), src.remaining());
            } else {
                while (src.hasRemaining()) {
                    this.buffer.append((int)src.get());
                }
            }
        }

        protected byte[] generateContent() throws IOException {
            return this.buffer.toByteArray();
        }

        public void releaseResources() {
            this.buffer.clear();
        }
    }
}

