/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.transport.apache5client;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.util.TimeValue;

public final class IdleConnectionReaper {
    private static final Duration REAP_INTERVAL = Duration.ofSeconds(10L);
    private static final IdleConnectionReaper INSTANCE = new IdleConnectionReaper();
    private final Map<PoolingHttpClientConnectionManager, Long> connectionManagers;
    private final Supplier<ExecutorService> executorServiceSupplier;
    private final long sleepPeriod;
    private volatile ExecutorService exec;
    private volatile ReaperTask reaperTask;

    private IdleConnectionReaper() {
        this.connectionManagers = Collections.synchronizedMap(new WeakHashMap());
        this.executorServiceSupplier = () -> {
            ExecutorService e = Executors.newSingleThreadExecutor(r -> {
                Thread t = new Thread(r, "idle-connection-reaper");
                t.setDaemon(true);
                return t;
            });
            return e;
        };
        this.sleepPeriod = REAP_INTERVAL.toMillis();
    }

    IdleConnectionReaper(Map<PoolingHttpClientConnectionManager, Long> connectionManagers, Supplier<ExecutorService> executorServiceSupplier, long sleepPeriod) {
        this.connectionManagers = connectionManagers;
        this.executorServiceSupplier = executorServiceSupplier;
        this.sleepPeriod = sleepPeriod;
    }

    public static IdleConnectionReaper getInstance() {
        return INSTANCE;
    }

    public synchronized boolean registerConnectionManager(PoolingHttpClientConnectionManager manager, long maxIdleTime) {
        boolean notPreviouslyRegistered = this.connectionManagers.put(manager, maxIdleTime) == null;
        this.setupExecutorIfNecessary();
        return notPreviouslyRegistered;
    }

    public synchronized boolean deregisterConnectionManager(HttpClientConnectionManager manager) {
        boolean wasRemoved = this.connectionManagers.remove(manager) != null;
        this.cleanupExecutorIfNecessary();
        return wasRemoved;
    }

    private void setupExecutorIfNecessary() {
        if (this.exec != null) {
            return;
        }
        ExecutorService e = this.executorServiceSupplier.get();
        this.reaperTask = new ReaperTask(this.connectionManagers, this.sleepPeriod);
        e.execute(this.reaperTask);
        this.exec = e;
    }

    private void cleanupExecutorIfNecessary() {
        if (this.exec == null || !this.connectionManagers.isEmpty()) {
            return;
        }
        this.reaperTask.stop();
        this.reaperTask = null;
        this.exec.shutdownNow();
        this.exec = null;
    }

    private static final class ReaperTask
    implements Runnable {
        private final Map<PoolingHttpClientConnectionManager, Long> connectionManagers;
        private final long sleepPeriod;
        private volatile boolean stopping = false;

        private ReaperTask(Map<PoolingHttpClientConnectionManager, Long> connectionManagers, long sleepPeriod) {
            this.connectionManagers = connectionManagers;
            this.sleepPeriod = sleepPeriod;
        }

        @Override
        public void run() {
            while (!this.stopping) {
                try {
                    Thread.sleep(this.sleepPeriod);
                    for (Map.Entry<PoolingHttpClientConnectionManager, Long> entry : this.connectionManagers.entrySet()) {
                        try {
                            entry.getKey().closeIdle(TimeValue.ofMilliseconds((long)entry.getValue()));
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }

        private void stop() {
            this.stopping = true;
        }
    }
}

