/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.utils;

import com.aliyun.sdk.service.oss2.Validate;
import com.aliyun.sdk.service.oss2.utils.FunctionalUtils;
import com.aliyun.sdk.service.oss2.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class HttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String[] ENCODED_CHARACTERS_WITH_SLASHES = new String[]{"+", "*", "%7E", "%2F"};
    private static final String[] ENCODED_CHARACTERS_WITH_SLASHES_REPLACEMENTS = new String[]{"%20", "%2A", "~", "/"};
    private static final String[] ENCODED_CHARACTERS_WITHOUT_SLASHES = new String[]{"+", "*", "%7E"};
    private static final String[] ENCODED_CHARACTERS_WITHOUT_SLASHES_REPLACEMENTS = new String[]{"%20", "%2A", "~"};

    private HttpUtils() {
    }

    public static String urlEncode(String value) {
        return HttpUtils.urlEncode(value, false);
    }

    public static String urlEncodePath(String value) {
        return HttpUtils.urlEncode(value, true);
    }

    public static String urlDecode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to decode value", e);
        }
    }

    private static String urlEncode(String value, boolean ignoreSlashes) {
        if (value == null) {
            return null;
        }
        String encoded = FunctionalUtils.invokeSafely(() -> URLEncoder.encode(value, DEFAULT_ENCODING));
        if (!ignoreSlashes) {
            return StringUtils.replaceEach(encoded, ENCODED_CHARACTERS_WITHOUT_SLASHES, ENCODED_CHARACTERS_WITHOUT_SLASHES_REPLACEMENTS);
        }
        return StringUtils.replaceEach(encoded, ENCODED_CHARACTERS_WITH_SLASHES, ENCODED_CHARACTERS_WITH_SLASHES_REPLACEMENTS);
    }

    public static String appendUri(String baseUri, String path) {
        Validate.paramNotNull(baseUri, "baseUri");
        StringBuilder resultUri = new StringBuilder(baseUri);
        if (!StringUtils.isEmpty(path)) {
            if (!baseUri.endsWith("/")) {
                resultUri.append("/");
            }
            resultUri.append(path.startsWith("/") ? path.substring(1) : path);
        }
        return resultUri.toString();
    }

    public static Optional<String> encodeQueryParameters(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return Optional.empty();
        }
        boolean first = true;
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, String> p : parameters.entrySet()) {
            String key = p.getKey();
            String value = p.getValue();
            if (!first) {
                queryString.append("&");
            }
            queryString.append(HttpUtils.urlEncode(key));
            if (value != null) {
                queryString.append("=").append(HttpUtils.urlEncode(value));
            }
            first = false;
        }
        return Optional.of(queryString.toString());
    }

    /*
     * Exception decompiling
     */
    public static Map<String, String> uriParams(URI uri) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, String> uriEncodedParams(URI uri) {
        return HttpUtils.splitQueryString(uri.getRawQuery()).stream().map(s -> s.split("=")).map(s -> {
            String[] stringArray;
            if (((String[])s).length == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            } else {
                stringArray = s;
            }
            return stringArray;
        }).map(s -> {
            String[] stringArray;
            if (((String[])s).length == 1) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = s[0];
                stringArray = stringArray2;
                stringArray2[1] = "";
            } else {
                stringArray = s;
            }
            return stringArray;
        }).collect(Collectors.toMap(s -> s[0], s -> s[1], (oldValue, newValue) -> oldValue));
    }

    public static List<String> splitQueryString(String queryString) {
        ArrayList<String> results = new ArrayList<String>();
        if (StringUtils.isEmpty(queryString)) {
            return results;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < queryString.length(); ++i) {
            char character = queryString.charAt(i);
            if (character != '&') {
                result.append(character);
                continue;
            }
            results.add(StringUtils.trimToEmpty(result.toString()));
            result.setLength(0);
        }
        results.add(StringUtils.trimToEmpty(result.toString()));
        return results;
    }

    private static /* synthetic */ String lambda$uriParams$7(String oldValue, String newValue) {
        return oldValue;
    }

    private static /* synthetic */ String lambda$uriParams$6(String[] s) {
        return s[1];
    }

    private static /* synthetic */ String lambda$uriParams$5(String[] s) {
        return s[0];
    }
}

