/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.utils;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int EOF = -1;
    private static final byte[] SCRATCH_BYTE_BUFFER_WO = IOUtils.byteArray();

    private IOUtils() {
    }

    public static OutputStream discradOutputStream() {
        return new OutputStream(){
            private volatile boolean closed;

            private void ensureOpen() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
            }

            @Override
            public void write(int b) throws IOException {
                this.ensureOpen();
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.ensureOpen();
            }

            @Override
            public void close() {
                this.closed = true;
            }
        };
    }

    public static void closeQuietly(AutoCloseable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeIfCloseable(Object maybeCloseable) {
        if (maybeCloseable instanceof AutoCloseable) {
            IOUtils.closeQuietly((AutoCloseable)maybeCloseable);
        }
    }

    public static byte[] byteArray() {
        return IOUtils.byteArray(8192);
    }

    public static byte[] byteArray(int size) {
        return new byte[size];
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, IOUtils.byteArray(8192));
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int n;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long count = 0L;
        while (-1 != (n = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        return IOUtils.copyLarge(inputStream, outputStream, IOUtils.byteArray(bufferSize));
    }

    public static long copyLarge(InputStream input, OutputStream output, long inputOffset, long length, byte[] buffer) throws IOException {
        int read;
        int bufferLength;
        if (inputOffset > 0L) {
            IOUtils.skipFully(input, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = bufferLength = buffer.length;
        if (length > 0L && length < (long)bufferLength) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read = input.read(buffer, 0, bytesToRead))) {
            output.write(buffer, 0, read);
            totalRead += (long)read;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)bufferLength);
        }
        return totalRead;
    }

    public static long copyLarge(InputStream input, OutputStream output, long inputOffset, long length) throws IOException {
        return IOUtils.copyLarge(input, output, inputOffset, length, IOUtils.byteArray());
    }

    public static long skip(InputStream input, long skip, byte[] skipBuffer) throws IOException {
        long remain;
        long n;
        if (skip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + skip);
        }
        if (skipBuffer == null) {
            skipBuffer = SCRATCH_BYTE_BUFFER_WO;
        }
        for (remain = skip; remain > 0L && (n = (long)input.read(skipBuffer, 0, (int)Math.min(remain, (long)skipBuffer.length))) >= 0L; remain -= n) {
        }
        return skip - remain;
    }

    public static void skipFully(InputStream input, long toSkip) throws IOException {
        long skipped = IOUtils.skip(input, toSkip, SCRATCH_BYTE_BUFFER_WO);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static long consume(InputStream input) throws IOException {
        return IOUtils.copyLarge(input, IOUtils.discradOutputStream(), IOUtils.byteArray());
    }

    public static byte[] toByteArray(InputStream inputStream) {
        if (inputStream == null) {
            return new byte[0];
        }
        try {
            AccessibleByteArrayOutputStream dataOutputBuffer = new AccessibleByteArrayOutputStream();
            IOUtils.copyLarge(inputStream, dataOutputBuffer);
            return dataOutputBuffer.toByteArrayUnsafe();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static class AccessibleByteArrayOutputStream
    extends ByteArrayOutputStream {
        public AccessibleByteArrayOutputStream() {
        }

        public AccessibleByteArrayOutputStream(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public byte[] toByteArray() {
            return Arrays.copyOf(this.buf, this.count);
        }

        public byte[] toByteArrayUnsafe() {
            return this.buf.length == this.count ? this.buf : this.toByteArray();
        }

        public ByteBuffer toByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.count).asReadOnlyBuffer();
        }

        public int count() {
            return this.count;
        }
    }
}

