/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InetAddressUtils {
    private static final int MAX_BYTE = 128;
    private static final int IPV4_MAX_OCTET_VALUE = 255;
    private static final int MAX_UNSIGNED_SHORT = 65535;
    private static final int BASE_16 = 16;
    private static final String IPV4_REGEX = "^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$";
    private static final int IPV6_MAX_HEX_GROUPS = 8;
    private static final int IPV6_MAX_HEX_DIGITS_PER_GROUP = 4;
    private static final Pattern DIGITS_PATTERN = Pattern.compile("\\d{1,3}");
    private static final Pattern ID_CHECK_PATTERN = Pattern.compile("[^\\s/%]+");

    public static boolean isValid(String inetAddress) {
        return InetAddressUtils.isValidInet4Address(inetAddress) || InetAddressUtils.isValidInet6Address(inetAddress);
    }

    public static boolean isValidInet4Address(String inet4Address) {
        String[] groups = InetAddressUtils.ipv4Match(inet4Address);
        if (groups == null) {
            return false;
        }
        for (String ipSegment : groups) {
            if (InetAddressUtils.isBlankOrNull(ipSegment)) {
                return false;
            }
            int iIpSegment = 0;
            try {
                iIpSegment = Integer.parseInt(ipSegment);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (iIpSegment <= 255 && (ipSegment.length() <= 1 || !ipSegment.startsWith("0"))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidInet6Address(String inet6Address) {
        String[] parts = inet6Address.split("/", -1);
        if (parts.length > 2) {
            return false;
        }
        if (parts.length == 2) {
            if (!DIGITS_PATTERN.matcher(parts[1]).matches()) {
                return false;
            }
            int bits = Integer.parseInt(parts[1]);
            if (bits < 0 || bits > 128) {
                return false;
            }
        }
        if ((parts = parts[0].split("%", -1)).length > 2 || parts.length == 2 && !ID_CHECK_PATTERN.matcher(parts[1]).matches()) {
            return false;
        }
        inet6Address = parts[0];
        boolean containsCompressedZeroes = inet6Address.contains("::");
        if (containsCompressedZeroes && inet6Address.indexOf("::") != inet6Address.lastIndexOf("::")) {
            return false;
        }
        boolean startsWithCompressed = inet6Address.startsWith("::");
        boolean endsWithCompressed = inet6Address.endsWith("::");
        boolean endsWithSep = inet6Address.endsWith(":");
        if (inet6Address.startsWith(":") && !startsWithCompressed || endsWithSep && !endsWithCompressed) {
            return false;
        }
        String[] octets = inet6Address.split(":");
        if (containsCompressedZeroes) {
            ArrayList<String> octetList = new ArrayList<String>(Arrays.asList(octets));
            if (endsWithCompressed) {
                octetList.add("");
            } else if (startsWithCompressed && !octetList.isEmpty()) {
                octetList.remove(0);
            }
            octets = octetList.toArray(new String[0]);
        }
        if (octets.length > 8) {
            return false;
        }
        int validOctets = 0;
        int emptyOctets = 0;
        for (int index = 0; index < octets.length; ++index) {
            String octet = octets[index];
            if (InetAddressUtils.isBlankOrNull(octet)) {
                if (++emptyOctets > 1) {
                    return false;
                }
            } else {
                emptyOctets = 0;
                if (index == octets.length - 1 && octet.contains(".")) {
                    if (!InetAddressUtils.isValidInet4Address(octet)) {
                        return false;
                    }
                    validOctets += 2;
                    continue;
                }
                if (octet.length() > 4) {
                    return false;
                }
                int octetInt = 0;
                try {
                    octetInt = Integer.parseInt(octet, 16);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (octetInt < 0 || octetInt > 65535) {
                    return false;
                }
            }
            ++validOctets;
        }
        return validOctets <= 8 && (validOctets >= 8 || containsCompressedZeroes);
    }

    static boolean isBlankOrNull(String value) {
        return value == null || value.isEmpty() || value.trim().isEmpty();
    }

    static String[] ipv4Match(String value) {
        if (value == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(IPV4_REGEX);
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            int count = matcher.groupCount();
            String[] groups = new String[count];
            for (int j = 0; j < count; ++j) {
                groups[j] = matcher.group(j + 1);
            }
            return groups;
        }
        return null;
    }
}

