/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MimeUtils {
    public static final String DEFAULT_MIMETYPE = "application/octet-stream";
    private static Map<String, String> userMappings = new HashMap<String, String>(){};
    private static final Map<String, String> defaultMappings = new HashMap<String, String>(){
        {
            this.put(".xlam", "application/vnd.ms-excel.addin.macroEnabled.12");
            this.put(".xlsb", "application/vnd.ms-excel.sheet.binary.macroEnabled.12");
            this.put(".apk", "application/vnd.android.package-archive");
            this.put(".hqx", "application/mac-binhex40");
            this.put(".cpt", "application/mac-compactpro");
            this.put(".doc", "application/msword");
            this.put(".ogg", "application/ogg");
            this.put(".pdf", "application/pdf");
            this.put(".rtf", "text/rtf");
            this.put(".mif", "application/vnd.mif");
            this.put(".xls", "application/vnd.ms-excel");
            this.put(".ppt", "application/vnd.ms-powerpoint");
            this.put(".sxw", "application/vnd.sun.xml.writer");
            this.put(".stw", "application/vnd.sun.xml.writer.template");
            this.put(".sxc", "application/vnd.sun.xml.calc");
            this.put(".stc", "application/vnd.sun.xml.calc.template");
            this.put(".sxd", "application/vnd.sun.xml.draw");
            this.put(".std", "application/vnd.sun.xml.draw.template");
            this.put(".sxi", "application/vnd.sun.xml.impress");
            this.put(".sti", "application/vnd.sun.xml.impress.template");
            this.put(".sxg", "application/vnd.sun.xml.writer.global");
            this.put(".sxm", "application/vnd.sun.xml.math");
            this.put(".sis", "application/vnd.symbian.install");
            this.put(".wbxml", "application/vnd.wap.wbxml");
            this.put(".wmlc", "application/vnd.wap.wmlc");
            this.put(".wmlsc", "application/vnd.wap.wmlscriptc");
            this.put(".bcpio", "application/x-bcpio");
            this.put(".torrent", "application/x-bittorrent");
            this.put(".bz2", "application/x-bzip2");
            this.put(".vcd", "application/x-cdlink");
            this.put(".pgn", "application/x-chess-pgn");
            this.put(".cpio", "application/x-cpio");
            this.put(".csh", "application/x-csh");
            this.put(".dvi", "application/x-dvi");
            this.put(".spl", "application/x-futuresplash");
            this.put(".gtar", "application/x-gtar");
            this.put(".hdf", "application/x-hdf");
            this.put(".jar", "application/x-java-archive");
            this.put(".jnlp", "application/x-java-jnlp-file");
            this.put(".js", "application/x-javascript");
            this.put(".ksp", "application/x-kspread");
            this.put(".chrt", "application/x-kchart");
            this.put(".kil", "application/x-killustrator");
            this.put(".latex", "application/x-latex");
            this.put(".rpm", "application/x-rpm");
            this.put(".sh", "application/x-sh");
            this.put(".shar", "application/x-shar");
            this.put(".swf", "application/x-shockwave-flash");
            this.put(".sit", "application/x-stuffit");
            this.put(".sv4cpio", "application/x-sv4cpio");
            this.put(".sv4crc", "application/x-sv4crc");
            this.put(".tar", "application/x-tar");
            this.put(".tcl", "application/x-tcl");
            this.put(".tex", "application/x-tex");
            this.put(".man", "application/x-troff-man");
            this.put(".me", "application/x-troff-me");
            this.put(".ms", "application/x-troff-ms");
            this.put(".ustar", "application/x-ustar");
            this.put(".src", "application/x-wais-source");
            this.put(".zip", "application/zip");
            this.put(".m3u", "audio/x-mpegurl");
            this.put(".ra", "audio/x-pn-realaudio");
            this.put(".wav", "audio/x-wav");
            this.put(".wma", "audio/x-ms-wma");
            this.put(".wax", "audio/x-ms-wax");
            this.put(".pdb", "chemical/x-pdb");
            this.put(".xyz", "chemical/x-xyz");
            this.put(".bmp", "image/bmp");
            this.put(".gif", "image/gif");
            this.put(".ief", "image/ief");
            this.put(".png", "image/png");
            this.put(".wbmp", "image/vnd.wap.wbmp");
            this.put(".ras", "image/x-cmu-raster");
            this.put(".pnm", "image/x-portable-anymap");
            this.put(".pbm", "image/x-portable-bitmap");
            this.put(".pgm", "image/x-portable-graymap");
            this.put(".ppm", "image/x-portable-pixmap");
            this.put(".rgb", "image/x-rgb");
            this.put(".xbm", "image/x-xbitmap");
            this.put(".xpm", "image/x-xpixmap");
            this.put(".xwd", "image/x-xwindowdump");
            this.put(".css", "text/css");
            this.put(".rtx", "text/richtext");
            this.put(".tsv", "text/tab-separated-values");
            this.put(".jad", "text/vnd.sun.j2me.app-descriptor");
            this.put(".wml", "text/vnd.wap.wml");
            this.put(".wmls", "text/vnd.wap.wmlscript");
            this.put(".etx", "text/x-setext");
            this.put(".mxu", "video/vnd.mpegurl");
            this.put(".flv", "video/x-flv");
            this.put(".wm", "video/x-ms-wm");
            this.put(".wmv", "video/x-ms-wmv");
            this.put(".wmx", "video/x-ms-wmx");
            this.put(".wvx", "video/x-ms-wvx");
            this.put(".avi", "video/x-msvideo");
            this.put(".movie", "video/x-sgi-movie");
            this.put(".ice", "x-conference/x-cooltalk");
            this.put(".3gp", "video/3gpp");
            this.put(".ai", "application/postscript");
            this.put(".aif", "audio/x-aiff");
            this.put(".aifc", "audio/x-aiff");
            this.put(".aiff", "audio/x-aiff");
            this.put(".asc", "text/plain");
            this.put(".atom", "application/atom+xml");
            this.put(".au", "audio/basic");
            this.put(".bin", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".cdf", "application/x-netcdf");
            this.put(".cgm", "image/cgm");
            this.put(".class", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".dcr", "application/x-director");
            this.put(".dif", "video/x-dv");
            this.put(".dir", "application/x-director");
            this.put(".djv", "image/vnd.djvu");
            this.put(".djvu", "image/vnd.djvu");
            this.put(".dll", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".dmg", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".dms", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".dtd", "application/xml-dtd");
            this.put(".dv", "video/x-dv");
            this.put(".dxr", "application/x-director");
            this.put(".eps", "application/postscript");
            this.put(".exe", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".ez", "application/andrew-inset");
            this.put(".gram", "application/srgs");
            this.put(".grxml", "application/srgs+xml");
            this.put(".gz", "application/x-gzip");
            this.put(".htm", "text/html");
            this.put(".html", "text/html");
            this.put(".ico", "image/x-icon");
            this.put(".ics", "text/calendar");
            this.put(".ifb", "text/calendar");
            this.put(".iges", "model/iges");
            this.put(".igs", "model/iges");
            this.put(".jp2", "image/jp2");
            this.put(".jpe", "image/jpeg");
            this.put(".jpeg", "image/jpeg");
            this.put(".jpg", "image/jpeg");
            this.put(".kar", "audio/midi");
            this.put(".lha", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".lzh", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".m4a", "audio/mp4a-latm");
            this.put(".m4p", "audio/mp4a-latm");
            this.put(".m4u", "video/vnd.mpegurl");
            this.put(".m4v", "video/x-m4v");
            this.put(".mac", "image/x-macpaint");
            this.put(".mathml", "application/mathml+xml");
            this.put(".mesh", "model/mesh");
            this.put(".mid", "audio/midi");
            this.put(".midi", "audio/midi");
            this.put(".mov", "video/quicktime");
            this.put(".mp2", "audio/mpeg");
            this.put(".mp3", "audio/mpeg");
            this.put(".mp4", "video/mp4");
            this.put(".mpe", "video/mpeg");
            this.put(".mpeg", "video/mpeg");
            this.put(".mpg", "video/mpeg");
            this.put(".mpga", "audio/mpeg");
            this.put(".msh", "model/mesh");
            this.put(".nc", "application/x-netcdf");
            this.put(".oda", "application/oda");
            this.put(".ogv", "video/ogv");
            this.put(".pct", "image/pict");
            this.put(".pic", "image/pict");
            this.put(".pict", "image/pict");
            this.put(".pnt", "image/x-macpaint");
            this.put(".pntg", "image/x-macpaint");
            this.put(".ps", "application/postscript");
            this.put(".qt", "video/quicktime");
            this.put(".qti", "image/x-quicktime");
            this.put(".qtif", "image/x-quicktime");
            this.put(".ram", "audio/x-pn-realaudio");
            this.put(".rdf", "application/rdf+xml");
            this.put(".rm", "application/vnd.rn-realmedia");
            this.put(".roff", "application/x-troff");
            this.put(".sgm", "text/sgml");
            this.put(".sgml", "text/sgml");
            this.put(".silo", "model/mesh");
            this.put(".skd", "application/x-koan");
            this.put(".skm", "application/x-koan");
            this.put(".skp", "application/x-koan");
            this.put(".skt", "application/x-koan");
            this.put(".smi", "application/smil");
            this.put(".smil", "application/smil");
            this.put(".snd", "audio/basic");
            this.put(".so", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".svg", "image/svg+xml");
            this.put(".t", "application/x-troff");
            this.put(".texi", "application/x-texinfo");
            this.put(".texinfo", "application/x-texinfo");
            this.put(".tif", "image/tiff");
            this.put(".tiff", "image/tiff");
            this.put(".tr", "application/x-troff");
            this.put(".txt", "text/plain");
            this.put(".vrml", "model/vrml");
            this.put(".vxml", "application/voicexml+xml");
            this.put(".webm", "video/webm");
            this.put(".wrl", "model/vrml");
            this.put(".xht", "application/xhtml+xml");
            this.put(".xhtml", "application/xhtml+xml");
            this.put(".xml", "application/xml");
            this.put(".xsl", "application/xml");
            this.put(".xslt", "application/xslt+xml");
            this.put(".xul", "application/vnd.mozilla.xul+xml");
            this.put(".webp", "image/webp");
            this.put(".323", "text/h323");
            this.put(".aab", "application/x-authoware-bin");
            this.put(".aam", "application/x-authoware-map");
            this.put(".aas", "application/x-authoware-seg");
            this.put(".acx", "application/internet-property-stream");
            this.put(".als", "audio/X-Alpha5");
            this.put(".amc", "application/x-mpeg");
            this.put(".ani", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".asd", "application/astound");
            this.put(".asf", "video/x-ms-asf");
            this.put(".asn", "application/astound");
            this.put(".asp", "application/x-asap");
            this.put(".asr", "video/x-ms-asf");
            this.put(".asx", "video/x-ms-asf");
            this.put(".avb", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".awb", "audio/amr-wb");
            this.put(".axs", "application/olescript");
            this.put(".bas", "text/plain");
            this.put(".bin ", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".bld", "application/bld");
            this.put(".bld2", "application/bld2");
            this.put(".bpk", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".c", "text/plain");
            this.put(".cal", "image/x-cals");
            this.put(".cat", "application/vnd.ms-pkiseccat");
            this.put(".ccn", "application/x-cnc");
            this.put(".cco", "application/x-cocoa");
            this.put(".cer", "application/x-x509-ca-cert");
            this.put(".cgi", "magnus-internal/cgi");
            this.put(".chat", "application/x-chat");
            this.put(".clp", "application/x-msclip");
            this.put(".cmx", "image/x-cmx");
            this.put(".co", "application/x-cult3d-object");
            this.put(".cod", "image/cis-cod");
            this.put(".conf", "text/plain");
            this.put(".cpp", "text/plain");
            this.put(".crd", "application/x-mscardfile");
            this.put(".crl", "application/pkix-crl");
            this.put(".crt", "application/x-x509-ca-cert");
            this.put(".csm", "chemical/x-csml");
            this.put(".csml", "chemical/x-csml");
            this.put(".cur", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".dcm", "x-lml/x-evm");
            this.put(".dcx", "image/x-dcx");
            this.put(".der", "application/x-x509-ca-cert");
            this.put(".dhtml", "text/html");
            this.put(".dot", "application/msword");
            this.put(".dwf", "drawing/x-dwf");
            this.put(".dwg", "application/x-autocad");
            this.put(".dxf", "application/x-autocad");
            this.put(".ebk", "application/x-expandedbook");
            this.put(".emb", "chemical/x-embl-dl-nucleotide");
            this.put(".embl", "chemical/x-embl-dl-nucleotide");
            this.put(".epub", "application/epub+zip");
            this.put(".eri", "image/x-eri");
            this.put(".es", "audio/echospeech");
            this.put(".esl", "audio/echospeech");
            this.put(".etc", "application/x-earthtime");
            this.put(".evm", "x-lml/x-evm");
            this.put(".evy", "application/envoy");
            this.put(".fh4", "image/x-freehand");
            this.put(".fh5", "image/x-freehand");
            this.put(".fhc", "image/x-freehand");
            this.put(".fif", "application/fractals");
            this.put(".flr", "x-world/x-vrml");
            this.put(".fm", "application/x-maker");
            this.put(".fpx", "image/x-fpx");
            this.put(".fvi", "video/isivideo");
            this.put(".gau", "chemical/x-gaussian-input");
            this.put(".gca", "application/x-gca-compressed");
            this.put(".gdb", "x-lml/x-gdb");
            this.put(".gps", "application/x-gps");
            this.put(".h", "text/plain");
            this.put(".hdm", "text/x-hdml");
            this.put(".hdml", "text/x-hdml");
            this.put(".hlp", "application/winhlp");
            this.put(".hta", "application/hta");
            this.put(".htc", "text/x-component");
            this.put(".hts", "text/html");
            this.put(".htt", "text/webviewhtml");
            this.put(".ifm", "image/gif");
            this.put(".ifs", "image/ifs");
            this.put(".iii", "application/x-iphone");
            this.put(".imy", "audio/melody");
            this.put(".ins", "application/x-internet-signup");
            this.put(".ips", "application/x-ipscript");
            this.put(".ipx", "application/x-ipix");
            this.put(".isp", "application/x-internet-signup");
            this.put(".it", "audio/x-mod");
            this.put(".itz", "audio/x-mod");
            this.put(".ivr", "i-world/i-vrml");
            this.put(".j2k", "image/j2k");
            this.put(".jam", "application/x-jam");
            this.put(".java", "text/plain");
            this.put(".jfif", "image/pipeg");
            this.put(".jpz", "image/jpeg");
            this.put(".jwc", "application/jwc");
            this.put(".kjx", "application/x-kjx");
            this.put(".lak", "x-lml/x-lak");
            this.put(".lcc", "application/fastman");
            this.put(".lcl", "application/x-digitalloca");
            this.put(".lcr", "application/x-digitalloca");
            this.put(".lgh", "application/lgh");
            this.put(".lml", "x-lml/x-lml");
            this.put(".lmlpack", "x-lml/x-lmlpack");
            this.put(".log", "text/plain");
            this.put(".lsf", "video/x-la-asf");
            this.put(".lsx", "video/x-la-asf");
            this.put(".m13", "application/x-msmediaview");
            this.put(".m14", "application/x-msmediaview");
            this.put(".m15", "audio/x-mod");
            this.put(".m3url", "audio/x-mpegurl");
            this.put(".m4b", "audio/mp4a-latm");
            this.put(".ma1", "audio/ma1");
            this.put(".ma2", "audio/ma2");
            this.put(".ma3", "audio/ma3");
            this.put(".ma5", "audio/ma5");
            this.put(".map", "magnus-internal/imagemap");
            this.put(".mbd", "application/mbedlet");
            this.put(".mct", "application/x-mascot");
            this.put(".mdb", "application/x-msaccess");
            this.put(".mdz", "audio/x-mod");
            this.put(".mel", "text/x-vmel");
            this.put(".mht", "message/rfc822");
            this.put(".mhtml", "message/rfc822");
            this.put(".mi", "application/x-mif");
            this.put(".mil", "image/x-cals");
            this.put(".mio", "audio/x-mio");
            this.put(".mmf", "application/x-skt-lbs");
            this.put(".mng", "video/x-mng");
            this.put(".mny", "application/x-msmoney");
            this.put(".moc", "application/x-mocha");
            this.put(".mocha", "application/x-mocha");
            this.put(".mod", "audio/x-mod");
            this.put(".mof", "application/x-yumekara");
            this.put(".mol", "chemical/x-mdl-molfile");
            this.put(".mop", "chemical/x-mopac-input");
            this.put(".mpa", "video/mpeg");
            this.put(".mpc", "application/vnd.mpohun.certificate");
            this.put(".mpg4", "video/mp4");
            this.put(".mpn", "application/vnd.mophun.application");
            this.put(".mpp", "application/vnd.ms-project");
            this.put(".mps", "application/x-mapserver");
            this.put(".mpv2", "video/mpeg");
            this.put(".mrl", "text/x-mrml");
            this.put(".mrm", "application/x-mrm");
            this.put(".msg", "application/vnd.ms-outlook");
            this.put(".mts", "application/metastream");
            this.put(".mtx", "application/metastream");
            this.put(".mtz", "application/metastream");
            this.put(".mvb", "application/x-msmediaview");
            this.put(".mzv", "application/metastream");
            this.put(".nar", "application/zip");
            this.put(".nbmp", "image/nbmp");
            this.put(".ndb", "x-lml/x-ndb");
            this.put(".ndwn", "application/ndwn");
            this.put(".nif", "application/x-nif");
            this.put(".nmz", "application/x-scream");
            this.put(".nokia-op-logo", "image/vnd.nok-oplogo-color");
            this.put(".npx", "application/x-netfpx");
            this.put(".nsnd", "audio/nsnd");
            this.put(".nva", "application/x-neva1");
            this.put(".nws", "message/rfc822");
            this.put(".oom", "application/x-AtlasMate-Plugin");
            this.put(".p10", "application/pkcs10");
            this.put(".p12", "application/x-pkcs12");
            this.put(".p7b", "application/x-pkcs7-certificates");
            this.put(".p7c", "application/x-pkcs7-mime");
            this.put(".p7m", "application/x-pkcs7-mime");
            this.put(".p7r", "application/x-pkcs7-certreqresp");
            this.put(".p7s", "application/x-pkcs7-signature");
            this.put(".pac", "audio/x-pac");
            this.put(".pae", "audio/x-epac");
            this.put(".pan", "application/x-pan");
            this.put(".pcx", "image/x-pcx");
            this.put(".pda", "image/x-pda");
            this.put(".pfr", "application/font-tdpfr");
            this.put(".pfx", "application/x-pkcs12");
            this.put(".pko", "application/ynd.ms-pkipko");
            this.put(".pm", "application/x-perl");
            this.put(".pma", "application/x-perfmon");
            this.put(".pmc", "application/x-perfmon");
            this.put(".pmd", "application/x-pmd");
            this.put(".pml", "application/x-perfmon");
            this.put(".pmr", "application/x-perfmon");
            this.put(".pmw", "application/x-perfmon");
            this.put(".pnz", "image/png");
            this.put(".pot,", "application/vnd.ms-powerpoint");
            this.put(".pps", "application/vnd.ms-powerpoint");
            this.put(".pqf", "application/x-cprplayer");
            this.put(".pqi", "application/cprplayer");
            this.put(".prc", "application/x-prc");
            this.put(".prf", "application/pics-rules");
            this.put(".prop", "text/plain");
            this.put(".proxy", "application/x-ns-proxy-autoconfig");
            this.put(".ptlk", "application/listenup");
            this.put(".pub", "application/x-mspublisher");
            this.put(".pvx", "video/x-pv-pvx");
            this.put(".qcp", "audio/vnd.qcelp");
            this.put(".r3t", "text/vnd.rn-realtext3d");
            this.put(".rar", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".rc", "text/plain");
            this.put(".rf", "image/vnd.rn-realflash");
            this.put(".rlf", "application/x-richlink");
            this.put(".rmf", "audio/x-rmf");
            this.put(".rmi", "audio/mid");
            this.put(".rmm", "audio/x-pn-realaudio");
            this.put(".rmvb", "audio/x-pn-realaudio");
            this.put(".rnx", "application/vnd.rn-realplayer");
            this.put(".rp", "image/vnd.rn-realpix");
            this.put(".rt", "text/vnd.rn-realtext");
            this.put(".rte", "x-lml/x-gps");
            this.put(".rtg", "application/metastream");
            this.put(".rv", "video/vnd.rn-realvideo");
            this.put(".rwc", "application/x-rogerwilco");
            this.put(".s3m", "audio/x-mod");
            this.put(".s3z", "audio/x-mod");
            this.put(".sca", "application/x-supercard");
            this.put(".scd", "application/x-msschedule");
            this.put(".sct", "text/scriptlet");
            this.put(".sdf", "application/e-score");
            this.put(".sea", "application/x-stuffit");
            this.put(".setpay", "application/set-payment-initiation");
            this.put(".setreg", "application/set-registration-initiation");
            this.put(".shtml", "text/html");
            this.put(".shtm", "text/html");
            this.put(".shw", "application/presentations");
            this.put(".si6", "image/si6");
            this.put(".si7", "image/vnd.stiwap.sis");
            this.put(".si9", "image/vnd.lgtwap.sis");
            this.put(".slc", "application/x-salsa");
            this.put(".smd", "audio/x-smd");
            this.put(".smp", "application/studiom");
            this.put(".smz", "audio/x-smd");
            this.put(".spc", "application/x-pkcs7-certificates");
            this.put(".spr", "application/x-sprite");
            this.put(".sprite", "application/x-sprite");
            this.put(".sdp", "application/sdp");
            this.put(".spt", "application/x-spt");
            this.put(".sst", "application/vnd.ms-pkicertstore");
            this.put(".stk", "application/hyperstudio");
            this.put(".stl", "application/vnd.ms-pkistl");
            this.put(".stm", "text/html");
            this.put(".svf", "image/vnd");
            this.put(".svh", "image/svh");
            this.put(".svr", "x-world/x-svr");
            this.put(".swfl", "application/x-shockwave-flash");
            this.put(".tad", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".talk", "text/x-speech");
            this.put(".taz", "application/x-tar");
            this.put(".tbp", "application/x-timbuktu");
            this.put(".tbt", "application/x-timbuktu");
            this.put(".tgz", "application/x-compressed");
            this.put(".thm", "application/vnd.eri.thm");
            this.put(".tki", "application/x-tkined");
            this.put(".tkined", "application/x-tkined");
            this.put(".toc", "application/toc");
            this.put(".toy", "image/toy");
            this.put(".trk", "x-lml/x-gps");
            this.put(".trm", "application/x-msterminal");
            this.put(".tsi", "audio/tsplayer");
            this.put(".tsp", "application/dsptype");
            this.put(".ttf", MimeUtils.DEFAULT_MIMETYPE);
            this.put(".ttz", "application/t-time");
            this.put(".uls", "text/iuls");
            this.put(".ult", "audio/x-mod");
            this.put(".uu", "application/x-uuencode");
            this.put(".uue", "application/x-uuencode");
            this.put(".vcf", "text/x-vcard");
            this.put(".vdo", "video/vdo");
            this.put(".vib", "audio/vib");
            this.put(".viv", "video/vivo");
            this.put(".vivo", "video/vivo");
            this.put(".vmd", "application/vocaltec-media-desc");
            this.put(".vmf", "application/vocaltec-media-file");
            this.put(".vmi", "application/x-dreamcast-vms-info");
            this.put(".vms", "application/x-dreamcast-vms");
            this.put(".vox", "audio/voxware");
            this.put(".vqe", "audio/x-twinvq-plugin");
            this.put(".vqf", "audio/x-twinvq");
            this.put(".vql", "audio/x-twinvq");
            this.put(".vre", "x-world/x-vream");
            this.put(".vrt", "x-world/x-vrt");
            this.put(".vrw", "x-world/x-vream");
            this.put(".vts", "workbook/formulaone");
            this.put(".wcm", "application/vnd.ms-works");
            this.put(".wdb", "application/vnd.ms-works");
            this.put(".web", "application/vnd.xara");
            this.put(".wi", "image/wavelet");
            this.put(".wis", "application/x-InstallShield");
            this.put(".wks", "application/vnd.ms-works");
            this.put(".wmd", "application/x-ms-wmd");
            this.put(".wmf", "application/x-msmetafile");
            this.put(".wmlscript", "text/vnd.wap.wmlscript");
            this.put(".wmz", "application/x-ms-wmz");
            this.put(".wpng", "image/x-up-wpng");
            this.put(".wps", "application/vnd.ms-works");
            this.put(".wpt", "x-lml/x-gps");
            this.put(".wri", "application/x-mswrite");
            this.put(".wrz", "x-world/x-vrml");
            this.put(".ws", "text/vnd.wap.wmlscript");
            this.put(".wsc", "application/vnd.wap.wmlscriptc");
            this.put(".wv", "video/wavelet");
            this.put(".wxl", "application/x-wxl");
            this.put(".x-gzip", "application/x-gzip");
            this.put(".xaf", "x-world/x-vrml");
            this.put(".xar", "application/vnd.xara");
            this.put(".xdm", "application/x-xdma");
            this.put(".xdma", "application/x-xdma");
            this.put(".xdw", "application/vnd.fujixerox.docuworks");
            this.put(".xhtm", "application/xhtml+xml");
            this.put(".xla", "application/vnd.ms-excel");
            this.put(".xlc", "application/vnd.ms-excel");
            this.put(".xll", "application/x-excel");
            this.put(".xlm", "application/vnd.ms-excel");
            this.put(".xlt", "application/vnd.ms-excel");
            this.put(".xlw", "application/vnd.ms-excel");
            this.put(".xm", "audio/x-mod");
            this.put(".xmz", "audio/x-mod");
            this.put(".xof", "x-world/x-vrml");
            this.put(".xpi", "application/x-xpinstall");
            this.put(".xsit", "text/xml");
            this.put(".yz1", "application/x-yz1");
            this.put(".z", "application/x-compress");
            this.put(".zac", "application/x-zaurus-zac");
            this.put(".json", "application/json");
        }
    };

    static void clearMimeType() {
        userMappings.clear();
    }

    public static synchronized void addMimeType(Map<String, String> maps) {
        Objects.requireNonNull(maps);
        userMappings.putAll(maps);
    }

    public static String getMimetype(String name) {
        return MimeUtils.getOrDefault(MimeUtils.getNameExt(name), null);
    }

    public static String getMimetype(String name, String defaultValue) {
        return MimeUtils.getOrDefault(MimeUtils.getNameExt(name), defaultValue);
    }

    private static String getOrDefault(String ext, String defaultValue) {
        if (ext != null) {
            String v = userMappings.get(ext);
            if (v != null) {
                return v;
            }
            v = defaultMappings.get(ext);
            if (v != null) {
                return v;
            }
        }
        return defaultValue;
    }

    private static String getNameExt(String fileName) {
        int lastPeriodIndex = fileName.lastIndexOf(".");
        if (lastPeriodIndex > 0 && lastPeriodIndex + 1 < fileName.length()) {
            return fileName.substring(lastPeriodIndex).toLowerCase();
        }
        return null;
    }

    private MimeUtils() {
    }
}

