/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.utils;

import java.io.InputStream;
import java.util.Properties;

public class VersionInfoUtils {
    private static final String VERSION_INFO_FILE = "versioninfo.properties";
    private static final String USER_AGENT_PREFIX = "alibabacloud-java-sdk-v2";
    private static String version = null;
    private static String defaultUserAgent = null;

    public static String getVersion() {
        if (version == null) {
            VersionInfoUtils.initializeVersion();
        }
        return version;
    }

    public static String getDefaultUserAgent() {
        if (defaultUserAgent == null) {
            defaultUserAgent = "alibabacloud-java-sdk-v2/" + VersionInfoUtils.getVersion() + "(" + System.getProperty("os.name") + "/" + System.getProperty("os.version") + "/" + System.getProperty("os.arch") + ";" + System.getProperty("java.version") + ")";
        }
        return defaultUserAgent;
    }

    private static void initializeVersion() {
        InputStream inputStream = VersionInfoUtils.class.getClassLoader().getResourceAsStream(VERSION_INFO_FILE);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new IllegalArgumentException("versioninfo.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
        }
        catch (Exception e) {
            version = "unknown-version";
        }
    }
}

