/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;

public class XmlUtils {
    public static JsonNode getXmlRootElement(byte[] data) throws IOException {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.registerModule((Module)new SimpleModule().addDeserializer(JsonNode.class, (JsonDeserializer)new JsonNodeDeserializer(){

            public JsonNode deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String rootName = ((FromXmlParser)p).getStaxReader().getLocalName();
                return ctxt.getNodeFactory().objectNode().set(rootName, super.deserialize(p, ctxt));
            }
        }));
        return xmlMapper.readTree(data);
    }

    public static String escapeText(String key) {
        if (key == null) {
            return "";
        }
        int len = key.length();
        StringBuilder builder = new StringBuilder();
        for (int pos = 0; pos < len; ++pos) {
            String escapedStr;
            char ch = key.charAt(pos);
            switch (ch) {
                case '&': {
                    escapedStr = "&amp;";
                    break;
                }
                case '\'': {
                    escapedStr = "&apos;";
                    break;
                }
                case '\"': {
                    escapedStr = "&quot;";
                    break;
                }
                case '<': {
                    escapedStr = "&lt;";
                    break;
                }
                case '>': {
                    escapedStr = "&gt;";
                    break;
                }
                default: {
                    escapedStr = ch < ' ' ? "&#x" + Integer.toHexString(ch) + ";" : null;
                }
            }
            if (escapedStr != null) {
                builder.append(escapedStr);
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }
}

