/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.vectors;

import com.aliyun.sdk.service.oss2.ClientConfiguration;
import com.aliyun.sdk.service.oss2.DefaultBaseClientBuilder;
import com.aliyun.sdk.service.oss2.transport.HttpClient;
import com.aliyun.sdk.service.oss2.transport.HttpClientOptions;
import com.aliyun.sdk.service.oss2.transport.apache5client.Apache5AsyncHttpClientBuilder;
import com.aliyun.sdk.service.oss2.vectors.DefaultOSSAsyncVectorsClient;
import com.aliyun.sdk.service.oss2.vectors.DefaultOSSVectorsClientBuilder;
import com.aliyun.sdk.service.oss2.vectors.OSSAsyncVectorsClient;
import com.aliyun.sdk.service.oss2.vectors.OSSAsyncVectorsClientBuilder;

class DefaultOSSAsyncVectorsClientBuilder
extends DefaultBaseClientBuilder<OSSAsyncVectorsClientBuilder, OSSAsyncVectorsClient>
implements OSSAsyncVectorsClientBuilder {
    DefaultOSSAsyncVectorsClientBuilder() {
    }

    @Override
    protected OSSAsyncVectorsClient buildClient() {
        ClientConfiguration config = this.cfgBuilder.httpClient(this.determineHttpClient()).build();
        config = DefaultOSSVectorsClientBuilder.updateEndpoint(config);
        config = DefaultOSSVectorsClientBuilder.updateSinger(config);
        config = DefaultOSSVectorsClientBuilder.updateUserAgent(config);
        String accountId = config.accountId().orElse("");
        return new DefaultOSSAsyncVectorsClient(config, x -> x.toBuilder().endpointProvider(new DefaultOSSVectorsClientBuilder.VectorsEndpointProvider(x.endpoint(), accountId)).build());
    }

    private HttpClient determineHttpClient() {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        HttpClientOptions hcOpt = this.toHttpClientOptions(this.cfgBuilder.build());
        return Apache5AsyncHttpClientBuilder.create().options(hcOpt).build();
    }
}

