/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.vectors;

import com.aliyun.sdk.service.oss2.ClientConfiguration;
import com.aliyun.sdk.service.oss2.ClientOptions;
import com.aliyun.sdk.service.oss2.OperationInput;
import com.aliyun.sdk.service.oss2.OperationOptions;
import com.aliyun.sdk.service.oss2.OperationOutput;
import com.aliyun.sdk.service.oss2.internal.ClientImpl;
import com.aliyun.sdk.service.oss2.vectors.OSSVectorsClient;
import com.aliyun.sdk.service.oss2.vectors.models.DeleteVectorBucketRequest;
import com.aliyun.sdk.service.oss2.vectors.models.DeleteVectorBucketResult;
import com.aliyun.sdk.service.oss2.vectors.models.DeleteVectorIndexRequest;
import com.aliyun.sdk.service.oss2.vectors.models.DeleteVectorIndexResult;
import com.aliyun.sdk.service.oss2.vectors.models.DeleteVectorsRequest;
import com.aliyun.sdk.service.oss2.vectors.models.DeleteVectorsResult;
import com.aliyun.sdk.service.oss2.vectors.models.GetVectorBucketRequest;
import com.aliyun.sdk.service.oss2.vectors.models.GetVectorBucketResult;
import com.aliyun.sdk.service.oss2.vectors.models.GetVectorIndexRequest;
import com.aliyun.sdk.service.oss2.vectors.models.GetVectorIndexResult;
import com.aliyun.sdk.service.oss2.vectors.models.GetVectorsRequest;
import com.aliyun.sdk.service.oss2.vectors.models.GetVectorsResult;
import com.aliyun.sdk.service.oss2.vectors.models.ListVectorBucketsRequest;
import com.aliyun.sdk.service.oss2.vectors.models.ListVectorBucketsResult;
import com.aliyun.sdk.service.oss2.vectors.models.ListVectorIndexesRequest;
import com.aliyun.sdk.service.oss2.vectors.models.ListVectorIndexesResult;
import com.aliyun.sdk.service.oss2.vectors.models.ListVectorsRequest;
import com.aliyun.sdk.service.oss2.vectors.models.ListVectorsResult;
import com.aliyun.sdk.service.oss2.vectors.models.PutVectorBucketRequest;
import com.aliyun.sdk.service.oss2.vectors.models.PutVectorBucketResult;
import com.aliyun.sdk.service.oss2.vectors.models.PutVectorIndexRequest;
import com.aliyun.sdk.service.oss2.vectors.models.PutVectorIndexResult;
import com.aliyun.sdk.service.oss2.vectors.models.PutVectorsRequest;
import com.aliyun.sdk.service.oss2.vectors.models.PutVectorsResult;
import com.aliyun.sdk.service.oss2.vectors.models.QueryVectorsRequest;
import com.aliyun.sdk.service.oss2.vectors.models.QueryVectorsResult;
import com.aliyun.sdk.service.oss2.vectors.operations.VectorBucketBasic;
import com.aliyun.sdk.service.oss2.vectors.operations.VectorIndexBasic;
import com.aliyun.sdk.service.oss2.vectors.operations.VectorsBasic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public class DefaultOSSVectorsClient
implements OSSVectorsClient {
    final ClientImpl clientImpl;

    public DefaultOSSVectorsClient(ClientConfiguration config) {
        this(config, new ArrayList<Function<ClientOptions, ClientOptions>>());
    }

    @SafeVarargs
    public DefaultOSSVectorsClient(ClientConfiguration config, Function<ClientOptions, ClientOptions> ... optFns) {
        this(config, Arrays.asList(optFns));
    }

    private DefaultOSSVectorsClient(ClientConfiguration config, Collection<Function<ClientOptions, ClientOptions>> optFns) {
        this.clientImpl = new ClientImpl(config, optFns);
    }

    @Override
    public OperationOutput invokeOperation(OperationInput input, OperationOptions opts) {
        return this.clientImpl.execute(input, opts);
    }

    @Override
    public PutVectorBucketResult putVectorBucket(PutVectorBucketRequest request, OperationOptions options) {
        return VectorBucketBasic.putVectorBucket(this.clientImpl, request, options);
    }

    @Override
    public GetVectorBucketResult getVectorBucket(GetVectorBucketRequest request, OperationOptions options) {
        return VectorBucketBasic.getVectorBucket(this.clientImpl, request, options);
    }

    @Override
    public DeleteVectorBucketResult deleteVectorBucket(DeleteVectorBucketRequest request, OperationOptions options) {
        return VectorBucketBasic.deleteVectorBucket(this.clientImpl, request, options);
    }

    @Override
    public ListVectorBucketsResult listVectorBuckets(ListVectorBucketsRequest request, OperationOptions options) {
        return VectorBucketBasic.listVectorBuckets(this.clientImpl, request, options);
    }

    @Override
    public PutVectorIndexResult putVectorIndex(PutVectorIndexRequest request, OperationOptions options) {
        return VectorIndexBasic.putVectorIndex(this.clientImpl, request, options);
    }

    @Override
    public GetVectorIndexResult getVectorIndex(GetVectorIndexRequest request, OperationOptions options) {
        return VectorIndexBasic.getVectorIndex(this.clientImpl, request, options);
    }

    @Override
    public ListVectorIndexesResult listVectorIndexes(ListVectorIndexesRequest request, OperationOptions options) {
        return VectorIndexBasic.listVectorIndexes(this.clientImpl, request, options);
    }

    @Override
    public DeleteVectorIndexResult deleteVectorIndex(DeleteVectorIndexRequest request, OperationOptions options) {
        return VectorIndexBasic.deleteVectorIndex(this.clientImpl, request, options);
    }

    @Override
    public PutVectorsResult putVectors(PutVectorsRequest request, OperationOptions options) {
        return VectorsBasic.putVectors(this.clientImpl, request, options);
    }

    @Override
    public GetVectorsResult getVectors(GetVectorsRequest request, OperationOptions options) {
        return VectorsBasic.getVectors(this.clientImpl, request, options);
    }

    @Override
    public ListVectorsResult listVectors(ListVectorsRequest request, OperationOptions options) {
        return VectorsBasic.listVectors(this.clientImpl, request, options);
    }

    @Override
    public DeleteVectorsResult deleteVectors(DeleteVectorsRequest request, OperationOptions options) {
        return VectorsBasic.deleteVectors(this.clientImpl, request, options);
    }

    @Override
    public QueryVectorsResult queryVectors(QueryVectorsRequest request, OperationOptions options) {
        return VectorsBasic.queryVectors(this.clientImpl, request, options);
    }

    @Override
    public void close() throws Exception {
        this.clientImpl.close();
    }
}

