/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.vectors.models;

import com.aliyun.sdk.service.oss2.models.RequestModel;
import java.util.Objects;

public final class PutVectorBucketRequest
extends RequestModel {
    private final String bucket;

    private PutVectorBucketRequest(Builder builder) {
        super(builder);
        this.bucket = builder.bucket;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String bucket() {
        return this.bucket;
    }

    public String resourceGroupId() {
        return (String)this.headers.get("x-oss-resource-group-id");
    }

    public String bucketTagging() {
        return (String)this.headers.get("x-oss-bucket-tagging");
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestModel.Builder<Builder> {
        private String bucket;

        private Builder() {
        }

        private Builder(PutVectorBucketRequest request) {
            super(request);
            this.bucket = request.bucket;
        }

        public Builder bucket(String value) {
            Objects.requireNonNull(value);
            this.bucket = value;
            return this;
        }

        public Builder resourceGroupId(String value) {
            this.headers.put("x-oss-resource-group-id", value);
            return this;
        }

        public Builder bucketTagging(String value) {
            this.headers.put("x-oss-bucket-tagging", value);
            return this;
        }

        public PutVectorBucketRequest build() {
            return new PutVectorBucketRequest(this);
        }
    }
}

