/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss2.vectors.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Objects;

public class VectorBucketInfo {
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Location")
    private String location;
    @JsonProperty(value="CreationDate")
    private Instant creationDate;
    @JsonProperty(value="ExtranetEndpoint")
    private String extranetEndpoint;
    @JsonProperty(value="IntranetEndpoint")
    private String intranetEndpoint;
    @JsonProperty(value="ResourceGroupId")
    private String resourceGroupId;

    public VectorBucketInfo() {
    }

    private VectorBucketInfo(Builder builder) {
        this.name = builder.name;
        this.location = builder.location;
        this.creationDate = builder.creationDate;
        this.extranetEndpoint = builder.extranetEndpoint;
        this.intranetEndpoint = builder.intranetEndpoint;
        this.resourceGroupId = builder.resourceGroupId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    public String location() {
        return this.location;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public String extranetEndpoint() {
        return this.extranetEndpoint;
    }

    public String intranetEndpoint() {
        return this.intranetEndpoint;
    }

    public String resourceGroupId() {
        return this.resourceGroupId;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String name;
        private String location;
        private Instant creationDate;
        private String extranetEndpoint;
        private String intranetEndpoint;
        private String resourceGroupId;

        private Builder() {
        }

        private Builder(VectorBucketInfo from) {
            this.name = from.name;
            this.location = from.location;
            this.creationDate = from.creationDate;
            this.extranetEndpoint = from.extranetEndpoint;
            this.intranetEndpoint = from.intranetEndpoint;
            this.resourceGroupId = from.resourceGroupId;
        }

        public Builder name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return this;
        }

        public Builder location(String location) {
            Objects.requireNonNull(location);
            this.location = location;
            return this;
        }

        public Builder creationDate(Instant creationDate) {
            Objects.requireNonNull(creationDate);
            this.creationDate = creationDate;
            return this;
        }

        public Builder extranetEndpoint(String extranetEndpoint) {
            Objects.requireNonNull(extranetEndpoint);
            this.extranetEndpoint = extranetEndpoint;
            return this;
        }

        public Builder intranetEndpoint(String intranetEndpoint) {
            Objects.requireNonNull(intranetEndpoint);
            this.intranetEndpoint = intranetEndpoint;
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            Objects.requireNonNull(resourceGroupId);
            this.resourceGroupId = resourceGroupId;
            return this;
        }

        public VectorBucketInfo build() {
            return new VectorBucketInfo(this);
        }
    }
}

