/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.CompleteMultipartUpload;
import com.aliyun.sdk.service.oss20190517.models.EncodeType;

public class CompleteMultipartUploadRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Body
    @NameInMap(value="completeMultipartUpload")
    @Validation(required=true)
    private CompleteMultipartUpload completeMultipartUpload;
    @Query
    @NameInMap(value="encoding-type")
    private String encodingType;
    @Query
    @NameInMap(value="uploadId")
    @Validation(required=true)
    private String uploadId;
    @Header
    @NameInMap(value="x-oss-complete-all")
    private String completeAll;
    @Header
    @NameInMap(value="x-oss-forbid-overwrite")
    private String forbidOverwrite;

    private CompleteMultipartUploadRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.bucket = builder.bucket;
        this.completeMultipartUpload = builder.completeMultipartUpload;
        this.encodingType = builder.encodingType;
        this.uploadId = builder.uploadId;
        this.completeAll = builder.completeAll;
        this.forbidOverwrite = builder.forbidOverwrite;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CompleteMultipartUploadRequest create() {
        return CompleteMultipartUploadRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getBucket() {
        return this.bucket;
    }

    public CompleteMultipartUpload getCompleteMultipartUpload() {
        return this.completeMultipartUpload;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public String getCompleteAll() {
        return this.completeAll;
    }

    public String getForbidOverwrite() {
        return this.forbidOverwrite;
    }

    public static final class Builder
    extends Request.Builder<CompleteMultipartUploadRequest, Builder> {
        private String key;
        private String bucket;
        private CompleteMultipartUpload completeMultipartUpload;
        private String encodingType;
        private String uploadId;
        private String completeAll;
        private String forbidOverwrite;

        private Builder() {
        }

        private Builder(CompleteMultipartUploadRequest request) {
            super((Request)request);
            this.key = request.key;
            this.bucket = request.bucket;
            this.completeMultipartUpload = request.completeMultipartUpload;
            this.encodingType = request.encodingType;
            this.uploadId = request.uploadId;
            this.completeAll = request.completeAll;
            this.forbidOverwrite = request.forbidOverwrite;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder completeMultipartUpload(CompleteMultipartUpload completeMultipartUpload) {
            this.putBodyParameter("completeMultipartUpload", (Object)completeMultipartUpload);
            this.completeMultipartUpload = completeMultipartUpload;
            return this;
        }

        public Builder encodingType(String encodingType) {
            this.putQueryParameter("encoding-type", encodingType);
            this.encodingType = encodingType;
            return this;
        }

        public Builder encodingType(EncodeType encodingType) {
            this.putQueryParameter("encoding-type", encodingType.getValue());
            this.encodingType = encodingType.getValue();
            return this;
        }

        public Builder uploadId(String uploadId) {
            this.putQueryParameter("uploadId", uploadId);
            this.uploadId = uploadId;
            return this;
        }

        public Builder completeAll(String completeAll) {
            this.putHeaderParameter("x-oss-complete-all", completeAll);
            this.completeAll = completeAll;
            return this;
        }

        public Builder forbidOverwrite(String forbidOverwrite) {
            this.putHeaderParameter("x-oss-forbid-overwrite", forbidOverwrite);
            this.forbidOverwrite = forbidOverwrite;
            return this;
        }

        public CompleteMultipartUploadRequest build() {
            return new CompleteMultipartUploadRequest(this);
        }
    }
}

