/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.EncodeType;

public class ListObjectsRequest
extends Request {
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="delimiter")
    private String delimiter;
    @Query
    @NameInMap(value="encoding-type")
    private String encodingType;
    @Query
    @NameInMap(value="marker")
    private String marker;
    @Query
    @NameInMap(value="max-keys")
    private Long maxKeys;
    @Query
    @NameInMap(value="prefix")
    private String prefix;

    private ListObjectsRequest(Builder builder) {
        super((Request.Builder)builder);
        this.bucket = builder.bucket;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.marker = builder.marker;
        this.maxKeys = builder.maxKeys;
        this.prefix = builder.prefix;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListObjectsRequest create() {
        return ListObjectsRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String getMarker() {
        return this.marker;
    }

    public Long getMaxKeys() {
        return this.maxKeys;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static final class Builder
    extends Request.Builder<ListObjectsRequest, Builder> {
        private String bucket;
        private String delimiter;
        private String encodingType;
        private String marker;
        private Long maxKeys;
        private String prefix;

        private Builder() {
        }

        private Builder(ListObjectsRequest request) {
            super((Request)request);
            this.bucket = request.bucket;
            this.delimiter = request.delimiter;
            this.encodingType = request.encodingType;
            this.marker = request.marker;
            this.maxKeys = request.maxKeys;
            this.prefix = request.prefix;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.putQueryParameter("delimiter", delimiter);
            this.delimiter = delimiter;
            return this;
        }

        public Builder encodingType(String encodingType) {
            this.putQueryParameter("encoding-type", encodingType);
            this.encodingType = encodingType;
            return this;
        }

        public Builder encodingType(EncodeType encodingType) {
            this.putQueryParameter("encoding-type", encodingType.getValue());
            this.encodingType = encodingType.getValue();
            return this;
        }

        public Builder marker(String marker) {
            this.putQueryParameter("marker", marker);
            this.marker = marker;
            return this;
        }

        public Builder maxKeys(Long maxKeys) {
            this.putQueryParameter("max-keys", maxKeys);
            this.maxKeys = maxKeys;
            return this;
        }

        public Builder prefix(String prefix) {
            this.putQueryParameter("prefix", prefix);
            this.prefix = prefix;
            return this;
        }

        public ListObjectsRequest build() {
            return new ListObjectsRequest(this);
        }
    }
}

