/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.LiveChannelConfiguration;

public class PutLiveChannelRequest
extends Request {
    @Path
    @NameInMap(value="channel")
    @Validation(required=true)
    private String channel;
    @Body
    @NameInMap(value="LiveChannelConfiguration")
    @Validation(required=true)
    private LiveChannelConfiguration liveChannelConfiguration;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;

    private PutLiveChannelRequest(Builder builder) {
        super((Request.Builder)builder);
        this.channel = builder.channel;
        this.liveChannelConfiguration = builder.liveChannelConfiguration;
        this.bucket = builder.bucket;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutLiveChannelRequest create() {
        return PutLiveChannelRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getChannel() {
        return this.channel;
    }

    public LiveChannelConfiguration getLiveChannelConfiguration() {
        return this.liveChannelConfiguration;
    }

    public String getBucket() {
        return this.bucket;
    }

    public static final class Builder
    extends Request.Builder<PutLiveChannelRequest, Builder> {
        private String channel;
        private LiveChannelConfiguration liveChannelConfiguration;
        private String bucket;

        private Builder() {
        }

        private Builder(PutLiveChannelRequest request) {
            super((Request)request);
            this.channel = request.channel;
            this.liveChannelConfiguration = request.liveChannelConfiguration;
            this.bucket = request.bucket;
        }

        public Builder channel(String channel) {
            this.putPathParameter("channel", channel);
            this.channel = channel;
            return this;
        }

        public Builder liveChannelConfiguration(LiveChannelConfiguration liveChannelConfiguration) {
            this.putBodyParameter("LiveChannelConfiguration", (Object)liveChannelConfiguration);
            this.liveChannelConfiguration = liveChannelConfiguration;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public PutLiveChannelRequest build() {
            return new PutLiveChannelRequest(this);
        }
    }
}

