/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.ObjectACL;

public class PutObjectAclRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="versionId")
    private String versionId;
    @Header
    @NameInMap(value="x-oss-object-acl")
    @Validation(required=true)
    private String acl;

    private PutObjectAclRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.bucket = builder.bucket;
        this.versionId = builder.versionId;
        this.acl = builder.acl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutObjectAclRequest create() {
        return PutObjectAclRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getAcl() {
        return this.acl;
    }

    public static final class Builder
    extends Request.Builder<PutObjectAclRequest, Builder> {
        private String key;
        private String bucket;
        private String versionId;
        private String acl;

        private Builder() {
        }

        private Builder(PutObjectAclRequest request) {
            super((Request)request);
            this.key = request.key;
            this.bucket = request.bucket;
            this.versionId = request.versionId;
            this.acl = request.acl;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder versionId(String versionId) {
            this.putQueryParameter("versionId", versionId);
            this.versionId = versionId;
            return this;
        }

        public Builder acl(String acl) {
            this.putHeaderParameter("x-oss-object-acl", acl);
            this.acl = acl;
            return this;
        }

        public Builder acl(ObjectACL acl) {
            this.putHeaderParameter("x-oss-object-acl", acl.getValue());
            this.acl = acl.getValue();
            return this;
        }

        public PutObjectAclRequest build() {
            return new PutObjectAclRequest(this);
        }
    }
}

