/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.ObjectACL;
import com.aliyun.sdk.service.oss20190517.models.StorageClass;
import java.io.InputStream;
import java.util.Map;

public class PutObjectRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Body
    @NameInMap(value="body")
    private InputStream body;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Header
    @NameInMap(value="x-oss-forbid-overwrite")
    private Boolean forbidOverwrite;
    @Header
    @NameInMap(value="x-oss-meta-*")
    private Map<String, String> metaData;
    @Header
    @NameInMap(value="x-oss-object-acl")
    private String acl;
    @Header
    @NameInMap(value="x-oss-server-side-data-encryption")
    private String sseDataEncryption;
    @Header
    @NameInMap(value="x-oss-server-side-encryption")
    private String serverSideEncryption;
    @Header
    @NameInMap(value="x-oss-server-side-encryption-key-id")
    private String sseKeyId;
    @Header
    @NameInMap(value="x-oss-storage-class")
    private String storageClass;
    @Header
    @NameInMap(value="x-oss-tagging")
    private String tagging;

    private PutObjectRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.body = builder.body;
        this.bucket = builder.bucket;
        this.forbidOverwrite = builder.forbidOverwrite;
        this.metaData = builder.metaData;
        this.acl = builder.acl;
        this.sseDataEncryption = builder.sseDataEncryption;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.sseKeyId = builder.sseKeyId;
        this.storageClass = builder.storageClass;
        this.tagging = builder.tagging;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutObjectRequest create() {
        return PutObjectRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public InputStream getBody() {
        return this.body;
    }

    public String getBucket() {
        return this.bucket;
    }

    public Boolean getForbidOverwrite() {
        return this.forbidOverwrite;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public String getAcl() {
        return this.acl;
    }

    public String getSseDataEncryption() {
        return this.sseDataEncryption;
    }

    public String getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public String getSseKeyId() {
        return this.sseKeyId;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public String getTagging() {
        return this.tagging;
    }

    public static final class Builder
    extends Request.Builder<PutObjectRequest, Builder> {
        private String key;
        private InputStream body;
        private String bucket;
        private Boolean forbidOverwrite;
        private Map<String, String> metaData;
        private String acl;
        private String sseDataEncryption;
        private String serverSideEncryption;
        private String sseKeyId;
        private String storageClass;
        private String tagging;

        private Builder() {
        }

        private Builder(PutObjectRequest request) {
            super((Request)request);
            this.key = request.key;
            this.body = request.body;
            this.bucket = request.bucket;
            this.forbidOverwrite = request.forbidOverwrite;
            this.metaData = request.metaData;
            this.acl = request.acl;
            this.sseDataEncryption = request.sseDataEncryption;
            this.serverSideEncryption = request.serverSideEncryption;
            this.sseKeyId = request.sseKeyId;
            this.storageClass = request.storageClass;
            this.tagging = request.tagging;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder body(InputStream body) {
            this.putBodyParameter("body", body);
            this.body = body;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder forbidOverwrite(Boolean forbidOverwrite) {
            this.putHeaderParameter("x-oss-forbid-overwrite", forbidOverwrite);
            this.forbidOverwrite = forbidOverwrite;
            return this;
        }

        public Builder metaData(Map<String, String> metaData) {
            this.putHeaderParameter("x-oss-meta-*", metaData);
            this.metaData = metaData;
            return this;
        }

        public Builder acl(String acl) {
            this.putHeaderParameter("x-oss-object-acl", acl);
            this.acl = acl;
            return this;
        }

        public Builder acl(ObjectACL acl) {
            this.putHeaderParameter("x-oss-object-acl", acl.getValue());
            this.acl = acl.getValue();
            return this;
        }

        public Builder sseDataEncryption(String sseDataEncryption) {
            this.putHeaderParameter("x-oss-server-side-data-encryption", sseDataEncryption);
            this.sseDataEncryption = sseDataEncryption;
            return this;
        }

        public Builder serverSideEncryption(String serverSideEncryption) {
            this.putHeaderParameter("x-oss-server-side-encryption", serverSideEncryption);
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public Builder sseKeyId(String sseKeyId) {
            this.putHeaderParameter("x-oss-server-side-encryption-key-id", sseKeyId);
            this.sseKeyId = sseKeyId;
            return this;
        }

        public Builder storageClass(String storageClass) {
            this.putHeaderParameter("x-oss-storage-class", storageClass);
            this.storageClass = storageClass;
            return this;
        }

        public Builder storageClass(StorageClass storageClass) {
            this.putHeaderParameter("x-oss-storage-class", storageClass.getValue());
            this.storageClass = storageClass.getValue();
            return this;
        }

        public Builder tagging(String tagging) {
            this.putHeaderParameter("x-oss-tagging", tagging);
            this.tagging = tagging;
            return this;
        }

        public PutObjectRequest build() {
            return new PutObjectRequest(this);
        }
    }
}

