/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.core.utils.Validate;
import com.aliyun.sdk.gateway.oss.auth.signer.OSSSigner;
import com.aliyun.sdk.gateway.oss.auth.signer.OSSSignerParams;
import com.aliyun.sdk.gateway.oss.internal.interceptor.AttributeKey;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.RequestInterceptor;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PreSigningInterceptor
implements RequestInterceptor {
    public TeaRequest modifyRequest(InterceptorContext context, AttributeMap attributes) {
        Instant instant;
        ClientConfiguration configuration = context.configuration().clientConfiguration();
        TeaRequest request = context.teaRequest();
        List extraSubresource = Optional.ofNullable(attributes.get(AttributeKey.EXTRA_SUBRESOURCE)).orElse(new ArrayList());
        OSSSigner signer = (OSSSigner)configuration.option(ClientOption.SIGNER);
        ICredentialProvider provider = (ICredentialProvider)configuration.option(ClientOption.CREDENTIALS_PROVIDER);
        ICredential cred = provider.getCredentials();
        Validate.notNull((Object)cred, (String)"ICredential is null", (Object[])new Object[0]);
        if (this.isAnonymous(cred)) {
            return request;
        }
        if (attributes.containsKey(AttributeKey.OSS_SIGNATURE_EXPIRATION)) {
            instant = (Instant)attributes.get(AttributeKey.OSS_SIGNATURE_EXPIRATION);
        } else {
            instant = Instant.now().plusMillis(((Duration)attributes.get(AttributeKey.OSS_SIGNATURE_DURATION)).toMillis());
            attributes.put(AttributeKey.OSS_SIGNATURE_EXPIRATION, (Object)instant);
        }
        if (!StringUtils.isEmpty((CharSequence)cred.securityToken())) {
            request.query().put("security-token", cred.securityToken());
        }
        OSSSignerParams params = OSSSignerParams.create();
        params.setSubResources(extraSubresource);
        params.setCredentials(cred);
        params.setSignatureExpiration(instant);
        return signer.presign(request, params);
    }

    private boolean isAnonymous(ICredential cred) {
        return cred == null || StringUtils.isEmpty((CharSequence)cred.accessKeyId()) || StringUtils.isEmpty((CharSequence)cred.accessKeySecret());
    }
}

