/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpResponseHandler;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.Base64Util;
import com.aliyun.sdk.gateway.oss.exception.OSSClientException;
import com.aliyun.sdk.gateway.oss.exception.OSSErrorDetails;
import com.aliyun.sdk.gateway.oss.exception.OSSServerException;
import com.aliyun.sdk.gateway.oss.internal.interceptor.AttributeKey;
import darabonba.core.TeaRequest;
import darabonba.core.TeaResponse;
import darabonba.core.TeaResponseHandler;
import darabonba.core.async.AsyncResponseHandler;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.RequestInterceptor;
import darabonba.core.interceptor.ResponseInterceptor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.zip.CRC32;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SelectObjectInterceptor
implements RequestInterceptor,
ResponseInterceptor {
    private static final List<String> REQUEST_ALLOW_ACTIONS = Arrays.asList("SelectObject", "CreateSelectObjectMeta");
    private static final AttributeKey<Boolean> SELECT_OBJECT_MEET_JSON = new AttributeKey<Boolean>(Boolean.class);
    private static final AttributeKey<Boolean> SELECT_OBJECT_HAS_ACTION = new AttributeKey<Boolean>(Boolean.class);
    public static final AttributeKey<HttpResponseHandler> SELECT_OBJECT_HTTP_RESPONSE_HANDLER = new AttributeKey<HttpResponseHandler>(HttpResponseHandler.class);

    private static Object base64EncodeInputSerialization(HashMap root, AttributeMap attributes) {
        HashMap node = (HashMap)root.get("InputSerialization");
        if (node != null) {
            HashMap csv = (HashMap)node.get("CSV");
            HashMap json = (HashMap)node.get("JSON");
            if (csv != null) {
                SelectObjectInterceptor.base64EncodeIfPresent(csv, "RecordDelimiter");
                SelectObjectInterceptor.base64EncodeIfPresent(csv, "FieldDelimiter");
                SelectObjectInterceptor.base64EncodeIfPresent(csv, "QuoteCharacter");
                SelectObjectInterceptor.base64EncodeIfPresent(csv, "CommentCharacter");
                node.replace("CSV", csv);
            }
            if (json != null) {
                attributes.put(SELECT_OBJECT_MEET_JSON, (Object)Boolean.TRUE);
            }
        }
        return node;
    }

    private static Object base64EncodeOutputSerialization(HashMap root) {
        HashMap node = (HashMap)root.get("OutputSerialization");
        if (node != null) {
            HashMap csv = (HashMap)node.get("CSV");
            HashMap json = (HashMap)node.get("JSON");
            if (csv != null) {
                SelectObjectInterceptor.base64EncodeIfPresent(csv, "RecordDelimiter");
                SelectObjectInterceptor.base64EncodeIfPresent(csv, "FieldDelimiter");
                node.replace("CSV", csv);
            }
            if (json != null) {
                SelectObjectInterceptor.base64EncodeIfPresent(json, "RecordDelimiter");
                node.replace("JSON", json);
            }
        }
        return node;
    }

    private static void base64EncodeIfPresent(HashMap node, String key) {
        if (node.containsKey(key) && node.get(key) != null) {
            node.replace(key, Base64Util.encodeToString((byte[])((String)node.get(key)).getBytes()));
        }
    }

    public TeaRequest modifyRequest(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();
        String action = request.action();
        if (REQUEST_ALLOW_ACTIONS.contains(action)) {
            HashMap root;
            HashMap body = (HashMap)request.body();
            if (body.containsKey("SelectRequest")) {
                root = (HashMap)body.get("SelectRequest");
                SelectObjectInterceptor.base64EncodeIfPresent(root, "Expression");
                root.replace("InputSerialization", SelectObjectInterceptor.base64EncodeInputSerialization(root, attributes));
                root.replace("OutputSerialization", SelectObjectInterceptor.base64EncodeOutputSerialization(root));
                body.replace("SelectRequest", root);
            } else if (body.containsKey("body")) {
                root = (HashMap)body.get("body");
                root.replace("InputSerialization", SelectObjectInterceptor.base64EncodeInputSerialization(root, attributes));
                String rootKey = attributes.containsKey(SELECT_OBJECT_MEET_JSON) ? "JsonMetaRequest" : "CsvMetaRequest";
                body.remove("body");
                body.put(rootKey, root);
            }
            request.setBody((Object)body);
            String op = attributes.containsKey(SELECT_OBJECT_MEET_JSON) ? "json/" : "csv/";
            op = op + (body.containsKey("SelectRequest") ? "select" : "meta");
            request.query().put("x-oss-process", op);
            attributes.put(SELECT_OBJECT_HAS_ACTION, (Object)Boolean.TRUE);
            if (context.teaResponseHandler() instanceof AsyncResponseHandler) {
                DecodeFrameHttpResponseHandler handler = new DecodeFrameHttpResponseHandler((AsyncResponseHandler)context.teaResponseHandler());
                attributes.put(AttributeKey.OSS_HTTP_RESPONSE_HANDLER, (Object)handler);
                attributes.put(SELECT_OBJECT_HTTP_RESPONSE_HANDLER, (Object)handler);
            }
        }
        return request;
    }

    private boolean shouldHandleResponse(TeaResponse response, AttributeMap attributes) {
        if (!response.success() || response.exception() != null) {
            return false;
        }
        return attributes.containsKey(SELECT_OBJECT_HAS_ACTION);
    }

    private static boolean hasSelectOutputRaw(HttpHeaders httpHeaders) {
        String value;
        return httpHeaders != null && "true".equals(value = httpHeaders.getValue("x-oss-select-output-raw"));
    }

    private OSSClientException buildClientException(String msg) {
        return new OSSClientException(msg, null);
    }

    private OSSErrorDetails buildErrorDetails(String error, String requestId, int httpStatusCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        int index = error.indexOf(".");
        if (index != -1) {
            map.put("Code", error.substring(0, index));
            map.put("Message", error.substring(index + 1));
        } else {
            map.put("Code", "");
            map.put("Message", error);
        }
        map.put("RequestId", requestId);
        map.put("HttpStatusCode", httpStatusCode + "");
        return new OSSErrorDetails(map, "");
    }

    private OSSServerException buildServerException(TeaResponse response, EndFrame frame) {
        String requestId = Optional.ofNullable(response.httpResponse().getHeaders().getValue("x-oss-request-id")).orElse("");
        return new OSSServerException(response.httpResponse().getStatusCode(), this.buildErrorDetails(frame.getErrorMessage(), requestId, frame.httpStatusCode));
    }

    private Exception changeDecodeFrameStatusToExceptionIfNeed(TeaResponse response, DecodeFrameStatus status) {
        Object exception = null;
        if (status != null) {
            if (status.getParsingError() != null) {
                exception = this.buildClientException(status.getParsingError());
            } else {
                int httpStatusCode;
                EndFrame endFrame = status.getEndFrame();
                if (endFrame != null && (httpStatusCode = endFrame.httpStatusCode.intValue()) / 100 != 2) {
                    exception = this.buildServerException(response, endFrame);
                }
            }
        }
        return exception;
    }

    private TeaResponse modifySelectObjectResponse(InterceptorContext context, AttributeMap attributes) {
        Object body;
        TeaResponse response = context.teaResponse();
        Exception exception = null;
        if (context.teaResponseHandler() instanceof AsyncResponseHandler) {
            DecodeFrameHttpResponseHandler handler = (DecodeFrameHttpResponseHandler)attributes.get(SELECT_OBJECT_HTTP_RESPONSE_HANDLER);
            DecodeFrameStatus status = handler.getDecodeFrameStatus();
            exception = this.changeDecodeFrameStatusToExceptionIfNeed(response, status);
        } else if (response.deserializedBody() != null && !SelectObjectInterceptor.hasSelectOutputRaw(response.httpResponse().getHeaders()) && (body = response.deserializedBody()) instanceof InputStream) {
            response.setDeserializedBody((Object)new SelectInputStream((InputStream)body));
        }
        response.setException(exception);
        return response;
    }

    private TeaResponse modifyCreateSelectObjectMetaResponse(TeaResponse response) {
        Exception exception = null;
        if (response.deserializedBody() instanceof byte[]) {
            CreateSelectMetaParser parser = new CreateSelectMetaParser();
            DecodeFrameStatus status = parser.parse((byte[])response.deserializedBody());
            response.setDeserializedBody((Object)parser.toEndFrameMap());
            exception = this.changeDecodeFrameStatusToExceptionIfNeed(response, status);
        }
        response.setException(exception);
        return response;
    }

    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        TeaResponse response = context.teaResponse();
        if (this.shouldHandleResponse(response, attributes)) {
            switch (context.teaRequest().action()) {
                case "SelectObject": {
                    response = this.modifySelectObjectResponse(context, attributes);
                    break;
                }
                case "CreateSelectObjectMeta": {
                    response = this.modifyCreateSelectObjectMetaResponse(response);
                    break;
                }
            }
        }
        return response;
    }

    private class CreateSelectMetaParser
    extends DecodeFrameParser {
        private int metaEndframeType;
        private MetaEndFrame metaEndFrame;

        private CreateSelectMetaParser() {
            this.metaEndframeType = 0;
        }

        @Override
        protected void resetState() {
            super.resetState();
            this.metaEndFrame = null;
        }

        private boolean parseInternal(byte[] b) {
            int off = 0;
            int remians = b.length;
            while (remians > 0) {
                this.frameType = 0;
                this.payloadLen = 0;
                this.payloadOff = 0;
                int ret = this.splitOneFrame(b, off, remians);
                if (ret < 0) {
                    return false;
                }
                switch (this.frameType) {
                    case 0x800006: 
                    case 0x800007: {
                        this.metaEndframeType = this.frameType;
                        this.endFramelBuf = new byte[this.payloadLen + 8];
                        System.arraycopy(this.headerBuf, 12, this.endFramelBuf, 0, 8);
                        System.arraycopy(b, this.payloadOff, this.endFramelBuf, 8, this.payloadLen);
                        break;
                    }
                    case 0: {
                        if (this.tailLen != 4) break;
                        if (this.payloadCRC != 0L && this.payloadCRC != this.calcPayloadCRC) {
                            this.lastErrorMsg = "Frame crc check failed, actual " + this.calcPayloadCRC + ", expect: " + this.payloadCRC;
                            return false;
                        }
                        this.headerLen = 0;
                        this.tailLen = 0;
                        this.payloadRemains = 0;
                        break;
                    }
                }
                remians -= ret;
                off += ret;
            }
            return true;
        }

        private MetaEndFrame toMetaEndFrame(byte[] data) {
            if (data == null) {
                return null;
            }
            MetaEndFrame endFrame = new MetaEndFrame();
            endFrame.setOffset(ByteBuffer.wrap(data, 0, 8).getLong());
            endFrame.setTotalScannedBytes(ByteBuffer.wrap(data, 8, 8).getLong());
            endFrame.setHttpStatusCode(ByteBuffer.wrap(data, 16, 4).getInt());
            endFrame.setSplitsCount(ByteBuffer.wrap(data, 20, 4).getInt());
            endFrame.setRowsCount(ByteBuffer.wrap(data, 24, 8).getLong());
            if (this.metaEndframeType == 0x800006) {
                endFrame.setColsCount(ByteBuffer.wrap(data, 32, 4).getInt());
                endFrame.setErrorMessage(new String(data, 36, data.length - 36));
            } else {
                endFrame.setErrorMessage(new String(data, 32, data.length - 32));
            }
            return endFrame;
        }

        public DecodeFrameStatus parse(byte[] data) {
            this.resetState();
            this.parseInternal(data);
            DecodeFrameStatus decodeFrameStatus = new DecodeFrameStatus();
            if (this.lastErrorMsg != null) {
                decodeFrameStatus.setParsingError(this.lastErrorMsg);
            }
            if (this.endFramelBuf != null) {
                this.metaEndFrame = this.toMetaEndFrame(this.endFramelBuf);
                decodeFrameStatus.setEndFrame(this.metaEndFrame);
            }
            return decodeFrameStatus;
        }

        public HashMap toEndFrameMap() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (this.metaEndFrame != null) {
                result.put("Offset", this.metaEndFrame.getOffset());
                result.put("TotalScannedBytes", this.metaEndFrame.getTotalScannedBytes());
                result.put("Status", this.metaEndFrame.httpStatusCode);
                result.put("SplitsCount", this.metaEndFrame.splitsCount);
                result.put("RowsCount", this.metaEndFrame.getRowsCount());
                result.put("ColsCount", this.metaEndFrame.getColsCount());
                result.put("ErrorMessage", this.metaEndFrame.getErrorMessage());
            }
            return result;
        }
    }

    private class DecodeFrameHttpResponseHandler
    implements HttpResponseHandler {
        private AsyncResponseHandler<?, ?> handler;
        private DecodeFrameAsyncResponseHandler decodeFrameHandler;

        DecodeFrameHttpResponseHandler(AsyncResponseHandler<?, ?> handler) {
            this.handler = handler;
            this.decodeFrameHandler = null;
        }

        public void onStream(Publisher<ByteBuffer> publisher, int httpStatusCode, HttpHeaders headers) {
            if (SelectObjectInterceptor.hasSelectOutputRaw(headers)) {
                this.handler.onStream(publisher);
            } else {
                this.decodeFrameHandler = new DecodeFrameAsyncResponseHandler((TeaResponseHandler)this.handler);
                this.decodeFrameHandler.onStream(publisher);
            }
        }

        public DecodeFrameStatus getDecodeFrameStatus() {
            if (this.decodeFrameHandler != null) {
                return this.decodeFrameHandler.transform("");
            }
            return null;
        }
    }

    private class DecodeFrameAsyncResponseHandler
    implements AsyncResponseHandler<String, DecodeFrameStatus> {
        protected volatile AsyncResponseHandler<?, ?> handler;
        protected volatile DecodeFrameProcessor processor;

        public DecodeFrameAsyncResponseHandler(TeaResponseHandler handler) {
            this.handler = (AsyncResponseHandler)handler;
        }

        public void onStream(Publisher<ByteBuffer> publisher) {
            DecodeFrameProcessor proc;
            this.processor = proc = new DecodeFrameProcessor();
            this.handler.onStream((Publisher)proc);
            publisher.subscribe((Subscriber)proc);
        }

        public DecodeFrameStatus transform(String response) {
            return this.processor.getDecodeFrameStatus();
        }

        class DecodeFrameProcessor
        extends DecodeFrameParser
        implements Processor<ByteBuffer, ByteBuffer> {
            protected volatile Subscriber<? super ByteBuffer> subscriber;
            private Subscription subscription;
            protected DecodeFrameStatus decodeFrameStatus;

            DecodeFrameProcessor() {
            }

            @Override
            protected void resetState() {
                super.resetState();
                this.decodeFrameStatus = null;
            }

            private boolean flushToSubscriber(ByteBuffer byteBuffer) {
                byte[] b = byteBuffer.array();
                int off = byteBuffer.arrayOffset() + byteBuffer.position();
                int remians = byteBuffer.remaining();
                while (remians > 0) {
                    this.frameType = 0;
                    this.payloadLen = 0;
                    this.payloadOff = 0;
                    int ret = this.splitOneFrame(b, off, remians);
                    if (ret < 0) {
                        return false;
                    }
                    switch (this.frameType) {
                        case 0x800001: {
                            this.subscriber.onNext((Object)ByteBuffer.wrap(b, this.payloadOff, this.payloadLen));
                            break;
                        }
                        case 0x800005: {
                            this.endFramelBuf = new byte[this.payloadLen + 8];
                            System.arraycopy(this.headerBuf, 12, this.endFramelBuf, 0, 8);
                            System.arraycopy(b, this.payloadOff, this.endFramelBuf, 8, this.payloadLen);
                            break;
                        }
                        case 0: {
                            if (this.tailLen != 4) break;
                            if (this.payloadCRC != 0L && this.payloadCRC != this.calcPayloadCRC) {
                                this.lastErrorMsg = "Frame crc check failed, actual " + this.calcPayloadCRC + ", expect: " + this.payloadCRC;
                                return false;
                            }
                            this.headerLen = 0;
                            this.tailLen = 0;
                            this.payloadRemains = 0;
                            break;
                        }
                    }
                    remians -= ret;
                    off += ret;
                }
                return true;
            }

            private EndFrame toEndFrame(byte[] data) {
                if (data == null) {
                    return null;
                }
                EndFrame endFrame = new EndFrame();
                endFrame.setOffset(ByteBuffer.wrap(data, 0, 8).getLong());
                endFrame.setTotalScannedBytes(ByteBuffer.wrap(data, 8, 8).getLong());
                endFrame.setHttpStatusCode(ByteBuffer.wrap(data, 16, 4).getInt());
                endFrame.setErrorMessage(new String(data, 20, data.length - 20));
                return endFrame;
            }

            public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
                this.subscriber = subscriber;
            }

            public void onSubscribe(Subscription subscription) {
                this.resetState();
                this.subscription = subscription;
                this.subscriber.onSubscribe(subscription);
            }

            public void onNext(ByteBuffer byteBuffer) {
                if (!this.flushToSubscriber(byteBuffer)) {
                    // empty if block
                }
            }

            public void onError(Throwable throwable) {
                this.subscriber.onError(throwable);
            }

            public void onComplete() {
                this.subscriber.onComplete();
                this.decodeFrameStatus = new DecodeFrameStatus();
                if (this.lastErrorMsg != null) {
                    this.decodeFrameStatus.setParsingError(this.lastErrorMsg);
                }
                if (this.endFramelBuf != null) {
                    this.decodeFrameStatus.setEndFrame(this.toEndFrame(this.endFramelBuf));
                }
            }

            public DecodeFrameStatus getDecodeFrameStatus() {
                return this.decodeFrameStatus;
            }
        }
    }

    private class DecodeFrameParser {
        protected static final int SELECT_VERSION = 1;
        protected static final int DATA_FRAME_MAGIC = 0x800001;
        protected static final int CONTINUOUS_FRAME_MAGIC = 0x800004;
        protected static final int END_FRAME_MAGIC = 0x800005;
        protected static final int CSV_END_FRAME_MAGIC = 0x800006;
        protected static final int JSON_END_FRAME_MAGIC = 0x800007;
        protected static final int FRAME_HEADER_LEN = 20;
        protected byte[] headerBuf = new byte[20];
        protected byte[] tailBuf = new byte[4];
        protected byte[] endFramelBuf;
        protected int frameType;
        protected int headerLen;
        protected int tailLen;
        protected int payloadRemains;
        protected int payloadOff;
        protected int payloadLen;
        protected CRC32 crc32 = new CRC32();
        protected long payloadCRC;
        protected long calcPayloadCRC;
        protected String lastErrorMsg;

        DecodeFrameParser() {
        }

        protected void resetState() {
            this.headerLen = 0;
            this.tailLen = 0;
            this.payloadRemains = 0;
            this.lastErrorMsg = null;
            this.endFramelBuf = null;
        }

        protected int splitOneFrame(byte[] b, int off, int len) {
            int copy;
            int remians = len;
            int boff = off;
            if (this.headerLen < 20) {
                copy = Math.min(20 - this.headerLen, remians);
                System.arraycopy(b, boff, this.headerBuf, this.headerLen, copy);
                this.headerLen += copy;
                boff += copy;
                remians -= copy;
                if (this.headerLen == 20) {
                    int value = ByteBuffer.wrap(this.headerBuf, 4, 4).getInt();
                    this.payloadRemains = value - 8;
                    this.crc32.reset();
                    this.crc32.update(this.headerBuf, 12, 8);
                    if (this.headerBuf[0] != 1) {
                        this.lastErrorMsg = "Invalid select version found " + this.headerBuf[0] + ", expect: " + 1;
                        return -1;
                    }
                }
            }
            if (this.payloadRemains > 0) {
                copy = Math.min(this.payloadRemains, remians);
                this.frameType = ByteBuffer.wrap(this.headerBuf, 0, 4).getInt();
                this.frameType &= 0xFFFFFF;
                this.payloadOff = boff;
                this.payloadLen = copy;
                this.payloadRemains -= copy;
                boff += copy;
                this.crc32.update(b, this.payloadOff, copy);
                return len - (remians -= copy);
            }
            if (this.tailLen < 4) {
                copy = Math.min(4 - this.tailLen, remians);
                System.arraycopy(b, boff, this.tailBuf, this.tailLen, copy);
                this.tailLen += copy;
                remians -= copy;
                boff += copy;
                if (this.tailLen == 4) {
                    this.payloadCRC = (long)ByteBuffer.wrap(this.tailBuf).getInt() & 0xFFFFFFFFL;
                    this.calcPayloadCRC = this.crc32.getValue();
                }
            }
            return len - remians;
        }
    }

    private class DecodeFrameStatus {
        private String parsingError;
        private EndFrame endFrame;

        private DecodeFrameStatus() {
        }

        public String getParsingError() {
            return this.parsingError;
        }

        public void setParsingError(String parsingError) {
            this.parsingError = parsingError;
        }

        public EndFrame getEndFrame() {
            return this.endFrame;
        }

        public void setEndFrame(EndFrame endFrame) {
            this.endFrame = endFrame;
        }
    }

    private class MetaEndFrame
    extends EndFrame {
        protected Integer splitsCount;
        protected Long rowsCount;
        protected Integer colsCount;

        private MetaEndFrame() {
        }

        public Integer getSplitsCount() {
            return this.splitsCount;
        }

        public void setSplitsCount(Integer splitsCount) {
            this.splitsCount = splitsCount;
        }

        public Long getRowsCount() {
            return this.rowsCount;
        }

        public void setRowsCount(Long rowsCount) {
            this.rowsCount = rowsCount;
        }

        public Integer getColsCount() {
            return this.colsCount;
        }

        public void setColsCount(Integer colsCount) {
            this.colsCount = colsCount;
        }
    }

    private class EndFrame {
        protected Long offset;
        protected Long totalScannedBytes;
        protected Integer httpStatusCode = 0;
        protected String errorMessage = "";

        private EndFrame() {
        }

        public Long getOffset() {
            return this.offset;
        }

        public void setOffset(Long offset) {
            this.offset = offset;
        }

        public Long getTotalScannedBytes() {
            return this.totalScannedBytes;
        }

        public void setTotalScannedBytes(Long totalScannedBytes) {
            this.totalScannedBytes = totalScannedBytes;
        }

        public Integer getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public void setHttpStatusCode(Integer httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    private class SelectInputStream
    extends FilterInputStream {
        private static final int DATA_FRAME_MAGIC = 0x800001;
        private static final int CONTINUOUS_FRAME_MAGIC = 0x800004;
        private static final int END_FRAME_MAGIC = 0x800005;
        private static final int SELECT_VERSION = 1;
        private static final long DEFAULT_NOTIFICATION_THRESHOLD = 0x3200000L;
        private long currentFrameOffset;
        private long currentFramePayloadLength;
        private byte[] currentFrameTypeBytes;
        private byte[] currentFramePayloadLengthBytes;
        private byte[] currentFrameHeaderChecksumBytes;
        private byte[] scannedDataBytes;
        private byte[] currentFramePayloadChecksumBytes;
        private boolean finished;
        private long nextNotificationScannedSize;
        private boolean payloadCrcEnabled;
        private CRC32 crc32;
        private String requestId;
        private boolean firstReadFrame;

        public SelectInputStream(InputStream in) {
            super(in);
            this.currentFrameOffset = 0L;
            this.currentFramePayloadLength = 0L;
            this.currentFrameTypeBytes = new byte[4];
            this.currentFramePayloadLengthBytes = new byte[4];
            this.currentFrameHeaderChecksumBytes = new byte[4];
            this.scannedDataBytes = new byte[8];
            this.currentFramePayloadChecksumBytes = new byte[4];
            this.finished = false;
            this.firstReadFrame = true;
            this.nextNotificationScannedSize = 0x3200000L;
            this.payloadCrcEnabled = true;
            if (this.payloadCrcEnabled) {
                this.crc32 = new CRC32();
                this.crc32.reset();
            }
        }

        private void internalRead(byte[] buf, int off, int len) throws IOException {
            int bytes;
            for (int bytesRead = 0; bytesRead < len; bytesRead += bytes) {
                bytes = this.in.read(buf, off + bytesRead, len - bytesRead);
                if (bytes >= 0) continue;
                throw new IOException("Invalid input stream end found, need another " + (len - bytesRead) + " bytes");
            }
        }

        private void validateCheckSum(byte[] checksumBytes, CRC32 crc32) throws IOException {
            if (this.payloadCrcEnabled) {
                int currentChecksum = ByteBuffer.wrap(checksumBytes).getInt();
                if (currentChecksum != 0 && crc32.getValue() != ((long)currentChecksum & 0xFFFFFFFFL)) {
                    throw new IOException("Frame crc check failed, actual " + crc32.getValue() + ", expect: " + currentChecksum);
                }
                crc32.reset();
            }
        }

        private void readFrame() throws IOException {
            while (this.currentFrameOffset >= this.currentFramePayloadLength && !this.finished) {
                long scannedDataSize;
                if (!this.firstReadFrame) {
                    this.internalRead(this.currentFramePayloadChecksumBytes, 0, 4);
                    this.validateCheckSum(this.currentFramePayloadChecksumBytes, this.crc32);
                }
                this.firstReadFrame = false;
                this.internalRead(this.currentFrameTypeBytes, 0, 4);
                if (this.currentFrameTypeBytes[0] != 1) {
                    throw new IOException("Invalid select version found " + this.currentFrameTypeBytes[0] + ", expect: " + 1);
                }
                this.internalRead(this.currentFramePayloadLengthBytes, 0, 4);
                this.internalRead(this.currentFrameHeaderChecksumBytes, 0, 4);
                this.internalRead(this.scannedDataBytes, 0, 8);
                if (this.payloadCrcEnabled) {
                    this.crc32.update(this.scannedDataBytes, 0, this.scannedDataBytes.length);
                }
                this.currentFrameTypeBytes[0] = 0;
                int type = ByteBuffer.wrap(this.currentFrameTypeBytes).getInt();
                switch (type) {
                    case 0x800001: {
                        this.currentFramePayloadLength = ByteBuffer.wrap(this.currentFramePayloadLengthBytes).getInt() - 8;
                        this.currentFrameOffset = 0L;
                        break;
                    }
                    case 0x800004: {
                        break;
                    }
                    case 0x800005: {
                        this.currentFramePayloadLength = ByteBuffer.wrap(this.currentFramePayloadLengthBytes).getInt() - 8;
                        byte[] totalScannedDataSizeBytes = new byte[8];
                        this.internalRead(totalScannedDataSizeBytes, 0, 8);
                        byte[] statusBytes = new byte[4];
                        this.internalRead(statusBytes, 0, 4);
                        if (this.payloadCrcEnabled) {
                            this.crc32.update(totalScannedDataSizeBytes, 0, totalScannedDataSizeBytes.length);
                            this.crc32.update(statusBytes, 0, statusBytes.length);
                        }
                        int status = ByteBuffer.wrap(statusBytes).getInt();
                        int errorMessageSize = (int)(this.currentFramePayloadLength - 12L);
                        String error = "";
                        if (errorMessageSize > 0) {
                            byte[] errorMessageBytes = new byte[errorMessageSize];
                            this.internalRead(errorMessageBytes, 0, errorMessageSize);
                            error = new String(errorMessageBytes);
                            if (this.payloadCrcEnabled) {
                                this.crc32.update(errorMessageBytes, 0, errorMessageBytes.length);
                            }
                        }
                        this.finished = true;
                        this.currentFramePayloadLength = this.currentFrameOffset;
                        this.internalRead(this.currentFramePayloadChecksumBytes, 0, 4);
                        this.validateCheckSum(this.currentFramePayloadChecksumBytes, this.crc32);
                        if (status / 100 == 2) break;
                        if (error.contains(".")) {
                            throw new IOException(error.substring(error.indexOf(".") + 1));
                        }
                        throw new IOException(error);
                    }
                    default: {
                        throw new IOException("Unsupported frame type " + type + " found");
                    }
                }
                if ((scannedDataSize = ByteBuffer.wrap(this.scannedDataBytes).getLong()) < this.nextNotificationScannedSize && !this.finished) continue;
                this.nextNotificationScannedSize += 0x3200000L;
            }
        }

        @Override
        public int read() throws IOException {
            this.readFrame();
            int byteRead = this.in.read();
            if (byteRead >= 0) {
                ++this.currentFrameOffset;
                if (this.payloadCrcEnabled) {
                    this.crc32.update(byteRead);
                }
            }
            return byteRead;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            this.readFrame();
            int bytesToRead = (int)Math.min((long)len, this.currentFramePayloadLength - this.currentFrameOffset);
            if (bytesToRead != 0) {
                int bytes = this.in.read(buf, off, bytesToRead);
                if (bytes > 0) {
                    this.currentFrameOffset += (long)bytes;
                    if (this.payloadCrcEnabled) {
                        this.crc32.update(buf, off, bytes);
                    }
                }
                return bytes;
            }
            return -1;
        }

        @Override
        public int available() throws IOException {
            throw new IOException("Select object input stream does not support available() operation");
        }
    }
}

