/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.DateUtil;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.core.utils.Validate;
import com.aliyun.sdk.gateway.oss.auth.signer.OSSSigner;
import com.aliyun.sdk.gateway.oss.auth.signer.OSSSignerParams;
import com.aliyun.sdk.gateway.oss.internal.interceptor.AttributeKey;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.HttpRequestInterceptor;
import darabonba.core.interceptor.InterceptorContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class SigningInterceptor
implements HttpRequestInterceptor {
    public HttpRequest modifyHttpRequest(InterceptorContext context, AttributeMap attributes) {
        ClientConfiguration configuration = context.configuration().clientConfiguration();
        TeaRequest request = context.teaRequest();
        HttpRequest httpRequest = context.httpRequest();
        if (httpRequest.getHeaders().getValue("Date") == null) {
            Date now = new Date();
            now.setTime(now.getTime() + (Long)configuration.option(ClientOption.CLOCK_SKEW_DIFF));
            httpRequest.getHeaders().set("Date", DateUtil.formatRfc822Date((Date)now));
        }
        List extraSubresource = Optional.ofNullable(attributes.get(AttributeKey.EXTRA_SUBRESOURCE)).orElse(new ArrayList());
        OSSSigner signer = (OSSSigner)configuration.option(ClientOption.SIGNER);
        ICredentialProvider provider = (ICredentialProvider)configuration.option(ClientOption.CREDENTIALS_PROVIDER);
        ICredential cred = provider.getCredentials();
        Validate.notNull((Object)cred, (String)"ICredential is null", (Object[])new Object[0]);
        if (this.isAnonymous(cred)) {
            return httpRequest;
        }
        OSSSignerParams params = OSSSignerParams.create();
        params.setSubResources(extraSubresource);
        params.setCredentials(cred);
        if (!StringUtils.isEmpty((CharSequence)cred.securityToken())) {
            httpRequest.getHeaders().set("x-oss-security-token", cred.securityToken());
        }
        return signer.sign(request, httpRequest, params);
    }

    private boolean isAnonymous(ICredential cred) {
        return cred == null || StringUtils.isEmpty((CharSequence)cred.accessKeyId()) || StringUtils.isEmpty((CharSequence)cred.accessKeySecret());
    }
}

