/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.clients;

import com.aliyun.core.utils.SdkAutoCloseable;
import com.aliyun.sdk.gateway.pop.Configuration;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.clients.CommonClientBuilder;
import com.aliyun.sdk.gateway.pop.models.CommonRequest;
import com.aliyun.sdk.gateway.pop.models.CommonResponse;
import darabonba.core.RequestModel;
import darabonba.core.RequestStyle;
import darabonba.core.TeaAsyncHandler;
import darabonba.core.TeaModel;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientExecutionParams;

public final class CommonClient
implements SdkAutoCloseable {
    private final TeaAsyncHandler handler;

    CommonClient(ClientConfiguration configuration) {
        this.handler = new TeaAsyncHandler(configuration);
    }

    public static CommonClientBuilder builder() {
        return (CommonClientBuilder)((Object)new CommonClientBuilder().serviceConfiguration(Configuration.create().setSignatureVersion(SignatureVersion.V3)));
    }

    static CommonClient create() {
        return (CommonClient)CommonClient.builder().build();
    }

    public void close() {
        this.handler.close();
    }

    public CommonResponse callApi(CommonRequest request) {
        this.handler.validateRequestModel((RequestModel)request);
        TeaRequest teaRequest = TeaRequest.create().setProduct(request.getProduct()).setVersion(request.getVersion()).setStyle(request.getPath().equals("/") ? RequestStyle.RPC : RequestStyle.RESTFUL).setAction(request.getAction()).setMethod(request.getHttpMethod()).setPathRegex(request.getPath()).setReqBodyType(request.getRequestBodyType()).setBodyType(request.getResponseBodyType()).setBodyIsForm(request.isFormData()).formModel((RequestModel)request);
        ClientExecutionParams params = new ClientExecutionParams().withInput((RequestModel)request).withRequest(teaRequest).withOutput((TeaModel)CommonResponse.create());
        return (CommonResponse)((Object)this.handler.execute(params).join());
    }
}

