/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.event;

import com.alibaba.cola.event.EventHandlerI;
import com.alibaba.cola.event.EventI;
import com.alibaba.cola.exception.framework.ColaException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class EventHub {
    private HashMap<Class, List<EventHandlerI>> eventRepository = new HashMap();
    private Map<Class, Class> responseRepository = new HashMap<Class, Class>();

    public HashMap<Class, List<EventHandlerI>> getEventRepository() {
        return this.eventRepository;
    }

    public void setEventRepository(HashMap<Class, List<EventHandlerI>> eventRepository) {
        this.eventRepository = eventRepository;
    }

    public Map<Class, Class> getResponseRepository() {
        return this.responseRepository;
    }

    public List<EventHandlerI> getEventHandler(Class eventClass) {
        List<EventHandlerI> eventHandlerIList = this.findHandler(eventClass);
        if (eventHandlerIList == null || eventHandlerIList.size() == 0) {
            throw new ColaException(eventClass + "is not registered in eventHub, please register first");
        }
        return eventHandlerIList;
    }

    public void register(Class<? extends EventI> eventClz, EventHandlerI executor) {
        List<EventHandlerI> eventHandlers = this.eventRepository.get(eventClz);
        if (eventHandlers == null) {
            eventHandlers = new ArrayList<EventHandlerI>();
            this.eventRepository.put(eventClz, eventHandlers);
        }
        eventHandlers.add(executor);
    }

    private List<EventHandlerI> findHandler(Class<? extends EventI> eventClass) {
        List<EventHandlerI> eventHandlerIList = null;
        Class<? extends EventI> cls = eventClass;
        eventHandlerIList = this.eventRepository.get(cls);
        return eventHandlerIList;
    }
}

