/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.common;

import java.util.HashSet;
import java.util.Set;

public abstract class ErrorCode {
    public static final String INVALID_PARAMETER = "InvalidParameter";
    public static final String INVALID_SUBSCRIPTION = "InvalidSubscription";
    public static final String INVALID_CURSOR = "InvalidCursor";
    public static final String RESOURCE_NOT_FOUND = "ResourceNotFound";
    public static final String NO_SUCH_TOPIC = "NoSuchTopic";
    public static final String NO_SUCH_PROJECT = "NoSuchProject";
    public static final String NO_SUCH_SUBSCRIPTION = "NoSuchSubscription";
    public static final String NO_SUCH_SHARD = "NoSuchShard";
    public static final String NO_SUCH_CONNECTOR = "NoSuchConnector";
    public static final String NO_SUCH_METER_INFO = "NoSuchMeteringInfo";
    public static final String NO_SUCH_ALARM_RULE = "NoSuchAlarmRule";
    public static final String RESOURCE_ALREADY_EXIST = "ResourceAlreadyExist";
    public static final String PROJECT_ALREADY_EXIST = "ProjectAlreadyExist";
    public static final String TOPIC_ALREADY_EXIST = "TopicAlreadyExist";
    public static final String CONNECTOR_ALREADY_EXIST = "ConnectorAlreadyExist";
    public static final String USER_ALREADY_EXIST = "UserAlreadyExist";
    public static final String ALARM_RULE_ALREADY_EXIST = "AlarmRuleAlreadyExist";
    public static final String RESOURCE_LIMIT = "ResourceLimit";
    public static final String SEEK_OUT_OF_RANGE = "SeekOutOfRange";
    public static final String UN_AUTHORIZED = "Unauthorized";
    public static final String NO_PERMISSION = "NoPermission";
    public static final String INVALID_SHARD_OPERATION = "InvalidShardOperation";
    public static final String OPERATOR_DENIED = "OperationDenied";
    public static final String LIMIT_EXCEED = "LimitExceeded";
    public static final String ODPS_SERVICE_ERROR = "OdpsServiceError";
    public static final String MYSQL_SERVICE_ERROR = "MysqlServiceError";
    public static final String INTERNAL_SERVER_ERROR = "InternalServerError";
    public static final String SUBSCRIPTION_OFFLINE = "SubscriptionOffline";
    public static final String OFFSET_RESETED = "OffsetReseted";
    public static final String OFFSET_SESSION_CLOSED = "OffsetSessionClosed";
    public static final String OFFSET_SESSION_CHANGED = "OffsetSessionChanged";
    public static final String MALFORMED_RECORD = "MalformedRecord";
    public static final String NO_SUCH_CONSUMER = "NoSuchConsumer";
    public static final String CONSUMER_GROUP_IN_PROCESS = "ConsumerGroupInProcess";
    public static final String EXPIRED_ACCESS_TOKEN = "ExpiredAccessToken";
    public static final String TOPIC_OFFLINE = "TopicOffline";
    private static final Set<String> FATAL_ERROR_CODE = new HashSet<String>(){
        {
            this.add(ErrorCode.NO_SUCH_PROJECT);
            this.add(ErrorCode.NO_SUCH_TOPIC);
            this.add(ErrorCode.NO_SUCH_CONNECTOR);
            this.add(ErrorCode.NO_SUCH_METER_INFO);
            this.add(ErrorCode.NO_SUCH_ALARM_RULE);
            this.add(ErrorCode.RESOURCE_ALREADY_EXIST);
            this.add(ErrorCode.PROJECT_ALREADY_EXIST);
            this.add(ErrorCode.TOPIC_ALREADY_EXIST);
            this.add(ErrorCode.CONNECTOR_ALREADY_EXIST);
            this.add(ErrorCode.USER_ALREADY_EXIST);
            this.add(ErrorCode.ALARM_RULE_ALREADY_EXIST);
            this.add(ErrorCode.UN_AUTHORIZED);
            this.add(ErrorCode.NO_PERMISSION);
            this.add(ErrorCode.OPERATOR_DENIED);
            this.add(ErrorCode.INVALID_SHARD_OPERATION);
            this.add(ErrorCode.SEEK_OUT_OF_RANGE);
            this.add(ErrorCode.MALFORMED_RECORD);
            this.add(ErrorCode.INVALID_PARAMETER);
            this.add(ErrorCode.INVALID_CURSOR);
            this.add(ErrorCode.RESOURCE_LIMIT);
            this.add(ErrorCode.OFFSET_RESETED);
            this.add(ErrorCode.OFFSET_SESSION_CHANGED);
            this.add(ErrorCode.OFFSET_SESSION_CLOSED);
        }
    };

    public static boolean canRetry(String errorCode) {
        return !FATAL_ERROR_CODE.contains(errorCode);
    }
}

