/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.example.examples;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.DatahubClientBuilder;
import com.aliyun.datahub.client.auth.AliyunAccount;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.AuthorizationFailureException;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.ResourceNotFoundException;
import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.client.model.CompressType;
import com.aliyun.datahub.client.model.ConnectorConfig;
import com.aliyun.datahub.client.model.ConnectorOffset;
import com.aliyun.datahub.client.model.ConnectorShardStatusEntry;
import com.aliyun.datahub.client.model.ConnectorState;
import com.aliyun.datahub.client.model.ConnectorType;
import com.aliyun.datahub.client.model.CreateConnectorResult;
import com.aliyun.datahub.client.model.GetConnectorDoneTimeResult;
import com.aliyun.datahub.client.model.GetConnectorResult;
import com.aliyun.datahub.client.model.GetConnectorShardStatusResult;
import com.aliyun.datahub.client.model.ListConnectorResult;
import com.aliyun.datahub.client.model.SinkOdpsConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConnectorExample {
    private static DatahubClient datahubClient;
    private static String shardId;
    private static String connectorId;

    public static void init() {
        HttpConfig httpConfig = new HttpConfig();
        httpConfig.setCompressType(CompressType.DEFLATE);
        datahubClient = DatahubClientBuilder.newBuilder().setDatahubConfig(new DatahubConfig("", new AliyunAccount("", ""), true)).setHttpConfig(httpConfig).build();
        shardId = "0";
        connectorId = "";
    }

    public static void createConnector() {
        List<String> columnFields = Arrays.asList("field1", "field2");
        SinkOdpsConfig config = new SinkOdpsConfig(){
            {
                this.setEndpoint("");
                this.setProject("");
                this.setTable("");
                this.setAccessId("");
                this.setAccessKey("=");
                this.setPartitionMode(SinkOdpsConfig.PartitionMode.SYSTEM_TIME);
                this.setTimeRange(60);
            }
        };
        SinkOdpsConfig.PartitionConfig partitionConfig = new SinkOdpsConfig.PartitionConfig(){
            {
                this.addConfig("ds", "%Y%m%d");
                this.addConfig("hh", "%H");
                this.addConfig("mm", "%M");
            }
        };
        config.setPartitionConfig(partitionConfig);
        try {
            CreateConnectorResult result = datahubClient.createConnector("", "", ConnectorType.SINK_ODPS, columnFields, config);
            System.out.println("create  connector successful");
            System.out.println(result.getConnectorId());
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void deleteConnector() {
        try {
            datahubClient.deleteConnector("", "", connectorId);
            System.out.println("delete  connector successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateConnector() {
        SinkOdpsConfig config = (SinkOdpsConfig)datahubClient.getConnector("", "", connectorId).getConfig();
        config.setTimeRange(100);
        config.setAccessId("");
        config.setAccessKey("");
        try {
            datahubClient.updateConnector("", "", ConnectorType.SINK_ODPS, (ConnectorConfig)config);
            System.out.println("update  connector successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateConnectorState() {
        try {
            datahubClient.updateConnectorState("", "", connectorId, ConnectorState.STOPPED);
            datahubClient.updateConnectorState("", "", connectorId, ConnectorState.RUNNING);
            System.out.println("update  connector state successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateConnectorOffset() {
        ConnectorOffset offset = new ConnectorOffset(){
            {
                this.setSequence(10L);
                this.setTimestamp(1000L);
            }
        };
        try {
            datahubClient.updateConnectorState("", "", connectorId, ConnectorState.STOPPED);
            datahubClient.updateConnectorOffset("", "", connectorId, shardId, offset);
            datahubClient.updateConnectorState("", "", connectorId, ConnectorState.RUNNING);
            System.out.println("update  connector offset successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void listConnector() {
        try {
            ListConnectorResult listConnectorResult = datahubClient.listConnector("", "");
            for (String cName : listConnectorResult.getConnectorNames()) {
                System.out.println(cName);
            }
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void getConnector() {
        try {
            GetConnectorResult getConnectorResult = datahubClient.getConnector("", "", connectorId);
            System.out.println((Object)((Object)getConnectorResult.getState()) + "\t" + getConnectorResult.getSubId());
            for (String fieldName : getConnectorResult.getColumnFields()) {
                System.out.println(fieldName);
            }
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void getConnectorShardStatusByShard() {
        try {
            ConnectorShardStatusEntry connectorShardStatusEntry = datahubClient.getConnectorShardStatus("", "", connectorId, shardId);
            System.out.println((Object)((Object)connectorShardStatusEntry.getState()) + "\t" + connectorShardStatusEntry.getCurrSequence() + "\t" + connectorShardStatusEntry.getDiscardCount() + "\t" + connectorShardStatusEntry.getUpdateTime());
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void getConnectorShardStatus() {
        try {
            GetConnectorShardStatusResult getConnectorShardStatusResult = datahubClient.getConnectorShardStatus("", "", connectorId);
            for (Map.Entry<String, ConnectorShardStatusEntry> entry : getConnectorShardStatusResult.getStatusEntryMap().entrySet()) {
                System.out.println(entry.getKey() + " : " + (Object)((Object)entry.getValue().getState()) + "\t" + entry.getValue().getCurrSequence() + "\t" + entry.getValue().getDiscardCount() + "\t" + entry.getValue().getUpdateTime());
            }
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void reloadConnector() {
        try {
            datahubClient.reloadConnector("", "", connectorId);
            System.out.println("reload connector successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void reloadConnectorByShard() {
        try {
            datahubClient.reloadConnector("", "", connectorId, shardId);
            System.out.println("reload connector successful");
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void getDoneTime() {
        try {
            GetConnectorDoneTimeResult getConnectorDoneTimeResult = datahubClient.getConnectorDoneTime("", "", connectorId);
            System.out.println(getConnectorDoneTimeResult.getDoneTime());
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void appendConnectorField() {
        String newField = "newfield";
        try {
            datahubClient.appendConnectorField("", "", connectorId, newField);
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            throw e;
        }
        catch (AuthorizationFailureException e) {
            e.printStackTrace();
            throw e;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (DatahubClientException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args) {
        ConnectorExample.init();
        ConnectorExample.createConnector();
    }
}

