/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http;

import com.aliyun.datahub.client.auth.Account;
import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.client.http.TimeoutCache;
import com.aliyun.datahub.client.http.converter.EmptyBodyConverterFactory;
import com.aliyun.datahub.client.http.converter.ProtobufConverterFactory;
import com.aliyun.datahub.client.http.interceptor.Http2RetryInterceptor;
import com.aliyun.datahub.client.http.interceptor.InterceptorWrapper;
import com.aliyun.datahub.client.http.interceptor.compress.DeflateRequestInterceptor;
import com.aliyun.datahub.client.http.interceptor.compress.Lz4RequestInterceptor;
import com.aliyun.datahub.client.model.CompressType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    private static final long CLIENT_CACHE_TIMEOUT_MS = 60000L;
    private static ConnectionPool connectionPool;
    private static int maxIdleConnections;
    private static ObjectMapper DEFAULT_MAPPER;
    private static TimeoutCache<ClientConfig, Retrofit> clientMap;

    public static Retrofit createClient(String endpoint, HttpConfig config) {
        return HttpClient.createClient(endpoint, config, new InterceptorWrapper());
    }

    public static void close() {
        if (connectionPool != null) {
            connectionPool.evictAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Retrofit createClient(String endpoint, HttpConfig config, InterceptorWrapper wrapper) {
        ClientConfig clientConfig;
        Retrofit retrofit;
        if (!endpoint.startsWith("http")) {
            endpoint = "http://" + endpoint;
        }
        if (!endpoint.endsWith("/")) {
            endpoint = endpoint + "/";
        }
        if ((retrofit = clientMap.get(clientConfig = new ClientConfig(endpoint, config, wrapper.getAuth().getAccount()))) != null) return retrofit;
        Class<HttpClient> clazz = HttpClient.class;
        synchronized (HttpClient.class) {
            retrofit = clientMap.get(clientConfig);
            if (retrofit != null) return retrofit;
            retrofit = HttpClient.newClient(endpoint, config, wrapper);
            clientMap.put(clientConfig, retrofit);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return retrofit;
        }
    }

    private static Retrofit newClient(String endpoint, HttpConfig config, InterceptorWrapper wrapper) {
        return new Retrofit.Builder().client(HttpClient.buildClient(config, wrapper)).addConverterFactory((Converter.Factory)EmptyBodyConverterFactory.create()).addConverterFactory((Converter.Factory)ProtobufConverterFactory.create(true)).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)DEFAULT_MAPPER)).baseUrl(endpoint).build();
    }

    private static OkHttpClient buildClient(final HttpConfig config, InterceptorWrapper wrapper) {
        if (connectionPool == null) {
            connectionPool = new ConnectionPool(maxIdleConnections, 60L, TimeUnit.SECONDS);
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(connectionPool).socketFactory((SocketFactory)new NoDelaySocketFactory(config.getNetworkInterface())).readTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS).connectTimeout((long)config.getConnTimeout(), TimeUnit.MILLISECONDS).sslSocketFactory(HttpClient.sslSocketFactory(), HttpClient.x509TrustManager()).hostnameVerifier((s, sslSession) -> true).addInterceptor((Interceptor)wrapper.getResponse()).retryOnConnectionFailure(true);
        if (config.isEnableH2C()) {
            builder.protocols(Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE));
        }
        if (config.getCompressType() == CompressType.DEFLATE) {
            builder.addInterceptor((Interceptor)new DeflateRequestInterceptor());
        } else if (config.getCompressType() == CompressType.LZ4) {
            builder.addInterceptor((Interceptor)new Lz4RequestInterceptor());
        }
        builder.addInterceptor((Interceptor)wrapper.getAuth());
        if (!StringUtils.isEmpty((CharSequence)config.getProxyUri())) {
            String proxyUri = config.getProxyUri();
            int index = proxyUri.lastIndexOf(":");
            final String proxyHost = proxyUri.substring(0, index);
            String proxyPortStr = proxyUri.substring(index + 1);
            int proxyPort = StringUtils.isEmpty((CharSequence)proxyPortStr) ? 80 : Integer.valueOf(proxyPortStr);
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort))).proxyAuthenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)config.getProxyUsername(), (String)proxyHost);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            });
        }
        if (config.isDebugRequest()) {
            builder.addInterceptor((Interceptor)HttpClient.loggingInterceptor());
        }
        if (config.isEnableH2C()) {
            builder.addInterceptor((Interceptor)new Http2RetryInterceptor());
        }
        return builder.build();
    }

    private static HttpLoggingInterceptor loggingInterceptor() {
        HttpLoggingInterceptor.Logger customLogger = new HttpLoggingInterceptor.Logger(){

            public void log(String message) {
                LOGGER.info("DataHubClient: " + message);
            }
        };
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(customLogger);
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return loggingInterceptor;
    }

    public static X509TrustManager x509TrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    public static SSLSocketFactory sslSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{HttpClient.x509TrustManager()}, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException ex) {
            LOGGER.warn(ex.toString());
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static int getMaxIdleConnections() {
        return maxIdleConnections;
    }

    public static void setMaxIdleConnections(int maxIdleConnections) {
        HttpClient.maxIdleConnections = maxIdleConnections;
    }

    static {
        maxIdleConnections = Integer.MAX_VALUE;
        clientMap = new TimeoutCache(60000L);
        DEFAULT_MAPPER = new ObjectMapper();
        DEFAULT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        DEFAULT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        DEFAULT_MAPPER.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
    }

    public static class NoDelaySocketFactory
    extends SocketFactory {
        private final String networkInterface;

        public NoDelaySocketFactory(String networkInterface) {
            this.networkInterface = networkInterface;
        }

        @Override
        public Socket createSocket() throws SocketException {
            Socket ret = new Socket();
            ret.setTcpNoDelay(true);
            if (!StringUtils.isEmpty((CharSequence)this.networkInterface)) {
                try {
                    NetworkInterface ni = NetworkInterface.getByName(this.networkInterface);
                    if (ni == null) {
                        throw new SocketException("Not find interface " + this.networkInterface);
                    }
                    Enumeration<InetAddress> enumeration = ni.getInetAddresses();
                    if (!enumeration.hasMoreElements()) {
                        throw new SocketException("Not find address for " + this.networkInterface);
                    }
                    ret.bind(new InetSocketAddress(enumeration.nextElement(), 0));
                }
                catch (Exception e) {
                    throw new SocketException(e.getMessage());
                }
            }
            return ret;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            Socket socket = this.createSocket();
            try {
                socket.connect(new InetSocketAddress(host, port));
            }
            catch (IOException e) {
                socket.close();
                throw e;
            }
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress address, int port) throws IOException {
            Socket socket = this.createSocket();
            try {
                socket.connect(new InetSocketAddress(address, port));
            }
            catch (IOException e) {
                socket.close();
                throw e;
            }
            return socket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress clientAddress, int clientPort) throws IOException {
            Socket socket = this.createSocket();
            try {
                socket.bind(new InetSocketAddress(clientAddress, clientPort));
                socket.connect(new InetSocketAddress(host, port));
            }
            catch (IOException e) {
                socket.close();
                throw e;
            }
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
            Socket socket = this.createSocket();
            try {
                socket.bind(new InetSocketAddress(clientAddress, clientPort));
                socket.connect(new InetSocketAddress(address, port));
            }
            catch (IOException e) {
                socket.close();
                throw e;
            }
            return socket;
        }
    }

    private static class ClientConfig {
        private String endpoint;
        private HttpConfig config;
        private Account account;

        public ClientConfig(String endpoint, HttpConfig config, Account account) {
            this.endpoint = endpoint;
            this.config = config;
            this.account = account;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientConfig that = (ClientConfig)o;
            return Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.config, that.config) && Objects.equals(this.account, that.account);
        }

        public int hashCode() {
            return Objects.hash(this.endpoint, this.config, this.account);
        }
    }
}

