/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl;

import com.aliyun.datahub.client.auth.Account;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.exception.OperationDeniedException;
import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.client.impl.AbstractDatahubClient;
import com.aliyun.datahub.client.impl.request.AppendConnectorFieldRequest;
import com.aliyun.datahub.client.impl.request.AppendFieldRequest;
import com.aliyun.datahub.client.impl.request.CommitSubscriptionOffsetRequest;
import com.aliyun.datahub.client.impl.request.CreateAlarmRuleRequest;
import com.aliyun.datahub.client.impl.request.CreateConnectorRequest;
import com.aliyun.datahub.client.impl.request.CreateKafkaGroupRequest;
import com.aliyun.datahub.client.impl.request.CreateProjectRequest;
import com.aliyun.datahub.client.impl.request.CreateSubscriptionRequest;
import com.aliyun.datahub.client.impl.request.CreateTopicRequest;
import com.aliyun.datahub.client.impl.request.DeleteTopicSchemaRequest;
import com.aliyun.datahub.client.impl.request.ExtendShardRequest;
import com.aliyun.datahub.client.impl.request.GetConnectorShardStatusRequest;
import com.aliyun.datahub.client.impl.request.GetCursorRequest;
import com.aliyun.datahub.client.impl.request.GetMeterInfoRequest;
import com.aliyun.datahub.client.impl.request.GetRecordsRequest;
import com.aliyun.datahub.client.impl.request.GetSubscriptionOffsetRequest;
import com.aliyun.datahub.client.impl.request.GetTopicSchemaRequest;
import com.aliyun.datahub.client.impl.request.HeartbeatRequest;
import com.aliyun.datahub.client.impl.request.JoinGroupRequest;
import com.aliyun.datahub.client.impl.request.LeaveGroupRequest;
import com.aliyun.datahub.client.impl.request.ListAlarmRuleRequest;
import com.aliyun.datahub.client.impl.request.ListMetaLogRequest;
import com.aliyun.datahub.client.impl.request.ListSubscriptionByKafkaGroupRequest;
import com.aliyun.datahub.client.impl.request.ListSubscriptionRequest;
import com.aliyun.datahub.client.impl.request.ListTopicSchemaRequest;
import com.aliyun.datahub.client.impl.request.MergeShardRequest;
import com.aliyun.datahub.client.impl.request.OpenSubscriptionSessionRequest;
import com.aliyun.datahub.client.impl.request.PutRecordsRequest;
import com.aliyun.datahub.client.impl.request.RegisterTopicSchemaRequest;
import com.aliyun.datahub.client.impl.request.ReloadConnectorRequest;
import com.aliyun.datahub.client.impl.request.ResetSubscriptionOffsetRequest;
import com.aliyun.datahub.client.impl.request.SplitShardRequest;
import com.aliyun.datahub.client.impl.request.SyncGroupRequest;
import com.aliyun.datahub.client.impl.request.UpdateAlarmRuleRequest;
import com.aliyun.datahub.client.impl.request.UpdateConnectorOffsetRequest;
import com.aliyun.datahub.client.impl.request.UpdateConnectorRequest;
import com.aliyun.datahub.client.impl.request.UpdateConnectorStateRequest;
import com.aliyun.datahub.client.impl.request.UpdateKafkaGroupRequest;
import com.aliyun.datahub.client.impl.request.UpdateProjectRequest;
import com.aliyun.datahub.client.impl.request.UpdateProjectVpcWhiteListRequest;
import com.aliyun.datahub.client.impl.request.UpdateSubscriptionRequest;
import com.aliyun.datahub.client.impl.request.UpdateTopicRequest;
import com.aliyun.datahub.client.impl.request.UpdateTopicsForKafkaGroupRequest;
import com.aliyun.datahub.client.model.AlarmRule;
import com.aliyun.datahub.client.model.AppendConnectorFieldResult;
import com.aliyun.datahub.client.model.AppendFieldResult;
import com.aliyun.datahub.client.model.CommitSubscriptionOffsetResult;
import com.aliyun.datahub.client.model.ConnectorConfig;
import com.aliyun.datahub.client.model.ConnectorOffset;
import com.aliyun.datahub.client.model.ConnectorShardStatusEntry;
import com.aliyun.datahub.client.model.ConnectorState;
import com.aliyun.datahub.client.model.ConnectorType;
import com.aliyun.datahub.client.model.CreateAlarmRuleResult;
import com.aliyun.datahub.client.model.CreateConnectorResult;
import com.aliyun.datahub.client.model.CreateKafkaGroupResult;
import com.aliyun.datahub.client.model.CreateProjectResult;
import com.aliyun.datahub.client.model.CreateSubscriptionResult;
import com.aliyun.datahub.client.model.CreateTopicResult;
import com.aliyun.datahub.client.model.CursorType;
import com.aliyun.datahub.client.model.DeleteAlarmRuleResult;
import com.aliyun.datahub.client.model.DeleteConnectorResult;
import com.aliyun.datahub.client.model.DeleteKafkaGroupResult;
import com.aliyun.datahub.client.model.DeleteProjectResult;
import com.aliyun.datahub.client.model.DeleteSubscriptionResult;
import com.aliyun.datahub.client.model.DeleteTopicResult;
import com.aliyun.datahub.client.model.DeleteTopicSchemaResult;
import com.aliyun.datahub.client.model.ExpandMode;
import com.aliyun.datahub.client.model.ExtendShardResult;
import com.aliyun.datahub.client.model.Field;
import com.aliyun.datahub.client.model.GetAlarmRuleResult;
import com.aliyun.datahub.client.model.GetConnectorDoneTimeResult;
import com.aliyun.datahub.client.model.GetConnectorResult;
import com.aliyun.datahub.client.model.GetConnectorShardStatusResult;
import com.aliyun.datahub.client.model.GetCursorResult;
import com.aliyun.datahub.client.model.GetKafkaGroupResult;
import com.aliyun.datahub.client.model.GetMeterInfoResult;
import com.aliyun.datahub.client.model.GetProjectResult;
import com.aliyun.datahub.client.model.GetRecordsResult;
import com.aliyun.datahub.client.model.GetSubscriptionOffsetResult;
import com.aliyun.datahub.client.model.GetSubscriptionResult;
import com.aliyun.datahub.client.model.GetTopicResult;
import com.aliyun.datahub.client.model.GetTopicSchemaResult;
import com.aliyun.datahub.client.model.HeartbeatResult;
import com.aliyun.datahub.client.model.JoinGroupResult;
import com.aliyun.datahub.client.model.LeaveGroupResult;
import com.aliyun.datahub.client.model.ListAlarmRuleResult;
import com.aliyun.datahub.client.model.ListConnectorResult;
import com.aliyun.datahub.client.model.ListKafkaGroupResult;
import com.aliyun.datahub.client.model.ListMetaLogResult;
import com.aliyun.datahub.client.model.ListProjectResult;
import com.aliyun.datahub.client.model.ListShardResult;
import com.aliyun.datahub.client.model.ListSubscriptionByKafkaGroupResult;
import com.aliyun.datahub.client.model.ListSubscriptionResult;
import com.aliyun.datahub.client.model.ListTopicByKafkaGroupResult;
import com.aliyun.datahub.client.model.ListTopicResult;
import com.aliyun.datahub.client.model.ListTopicSchemaResult;
import com.aliyun.datahub.client.model.MergeShardResult;
import com.aliyun.datahub.client.model.OpenSubscriptionSessionResult;
import com.aliyun.datahub.client.model.PutErrorEntry;
import com.aliyun.datahub.client.model.PutRecordsByShardResult;
import com.aliyun.datahub.client.model.PutRecordsResult;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.RecordType;
import com.aliyun.datahub.client.model.RegisterTopicSchemaResult;
import com.aliyun.datahub.client.model.ReloadConnectorResult;
import com.aliyun.datahub.client.model.ResetSubscriptionOffsetResult;
import com.aliyun.datahub.client.model.ShardEntry;
import com.aliyun.datahub.client.model.ShardState;
import com.aliyun.datahub.client.model.SplitShardResult;
import com.aliyun.datahub.client.model.SubscriptionEntry;
import com.aliyun.datahub.client.model.SubscriptionOffset;
import com.aliyun.datahub.client.model.SubscriptionState;
import com.aliyun.datahub.client.model.SyncGroupResult;
import com.aliyun.datahub.client.model.TupleRecordData;
import com.aliyun.datahub.client.model.UpdateAlarmRuleResult;
import com.aliyun.datahub.client.model.UpdateConnectorOffsetResult;
import com.aliyun.datahub.client.model.UpdateConnectorResult;
import com.aliyun.datahub.client.model.UpdateConnectorStateResult;
import com.aliyun.datahub.client.model.UpdateKafkaGroupMode;
import com.aliyun.datahub.client.model.UpdateKafkaGroupResult;
import com.aliyun.datahub.client.model.UpdateProjectResult;
import com.aliyun.datahub.client.model.UpdateProjectVpcWhitelistResult;
import com.aliyun.datahub.client.model.UpdateSubscriptionResult;
import com.aliyun.datahub.client.model.UpdateSubscriptionStateResult;
import com.aliyun.datahub.client.model.UpdateTopicResult;
import com.aliyun.datahub.client.model.UpdateTopicsForKafkaGroupResult;
import com.aliyun.datahub.client.util.FormatUtils;
import com.aliyun.datahub.client.util.KeyRangeUtils;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DatahubClientJsonImpl
extends AbstractDatahubClient {
    public DatahubClientJsonImpl(String endpoint, Account account, DatahubConfig datahubConfig, HttpConfig httpConfig, String userAgent) {
        super(endpoint, account, datahubConfig, httpConfig, userAgent);
    }

    @Override
    public GetProjectResult getProject(String projectName) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        GetProjectResult result = this.callWrapper(this.getService().getProject(projectName));
        if (result != null) {
            result.setProjectName(projectName.toLowerCase());
        }
        return result;
    }

    @Override
    public ListProjectResult listProject() {
        return this.listProject(null);
    }

    @Override
    public ListProjectResult listProject(String filter) {
        return this.callWrapper(this.getService().listProject(filter));
    }

    @Override
    public CreateProjectResult createProject(String projectName, String comment) {
        if (!FormatUtils.checkProjectName(projectName, true)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkComment(comment)) {
            throw new InvalidParameterException("Comment format is invalid");
        }
        CreateProjectRequest request = new CreateProjectRequest().setComment(comment);
        return this.callWrapper(this.getService().createProject(projectName, request));
    }

    @Override
    public UpdateProjectResult updateProject(String projectName, String comment) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkComment(comment)) {
            throw new InvalidParameterException("Comment format is invalid");
        }
        UpdateProjectRequest request = new UpdateProjectRequest().setComment(comment);
        return this.callWrapper(this.getService().updateProject(projectName, request));
    }

    @Override
    public UpdateProjectVpcWhitelistResult updateProjectVpcWhitelist(String projectName, String vpcIds) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkComment(vpcIds)) {
            throw new InvalidParameterException("VpcIds format is invalid");
        }
        UpdateProjectVpcWhiteListRequest request = new UpdateProjectVpcWhiteListRequest().setVpcIds(vpcIds);
        return this.callWrapper(this.getService().updateProject(projectName, request));
    }

    @Override
    public DeleteProjectResult deleteProject(String projectName) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        return this.callWrapper(this.getService().deleteProject(projectName));
    }

    @Override
    public void waitForShardReady(String projectName, String topicName) {
        this.waitForShardReady(projectName, topicName, 30000L);
    }

    @Override
    public void waitForShardReady(String projectName, String topicName, long timeout) {
        if (timeout < 0L) {
            throw new InvalidParameterException("Invalid timeout value: " + timeout);
        }
        timeout = Math.min(timeout, 30000L);
        long start = System.currentTimeMillis();
        long end = start + timeout;
        boolean allShardReady = false;
        while (start < end && !(allShardReady = this.isAllShardReady(projectName, topicName))) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            start = System.currentTimeMillis();
        }
        if (!allShardReady) {
            throw new DatahubClientException("Wait loading shards timeout");
        }
    }

    private boolean isAllShardReady(String projectName, String topicName) {
        ListShardResult result = this.listShard(projectName, topicName);
        for (ShardEntry entry : result.getShards()) {
            if (ShardState.ACTIVE == entry.getState() || ShardState.CLOSED == entry.getState()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CreateTopicResult createTopic(String projectName, String topicName, int shardCount, int lifeCycle, RecordType recordType, String comment) {
        return this.createTopic(projectName, topicName, shardCount, lifeCycle, recordType, null, comment, ExpandMode.SPLIT_EXTEND);
    }

    @Override
    public CreateTopicResult createTopic(String projectName, String topicName, int shardCount, int lifeCycle, RecordType recordType, String comment, ExpandMode expandMode) {
        return this.createTopic(projectName, topicName, shardCount, lifeCycle, recordType, null, comment, expandMode);
    }

    @Override
    public CreateTopicResult createTopic(String projectName, String topicName, int shardCount, int lifeCycle, RecordType recordType, RecordSchema recordSchema, String comment) {
        return this.createTopic(projectName, topicName, shardCount, lifeCycle, recordType, recordSchema, comment, ExpandMode.SPLIT_EXTEND);
    }

    @Override
    public CreateTopicResult createTopic(String projectName, String topicName, int shardCount, int lifeCycle, RecordType recordType, RecordSchema recordSchema, String comment, ExpandMode expandMode) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("Project name format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName, true)) {
            throw new InvalidParameterException("Topic name format is invalid");
        }
        if (shardCount <= 0) {
            throw new InvalidParameterException("ShardCount is invalid");
        }
        if (lifeCycle <= 0) {
            throw new InvalidParameterException("LifeCycle is invalid");
        }
        if (!FormatUtils.checkComment(comment)) {
            throw new InvalidParameterException("Comment format is invalid");
        }
        if (recordType == RecordType.TUPLE && recordSchema == null || recordType == RecordType.BLOB && recordSchema != null) {
            throw new InvalidParameterException("Record type is invalid");
        }
        CreateTopicRequest request = new CreateTopicRequest().setShardCount(shardCount).setLifeCycle(lifeCycle).setRecordType(recordType).setRecordSchema(recordSchema).setComment(comment).setExpandMode(expandMode);
        return this.callWrapper(this.getService().createTopic(projectName, topicName, request));
    }

    @Override
    public UpdateTopicResult updateTopic(String projectName, String topicName, String comment) {
        return this.updateTopic(projectName, topicName, -1, comment);
    }

    @Override
    public UpdateTopicResult updateTopic(String projectName, String topicName, int lifeCycle, String comment) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (lifeCycle == 0) {
            throw new InvalidParameterException("LifeCycle is invalid");
        }
        if (!FormatUtils.checkComment(comment)) {
            throw new InvalidParameterException("Comment format is invalid");
        }
        UpdateTopicRequest request = new UpdateTopicRequest().setComment(comment);
        if (lifeCycle > 0) {
            request.setLifeCycle(lifeCycle);
        }
        return this.callWrapper(this.getService().updateTopic(projectName, topicName, request));
    }

    @Override
    public GetTopicResult getTopic(String projectName, String topicName) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        GetTopicResult result = this.callWrapper(this.getService().getTopic(projectName, topicName));
        if (result != null) {
            result.setProjectName(projectName);
            result.setTopicName(topicName);
        }
        return result;
    }

    @Override
    public DeleteTopicResult deleteTopic(String projectName, String topicName) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        return this.callWrapper(this.getService().deleteTopic(projectName, topicName));
    }

    @Override
    public ListTopicResult listTopic(String projectName) {
        return this.listTopic(projectName, null);
    }

    @Override
    public ListTopicResult listTopic(String projectName, String filter) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        return this.callWrapper(this.getService().listTopic(projectName, filter));
    }

    @Override
    public ListShardResult listShard(String projectName, String topicName) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        ListShardResult result = this.callWrapper(this.getService().listShard(projectName, topicName));
        if (result != null) {
            for (ShardEntry entry : result.getShards()) {
                if (MAX_SHARD_ID.equals(entry.getLeftShardId())) {
                    entry.setLeftShardId(null);
                }
                if (!MAX_SHARD_ID.equals(entry.getRightShardId())) continue;
                entry.setRightShardId(null);
            }
        }
        return result;
    }

    @Override
    public SplitShardResult splitShard(String projectName, String topicName, String shardId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (!FormatUtils.checkShardId(shardId)) {
            throw new InvalidParameterException("ShardId format is invalid");
        }
        String splitKey = this.getSplitKey(projectName, topicName, shardId);
        return this.splitShard(projectName, topicName, shardId, splitKey);
    }

    private String getSplitKey(String projectName, String topicName, String shardId) {
        String splitKey = null;
        ListShardResult originShards = this.listShard(projectName, topicName);
        for (ShardEntry entry : originShards.getShards()) {
            if (!shardId.equalsIgnoreCase(entry.getShardId())) continue;
            if (entry.getState() != ShardState.ACTIVE) {
                throw new OperationDeniedException("Only active shard can be split");
            }
            try {
                splitKey = KeyRangeUtils.trivialSplit(entry.getBeginHashKey(), entry.getEndHashKey());
            }
            catch (Exception e) {
                throw new DatahubClientException(e.getMessage());
            }
        }
        if (splitKey == null) {
            throw new DatahubClientException("Shard not exist");
        }
        return splitKey;
    }

    @Override
    public SplitShardResult splitShard(String projectName, String topicName, String shardId, String splitKey) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (!FormatUtils.checkShardId(shardId)) {
            throw new InvalidParameterException("ShardId format is invalid");
        }
        SplitShardRequest request = new SplitShardRequest().setShardId(shardId).setSplitKey(splitKey);
        return this.callWrapper(this.getService().splitShard(projectName, topicName, request));
    }

    @Override
    public MergeShardResult mergeShard(String projectName, String topicName, String shardId, String adjacentShardId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (!FormatUtils.checkShardId(shardId) || !FormatUtils.checkShardId(adjacentShardId)) {
            throw new InvalidParameterException("ShardId format is invalid");
        }
        MergeShardRequest request = new MergeShardRequest().setShardId(shardId).setAdjacentShardId(adjacentShardId);
        return this.callWrapper(this.getService().mergeShard(projectName, topicName, request));
    }

    @Override
    public ExtendShardResult extendShard(String projectName, String topicName, int shardCount) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (shardCount <= 0) {
            throw new InvalidParameterException("ShardCount value is invalid");
        }
        ExtendShardRequest request = new ExtendShardRequest().setShardCount(shardCount).setExtendMode(ExtendShardRequest.ExtendMode.TO);
        return this.callWrapper(this.getService().extendShard(projectName, topicName, request));
    }

    @Override
    public GetCursorResult getCursor(String projectName, String topicName, String shardId, CursorType type) {
        return this.getCursor(projectName, topicName, shardId, type, -1L);
    }

    @Override
    public GetCursorResult getCursor(String projectName, String topicName, String shardId, CursorType type, long parameter) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (!FormatUtils.checkShardId(shardId)) {
            throw new InvalidParameterException("ShardId format is invalid");
        }
        if (type == null) {
            throw new InvalidParameterException("Type is null");
        }
        if ((type == CursorType.SEQUENCE || type == CursorType.SYSTEM_TIME) && parameter == -1L) {
            throw new InvalidParameterException("Cursor type or parameter is invalid");
        }
        GetCursorRequest request = new GetCursorRequest().setType(type).setParameter(parameter);
        return this.callWrapper(this.getService().getCursor(projectName, topicName, shardId, request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRecordsResult putRecords(String projectName, String topicName, List<RecordEntry> records) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (records == null || records.isEmpty()) {
            throw new InvalidParameterException("Records is null or empty");
        }
        PutRecordsRequest request = new PutRecordsRequest().setRecords(records);
        Timer.Context context = this.PUT_LATENCY_TIMER == null ? null : this.PUT_LATENCY_TIMER.time();
        try {
            PutRecordsResult result = this.callWrapper(this.getService().putRecords(projectName, topicName, request));
            if (result != null) {
                if (result.getFailedRecordCount() > 0) {
                    ArrayList<RecordEntry> failedRecords = new ArrayList<RecordEntry>();
                    for (PutErrorEntry errorEntry : result.getPutErrorEntries()) {
                        failedRecords.add(request.getRecords().get(errorEntry.getIndex()));
                    }
                    result.setFailedRecords(failedRecords);
                }
                if (this.PUT_QPS_METER != null) {
                    this.PUT_QPS_METER.mark(1L);
                }
                if (this.PUT_RPS_METER != null) {
                    this.PUT_RPS_METER.mark((long)(records.size() - result.getFailedRecordCount()));
                }
            }
            PutRecordsResult putRecordsResult = result;
            return putRecordsResult;
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }

    @Override
    public PutRecordsByShardResult putRecordsByShard(String projectName, String topicName, String shardId, List<RecordEntry> records) {
        throw new DatahubClientException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecordsResult getRecords(String projectName, String topicName, String shardId, String cursor, int limit) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)cursor)) {
            throw new InvalidParameterException("Cursor format is invalid");
        }
        limit = Math.max(1, limit);
        limit = Math.min(1000, limit);
        GetRecordsRequest request = new GetRecordsRequest().setCursor(cursor).setLimit(limit);
        Timer.Context context = this.GET_LATENCY_TIMER == null ? null : this.GET_LATENCY_TIMER.time();
        try {
            GetRecordsResult result = this.callWrapper(this.getService().getRecords(projectName, topicName, shardId, request));
            if (result != null) {
                if (result.getRecordCount() > 0) {
                    for (RecordEntry entry : result.getRecords()) {
                        entry.setShardId(shardId);
                    }
                }
                if (this.GET_QPS_METER != null) {
                    this.GET_QPS_METER.mark(1L);
                }
                if (this.GET_RPS_METER != null) {
                    this.GET_RPS_METER.mark((long)result.getRecordCount());
                }
            }
            GetRecordsResult getRecordsResult = result;
            return getRecordsResult;
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }

    @Override
    public GetRecordsResult getRecords(String projectName, String topicName, String shardId, RecordSchema schema, String cursor, int limit) {
        if (schema == null) {
            throw new InvalidParameterException("Record schema is null");
        }
        GetRecordsResult result = this.getRecords(projectName, topicName, shardId, cursor, limit);
        for (RecordEntry entry : result.getRecords()) {
            if (entry.getRecordData() == null || !(entry.getRecordData() instanceof TupleRecordData)) {
                throw new DatahubClientException("Shouldn't call this method for BLOB topic");
            }
            ((TupleRecordData)entry.getRecordData()).internalConvertAuxValues(schema);
        }
        return result;
    }

    @Override
    public AppendFieldResult appendField(String projectName, String topicName, Field field) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (field == null || !field.isAllowNull()) {
            throw new InvalidParameterException("append field must allow null value");
        }
        AppendFieldRequest request = new AppendFieldRequest().setFieldName(field.getName()).setFieldType(field.getType());
        return this.callWrapper(this.getService().appendField(projectName, topicName, request));
    }

    @Override
    public AppendFieldResult appendField(String projectName, String topicName, List<Field> fields) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (fields == null || fields.isEmpty()) {
            throw new InvalidParameterException("append fields can not be null");
        }
        for (Field field : fields) {
            if (field != null && field.isAllowNull()) continue;
            throw new InvalidParameterException("append field must allow null value");
        }
        AppendFieldRequest request = new AppendFieldRequest().setFields(fields);
        return this.callWrapper(this.getService().appendField(projectName, topicName, request));
    }

    @Override
    public GetMeterInfoResult getMeterInfo(String projectName, String topicName, String shardId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (!FormatUtils.checkShardId(shardId)) {
            throw new InvalidParameterException("ShardId format is invalid");
        }
        GetMeterInfoRequest request = new GetMeterInfoRequest();
        return this.callWrapper(this.getService().getMeterInfo(projectName, topicName, shardId, request));
    }

    @Override
    public CreateConnectorResult createConnector(String projectName, String topicName, ConnectorType connectorType, List<String> columnFields, ConnectorConfig config) {
        return this.createConnector(projectName, topicName, connectorType, -1L, columnFields, config);
    }

    @Override
    public CreateConnectorResult createConnector(String projectName, String topicName, ConnectorType connectorType, long sinkStartTime, List<String> columnFields, ConnectorConfig config) {
        return this.createConnector(projectName, topicName, connectorType, sinkStartTime, columnFields, config, null);
    }

    @Override
    public CreateConnectorResult createConnector(String projectName, String topicName, ConnectorType connectorType, long sinkStartTime, List<String> columnFields, ConnectorConfig config, Map<String, String> columnNameMap) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (config == null) {
            throw new InvalidParameterException("Config is null");
        }
        CreateConnectorRequest request = new CreateConnectorRequest().setSinkStartTime(sinkStartTime).setColumnFields(columnFields).setType(connectorType).setConfig(config).setColumnNameMap(columnNameMap);
        return this.callWrapper(this.getService().createConnector(projectName, topicName, connectorType.name().toLowerCase(), request));
    }

    @Override
    public GetConnectorResult getConnector(String projectName, String topicName, String connectorId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (connectorId == null) {
            throw new InvalidParameterException("ConnectorId is null");
        }
        return this.callWrapper(this.getService().getConnector(projectName, topicName, connectorId));
    }

    @Override
    public GetConnectorResult getConnector(String projectName, String topicName, ConnectorType connectorType) {
        return this.getConnector(projectName, topicName, connectorType.name().toLowerCase());
    }

    @Override
    public UpdateConnectorResult updateConnector(String projectName, String topicName, String connectorId, ConnectorConfig config) {
        return this.updateConnector(projectName, topicName, connectorId, config, null, null);
    }

    @Override
    public UpdateConnectorResult updateConnector(String projectName, String topicName, String connectorId, List<String> columnFields) {
        return this.updateConnector(projectName, topicName, connectorId, null, null, columnFields);
    }

    @Override
    public UpdateConnectorResult updateConnector(String projectName, String topicName, String connectorId, Map<String, String> columnNameMap) {
        return this.updateConnector(projectName, topicName, connectorId, null, columnNameMap, null);
    }

    @Override
    public UpdateConnectorResult updateConnector(String projectName, String topicName, String connectorId, ConnectorConfig config, Map<String, String> columnNameMap, List<String> columnFields) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (connectorId == null) {
            throw new InvalidParameterException("ConnectorId is null");
        }
        UpdateConnectorRequest request = new UpdateConnectorRequest().setConfig(config).setColumnNameMap(columnNameMap).setColumnFields(columnFields);
        return this.callWrapper(this.getService().updateConnector(projectName, topicName, connectorId, request));
    }

    @Override
    public UpdateConnectorResult updateConnector(String projectName, String topicName, ConnectorType connectorType, ConnectorConfig config) {
        return this.updateConnector(projectName, topicName, connectorType.name().toLowerCase(), config);
    }

    @Override
    public ListConnectorResult listConnector(String projectName, String topicName) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        return this.callWrapper(this.getService().listConnector(projectName, topicName));
    }

    @Override
    public DeleteConnectorResult deleteConnector(String projectName, String topicName, String connectorId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (connectorId == null) {
            throw new InvalidParameterException("ConnectorId is null");
        }
        return this.callWrapper(this.getService().deleteConnector(projectName, topicName, connectorId));
    }

    @Override
    public DeleteConnectorResult deleteConnector(String projectName, String topicName, ConnectorType connectorType) {
        return this.deleteConnector(projectName, topicName, connectorType.name().toLowerCase());
    }

    @Override
    public GetConnectorDoneTimeResult getConnectorDoneTime(String projectName, String topicName, String connectorId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        return this.callWrapper(this.getService().getConnectorDoneTime(projectName, topicName, connectorId));
    }

    @Override
    public GetConnectorDoneTimeResult getConnectorDoneTime(String projectName, String topicName, ConnectorType connectorType) {
        return this.getConnectorDoneTime(projectName, topicName, connectorType.name().toLowerCase());
    }

    @Override
    public ReloadConnectorResult reloadConnector(String projectName, String topicName, String connectorId) {
        return this.reloadConnector(projectName, topicName, connectorId, null);
    }

    @Override
    public ReloadConnectorResult reloadConnector(String projectName, String topicName, ConnectorType connectorType) {
        return this.reloadConnector(projectName, topicName, connectorType.name().toLowerCase(), null);
    }

    @Override
    public ReloadConnectorResult reloadConnector(String projectName, String topicName, ConnectorType connectorType, String shardId) {
        return this.reloadConnector(projectName, topicName, connectorType.name().toLowerCase(), shardId);
    }

    @Override
    public ReloadConnectorResult reloadConnector(String projectName, String topicName, String connectorId, String shardId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (connectorId == null) {
            throw new InvalidParameterException("ConnectorId is null");
        }
        ReloadConnectorRequest request = new ReloadConnectorRequest().setShardId(shardId);
        return this.callWrapper(this.getService().reloadConnector(projectName, topicName, connectorId, request));
    }

    @Override
    public UpdateConnectorStateResult updateConnectorState(String projectName, String topicName, String connectorId, ConnectorState connectorState) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("topicName format is invalid");
        }
        if (ConnectorState.CREATED == connectorState) {
            throw new InvalidParameterException("connectorState is invalid");
        }
        UpdateConnectorStateRequest request = new UpdateConnectorStateRequest().setState(connectorState);
        return this.callWrapper(this.getService().updateConnectorState(projectName, topicName, connectorId, request));
    }

    @Override
    public UpdateConnectorStateResult updateConnectorState(String projectName, String topicName, ConnectorType connectorType, ConnectorState connectorState) {
        return this.updateConnectorState(projectName, topicName, connectorType.name().toLowerCase(), connectorState);
    }

    @Override
    public UpdateConnectorOffsetResult updateConnectorOffset(String projectName, String topicName, String connectorId, String shardId, ConnectorOffset offset) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("topicName format is invalid");
        }
        if (shardId != null && !FormatUtils.checkShardId(shardId)) {
            throw new InvalidParameterException("ShardId format is invalid");
        }
        UpdateConnectorOffsetRequest request = new UpdateConnectorOffsetRequest().setShardId(shardId).setTimestamp(offset.getTimestamp()).setSequence(offset.getSequence());
        return this.callWrapper(this.getService().updateConnectorOffset(projectName, topicName, connectorId, request));
    }

    @Override
    public UpdateConnectorOffsetResult updateConnectorOffset(String projectName, String topicName, ConnectorType connectorType, String shardId, ConnectorOffset offset) {
        return this.updateConnectorOffset(projectName, topicName, connectorType.name().toLowerCase(), shardId, offset);
    }

    @Override
    public GetConnectorShardStatusResult getConnectorShardStatus(String projectName, String topicName, String connectorId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (connectorId == null) {
            throw new InvalidParameterException("ConnectorId is null");
        }
        GetConnectorShardStatusRequest request = new GetConnectorShardStatusRequest();
        return this.callWrapper(this.getService().getConnectorShardStatus(projectName, topicName, connectorId, request));
    }

    @Override
    public GetConnectorShardStatusResult getConnectorShardStatus(String projectName, String topicName, ConnectorType connectorType) {
        return this.getConnectorShardStatus(projectName, topicName, connectorType.name().toLowerCase());
    }

    @Override
    public ConnectorShardStatusEntry getConnectorShardStatus(String projectName, String topicName, String connectorId, String shardId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (connectorId == null) {
            throw new InvalidParameterException("ConnectorId is null");
        }
        if (!FormatUtils.checkShardId(shardId)) {
            throw new InvalidParameterException("ShardId format is invalid");
        }
        GetConnectorShardStatusRequest request = new GetConnectorShardStatusRequest().setShardId(shardId);
        return this.callWrapper(this.getService().getConnectorShardStatusByShard(projectName, topicName, connectorId, request));
    }

    @Override
    public ConnectorShardStatusEntry getConnectorShardStatus(String projectName, String topicName, ConnectorType connectorType, String shardId) {
        return this.getConnectorShardStatus(projectName, topicName, connectorType.name().toLowerCase(), shardId);
    }

    @Override
    public AppendConnectorFieldResult appendConnectorField(String projectName, String topicName, String connectorId, String fieldName) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (connectorId == null) {
            throw new InvalidParameterException("ConnectorId is null");
        }
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            throw new InvalidParameterException("FieldName is invalid");
        }
        AppendConnectorFieldRequest request = new AppendConnectorFieldRequest().setFieldName(fieldName.toLowerCase());
        return this.callWrapper(this.getService().appendConnectorField(projectName, topicName, connectorId, request));
    }

    @Override
    public AppendConnectorFieldResult appendConnectorField(String projectName, String topicName, ConnectorType connectorType, String fieldName) {
        return this.appendConnectorField(projectName, topicName, connectorType.name().toLowerCase(), fieldName);
    }

    @Override
    public CreateSubscriptionResult createSubscription(String projectName, String topicName, String comment) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (!FormatUtils.checkComment(comment)) {
            throw new InvalidParameterException("Comment format is invalid");
        }
        CreateSubscriptionRequest request = new CreateSubscriptionRequest().setComment(comment);
        return this.callWrapper(this.getService().createSubscription(projectName, topicName, request));
    }

    @Override
    public GetSubscriptionResult getSubscription(String projectName, String topicName, String subId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)subId)) {
            throw new InvalidParameterException("SubId format is invalid");
        }
        return this.callWrapper(this.getService().getSubscription(projectName, topicName, subId));
    }

    @Override
    public DeleteSubscriptionResult deleteSubscription(String projectName, String topicName, String subId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)subId)) {
            throw new InvalidParameterException("SubId format is invalid");
        }
        return this.callWrapper(this.getService().deleteSubscription(projectName, topicName, subId));
    }

    @Override
    public ListSubscriptionResult listSubscription(String projectName, String topicName, int pageNum, int pageSize) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (pageNum <= 0 || pageSize <= 0) {
            throw new InvalidParameterException("Page format is invalid");
        }
        ListSubscriptionRequest request = new ListSubscriptionRequest().setPageNum(pageNum).setPageSize(pageSize);
        return this.callWrapper(this.getService().listSubscription(projectName, topicName, request));
    }

    @Override
    public UpdateSubscriptionResult updateSubscription(String projectName, String topicName, String subId, String comment) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)subId)) {
            throw new InvalidParameterException("SubId format is invalid");
        }
        if (!FormatUtils.checkComment(comment)) {
            throw new InvalidParameterException("Comment format is invalid");
        }
        UpdateSubscriptionRequest request = new UpdateSubscriptionRequest().setComment(comment);
        return this.callWrapper(this.getService().updateSubscription(projectName, topicName, subId, request));
    }

    @Override
    public UpdateSubscriptionStateResult updateSubscriptionState(String projectName, String topicName, String subId, SubscriptionState state) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)subId)) {
            throw new InvalidParameterException("SubId format is invalid");
        }
        if (state == null) {
            throw new InvalidParameterException("State is null");
        }
        UpdateSubscriptionRequest request = new UpdateSubscriptionRequest().setState(state);
        return this.callWrapper(this.getService().updateSubscriptionState(projectName, topicName, subId, request));
    }

    @Override
    public OpenSubscriptionSessionResult openSubscriptionSession(String projectName, String topicName, String subId, List<String> shardIds) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)subId)) {
            throw new InvalidParameterException("SubId format is invalid");
        }
        if (shardIds == null || shardIds.isEmpty()) {
            throw new InvalidParameterException("ShardIds is null");
        }
        OpenSubscriptionSessionRequest request = new OpenSubscriptionSessionRequest().setShardIds(shardIds);
        return this.callWrapper(this.getService().openSubscriptionSession(projectName, topicName, subId, request));
    }

    @Override
    public GetSubscriptionOffsetResult getSubscriptionOffset(String projectName, String topicName, String subId, List<String> shardIds) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)subId)) {
            throw new InvalidParameterException("SubId format is invalid");
        }
        GetSubscriptionOffsetRequest request = new GetSubscriptionOffsetRequest().setShardIds(shardIds);
        return this.callWrapper(this.getService().getSubscriptionOffset(projectName, topicName, subId, request));
    }

    @Override
    public CommitSubscriptionOffsetResult commitSubscriptionOffset(String projectName, String topicName, String subId, Map<String, SubscriptionOffset> offsets) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)subId)) {
            throw new InvalidParameterException("SubId format is invalid");
        }
        if (offsets == null || offsets.isEmpty()) {
            throw new InvalidParameterException("Offsets is null");
        }
        CommitSubscriptionOffsetRequest request = new CommitSubscriptionOffsetRequest().setOffsets(offsets);
        return this.callWrapper(this.getService().commitSubscriptionOffset(projectName, topicName, subId, request));
    }

    @Override
    public ResetSubscriptionOffsetResult resetSubscriptionOffset(String projectName, String topicName, String subId, Map<String, SubscriptionOffset> offsets) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)subId)) {
            throw new InvalidParameterException("SubId format is invalid");
        }
        if (offsets == null || offsets.isEmpty()) {
            throw new InvalidParameterException("Offsets is null");
        }
        ResetSubscriptionOffsetRequest request = new ResetSubscriptionOffsetRequest().setOffsets(offsets);
        return this.callWrapper(this.getService().resetSubscriptionOffset(projectName, topicName, subId, request));
    }

    @Override
    public HeartbeatResult heartbeat(String projectName, String topicName, String consumerGroup, String consumerId, long versionId, List<String> holdShardList, List<String> readEndShardList) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)consumerGroup)) {
            throw new InvalidParameterException("ConsumerGroup format is invalid");
        }
        if (holdShardList == null) {
            throw new InvalidParameterException("HoldShardList is null");
        }
        HeartbeatRequest request = new HeartbeatRequest().setConsumerId(consumerId).setVersionId(versionId).setHoldShardList(holdShardList).setReadEndShardList(readEndShardList);
        return this.callWrapper(this.getService().heartbeat(projectName, topicName, consumerGroup, request));
    }

    @Override
    public JoinGroupResult joinGroup(String projectName, String topicName, String consumerGroup, long sessionTimeout) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)consumerGroup)) {
            throw new InvalidParameterException("ConsumerGroup format is invalid");
        }
        JoinGroupRequest request = new JoinGroupRequest().setSessionTimeout(sessionTimeout);
        return this.callWrapper(this.getService().joinGroup(projectName, topicName, consumerGroup, request));
    }

    @Override
    public SyncGroupResult syncGroup(String projectName, String topicName, String consumerGroup, String consumerId, long versionId, List<String> releaseShardList, List<String> readEndShardList) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)consumerGroup)) {
            throw new InvalidParameterException("ConsumerGroup format is invalid");
        }
        SyncGroupRequest request = new SyncGroupRequest().setConsumerId(consumerId).setVersionId(versionId).setReleaseShardList(releaseShardList).setReadEndShardList(readEndShardList);
        return this.callWrapper(this.getService().syncGroup(projectName, topicName, consumerGroup, request));
    }

    @Override
    public LeaveGroupResult leaveGroup(String projectName, String topicName, String consumerGroup, String consumerId, long versionId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)consumerGroup)) {
            throw new InvalidParameterException("ConsumerGroup format is invalid");
        }
        LeaveGroupRequest request = new LeaveGroupRequest().setConsumerId(consumerId).setVersionId(versionId);
        return this.callWrapper(this.getService().leaveGroup(projectName, topicName, consumerGroup, request));
    }

    @Override
    public CreateAlarmRuleResult createAlarmRule(String projectName, String topicName, AlarmRule alarmRule) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (alarmRule == null) {
            throw new InvalidParameterException("AlarmRule is null");
        }
        CreateAlarmRuleRequest request = new CreateAlarmRuleRequest().setAlarmType(alarmRule.getAlarmType()).setRule(alarmRule);
        return this.callWrapper(this.getService().createAlarmRule(projectName, topicName, request));
    }

    @Override
    public UpdateAlarmRuleResult updateAlarmRule(String projectName, String topicName, String alarmId, AlarmRule alarmRule) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)alarmId)) {
            throw new InvalidParameterException("AlarmId format is invalid");
        }
        if (alarmRule == null) {
            throw new InvalidParameterException("AlarmRule is null");
        }
        UpdateAlarmRuleRequest request = new UpdateAlarmRuleRequest().setRule(alarmRule);
        return this.callWrapper(this.getService().updateAlarmRule(projectName, topicName, alarmId, request));
    }

    @Override
    public GetAlarmRuleResult getAlarmRule(String projectName, String topicName, String alarmId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)alarmId)) {
            throw new InvalidParameterException("AlarmId format is invalid");
        }
        return this.callWrapper(this.getService().getAlarmRule(projectName, topicName, alarmId));
    }

    @Override
    public DeleteAlarmRuleResult deleteAlarmRule(String projectName, String topicName, String alarmId) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)alarmId)) {
            throw new InvalidParameterException("AlarmId format is invalid");
        }
        return this.callWrapper(this.getService().deleteAlarmRule(projectName, topicName, alarmId));
    }

    @Override
    public ListAlarmRuleResult listAlarmRule(String projectName, String topicName) {
        return this.listAlarmRule(projectName, topicName, -1, -1);
    }

    @Override
    public ListAlarmRuleResult listAlarmRule(String projectName, String topicName, int pageIndex, int pageSize) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        ListAlarmRuleRequest request = new ListAlarmRuleRequest();
        if (pageIndex > 0 && pageSize > 0) {
            request.setPageIndex(pageIndex);
            request.setPageSize(pageSize);
        }
        return this.callWrapper(this.getService().listAlarmRule(projectName, topicName, request));
    }

    @Override
    public ListMetaLogResult listMetaLog(String projectName, String topicName, int pageIndex, int pageSize) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (pageIndex < 1) {
            throw new InvalidParameterException("PageIndex must larger than 1");
        }
        if (pageSize < 1) {
            throw new InvalidParameterException("PageSize must larger than 1");
        }
        ListMetaLogRequest request = new ListMetaLogRequest().setPageIndex(pageIndex).setPageSize(pageSize);
        return this.callWrapper(this.getService().listMetaLog(projectName, topicName, request));
    }

    @Override
    public ListTopicSchemaResult listTopicSchema(String projectName, String topicName) {
        return this.listTopicSchema(projectName, topicName, -1, -1);
    }

    @Override
    public ListTopicSchemaResult listTopicSchema(String projectName, String topicName, int pageNumber, int pageSize) {
        ListTopicSchemaRequest request = new ListTopicSchemaRequest().setPageNumber(pageNumber).setPageSize(pageSize);
        return this.callWrapper(this.getService().listTopicSchema(projectName, topicName, request));
    }

    @Override
    public GetTopicSchemaResult getTopicSchema(String projectName, String topicName, int versionId) {
        return this.getTopicSchema(projectName, topicName, null, versionId);
    }

    @Override
    public GetTopicSchemaResult getTopicSchema(String projectName, String topicName, RecordSchema schema) {
        return this.getTopicSchema(projectName, topicName, schema, -1);
    }

    private GetTopicSchemaResult getTopicSchema(String projectName, String topicName, RecordSchema schema, int versionId) {
        GetTopicSchemaRequest request = new GetTopicSchemaRequest().setVersionId(versionId).setRecordSchema(schema);
        return this.callWrapper(this.getService().getTopicSchema(projectName, topicName, request));
    }

    @Override
    public RegisterTopicSchemaResult registerTopicSchema(String projectName, String topicName, RecordSchema schema) {
        RegisterTopicSchemaRequest request = new RegisterTopicSchemaRequest().setRecordSchema(schema);
        return this.callWrapper(this.getService().registerTopicSchema(projectName, topicName, request));
    }

    @Override
    public DeleteTopicSchemaResult deleteTopicSchema(String projectName, String topicName, int versionId) {
        DeleteTopicSchemaRequest request = new DeleteTopicSchemaRequest().setVersionId(versionId);
        return this.callWrapper(this.getService().deleteTopicSchema(projectName, topicName, request));
    }

    @Override
    public ListKafkaGroupResult listKafkaGroup(String projectName) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        return this.callWrapper(this.getService().listKafkaGroup(projectName));
    }

    @Override
    public CreateKafkaGroupResult createKafkaGroup(String projectName, String groupName, String comment) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkKafkaGroupName(groupName, true)) {
            throw new InvalidParameterException("KafkaGroupName format is invalid");
        }
        if (!FormatUtils.checkComment(comment)) {
            throw new InvalidParameterException("Comment format is invalid");
        }
        CreateKafkaGroupRequest request = new CreateKafkaGroupRequest().setComment(comment);
        return this.callWrapper(this.getService().createKafkaGroup(projectName, groupName, request));
    }

    @Override
    public UpdateKafkaGroupResult updateKafkaGroup(String projectName, String groupName, String comment) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkKafkaGroupName(groupName)) {
            throw new InvalidParameterException("KafkaGroupName format is invalid");
        }
        if (!FormatUtils.checkComment(comment)) {
            throw new InvalidParameterException("Comment format is invalid");
        }
        UpdateKafkaGroupRequest request = new UpdateKafkaGroupRequest().setComment(comment);
        return this.callWrapper(this.getService().updateKafkaGroup(projectName, groupName, request));
    }

    @Override
    public GetKafkaGroupResult getKafkaGroup(String projectName, String groupName) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkKafkaGroupName(groupName)) {
            throw new InvalidParameterException("KafkaGroupName format is invalid");
        }
        GetKafkaGroupResult result = this.callWrapper(this.getService().getKafkaGroup(projectName, groupName));
        if (result != null) {
            result.setProjectName(projectName).setGroupName(groupName);
        }
        return result;
    }

    @Override
    public DeleteKafkaGroupResult deleteKafkaGroup(String projectName, String groupName) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkKafkaGroupName(groupName)) {
            throw new InvalidParameterException("KafkaGroupName format is invalid");
        }
        return this.callWrapper(this.getService().deleteKafkaGroup(projectName, groupName));
    }

    @Override
    public ListSubscriptionByKafkaGroupResult listSubscriptionByKafkaGroup(String projectName, String groupName) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkKafkaGroupName(groupName)) {
            throw new InvalidParameterException("KafkaGroupName format is invalid");
        }
        ListSubscriptionByKafkaGroupRequest request = new ListSubscriptionByKafkaGroupRequest();
        return this.callWrapper(this.getService().listSubscriptionByKafkaGroup(projectName, groupName, request));
    }

    @Override
    public ListTopicByKafkaGroupResult ListTopicByKafkaGroup(String projectName, String groupName) {
        ListSubscriptionByKafkaGroupResult subResult = this.listSubscriptionByKafkaGroup(projectName, groupName);
        ListTopicByKafkaGroupResult result = new ListTopicByKafkaGroupResult();
        result.setRequestId(subResult.getRequestId());
        ArrayList<String> topics = new ArrayList<String>();
        for (SubscriptionEntry entry : subResult.getSubscriptions()) {
            topics.add(entry.getTopicName());
        }
        return result.setTopicNames(topics);
    }

    @Override
    public UpdateTopicsForKafkaGroupResult updateTopicsForKafkaGroup(String projectName, String groupName, List<String> topics, UpdateKafkaGroupMode mode) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkKafkaGroupName(groupName)) {
            throw new InvalidParameterException("KafkaGroupName format is invalid");
        }
        if (topics.isEmpty()) {
            throw new InvalidParameterException("Topic list is empty");
        }
        UpdateTopicsForKafkaGroupRequest request = new UpdateTopicsForKafkaGroupRequest().setMode(mode).setTopics(topics);
        return this.callWrapper(this.getService().updateTopicsForKafkaGroup(projectName, groupName, request));
    }
}

