/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl;

import com.aliyun.datahub.client.auth.Account;
import com.aliyun.datahub.client.common.DatahubConfig;
import com.aliyun.datahub.client.exception.InvalidParameterException;
import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.client.impl.DatahubClientJsonImpl;
import com.aliyun.datahub.client.impl.request.protobuf.GetRecordsRequestPB;
import com.aliyun.datahub.client.impl.request.protobuf.PutRecordsRequestPB;
import com.aliyun.datahub.client.model.GetRecordsResult;
import com.aliyun.datahub.client.model.PutErrorEntry;
import com.aliyun.datahub.client.model.PutRecordsByShardResult;
import com.aliyun.datahub.client.model.PutRecordsResult;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.protobuf.GetRecordsResultPB;
import com.aliyun.datahub.client.model.protobuf.PutRecordsResultPB;
import com.aliyun.datahub.client.util.FormatUtils;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DatahubClientPbImpl
extends DatahubClientJsonImpl {
    public DatahubClientPbImpl(String endpoint, Account account, DatahubConfig datahubConfig, HttpConfig httpConfig, String userAgent) {
        super(endpoint, account, datahubConfig, httpConfig, userAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRecordsResult putRecords(String projectName, String topicName, List<RecordEntry> records) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (records == null || records.isEmpty()) {
            throw new InvalidParameterException("Records is null or empty");
        }
        PutRecordsRequestPB request = new PutRecordsRequestPB().setRecords(records);
        Timer.Context context = this.PUT_LATENCY_TIMER == null ? null : this.PUT_LATENCY_TIMER.time();
        try {
            PutRecordsResultPB result = this.callWrapper(this.getService().putPbRecords(projectName, topicName, request));
            if (result != null) {
                if (result.getFailedRecordCount() > 0) {
                    ArrayList<RecordEntry> failedRecords = new ArrayList<RecordEntry>();
                    for (PutErrorEntry errorEntry : result.getPutErrorEntries()) {
                        failedRecords.add(request.getRecords().get(errorEntry.getIndex()));
                    }
                    result.setFailedRecords(failedRecords);
                }
                if (this.PUT_QPS_METER != null) {
                    this.PUT_QPS_METER.mark(1L);
                }
                if (this.PUT_RPS_METER != null) {
                    this.PUT_RPS_METER.mark((long)(records.size() - result.getFailedRecordCount()));
                }
            }
            PutRecordsResultPB putRecordsResultPB = result;
            return putRecordsResultPB;
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRecordsByShardResult putRecordsByShard(String projectName, String topicName, String shardId, List<RecordEntry> records) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (!FormatUtils.checkShardId(shardId)) {
            throw new InvalidParameterException("ShardId format is invalid");
        }
        if (records == null || records.isEmpty()) {
            throw new InvalidParameterException("Records is null or empty");
        }
        PutRecordsRequestPB request = new PutRecordsRequestPB().setRecords(records);
        Timer.Context context = this.PUT_LATENCY_TIMER == null ? null : this.PUT_LATENCY_TIMER.time();
        try {
            PutRecordsByShardResult result = this.callWrapper(this.getService().putPbRecordsByShard(projectName, topicName, shardId, request));
            if (result != null) {
                if (this.PUT_QPS_METER != null) {
                    this.PUT_QPS_METER.mark(1L);
                }
                if (this.PUT_RPS_METER != null) {
                    this.PUT_RPS_METER.mark((long)records.size());
                }
            }
            PutRecordsByShardResult putRecordsByShardResult = result;
            return putRecordsByShardResult;
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }

    @Override
    public GetRecordsResult getRecords(String projectName, String topicName, String shardId, String cursor, int limit) {
        return this.getRecords(projectName, topicName, shardId, null, cursor, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecordsResult getRecords(String projectName, String topicName, String shardId, RecordSchema schema, String cursor, int limit) {
        if (!FormatUtils.checkProjectName(projectName)) {
            throw new InvalidParameterException("ProjectName format is invalid");
        }
        if (!FormatUtils.checkTopicName(topicName)) {
            throw new InvalidParameterException("TopicName format is invalid");
        }
        if (StringUtils.isEmpty((CharSequence)cursor)) {
            throw new InvalidParameterException("Cursor format is invalid");
        }
        limit = Math.max(1, limit);
        limit = Math.min(1000, limit);
        GetRecordsRequestPB request = new GetRecordsRequestPB().setCursor(cursor).setLimit(limit);
        Timer.Context context = this.GET_LATENCY_TIMER == null ? null : this.GET_LATENCY_TIMER.time();
        try {
            GetRecordsResultPB result = this.callWrapper(this.getService().getPBRecords(projectName, topicName, shardId, request));
            if (result != null) {
                result.internalSetSchema(schema);
                result.internalSetShardId(shardId);
                if (this.GET_QPS_METER != null) {
                    this.GET_QPS_METER.mark(1L);
                }
                if (this.GET_RPS_METER != null) {
                    this.GET_RPS_METER.mark((long)result.getRecordCount());
                }
            }
            GetRecordsResultPB getRecordsResultPB = result;
            return getRecordsResultPB;
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }
}

