/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.interceptor;

import com.aliyun.datahub.client.auth.Account;
import com.aliyun.datahub.client.common.DateFormat;
import com.aliyun.datahub.client.http.interceptor.AuthInterceptor;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class DatahubAuthInterceptor
extends AuthInterceptor {
    private Map<String, String> userHeader;

    public DatahubAuthInterceptor(Account account, Map<String, String> userHeader) {
        super(account);
        this.userHeader = userHeader;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder reqBuilder = request.newBuilder();
        this.addEssentialHeaders(request, reqBuilder);
        return chain.proceed(reqBuilder.build());
    }

    private void addEssentialHeaders(Request request, Request.Builder reqBuilder) {
        MediaType contentType;
        RequestBody body;
        Set headerNames = request.headers().names();
        if (!headerNames.contains("x-datahub-client-version")) {
            reqBuilder.addHeader("x-datahub-client-version", "1.1");
        }
        if (!headerNames.contains("Date")) {
            reqBuilder.addHeader("Date", DateFormat.getDateTimeFormat().format(new Date()));
        }
        if (this.userHeader != null) {
            for (Map.Entry<String, String> entry : this.userHeader.entrySet()) {
                if (headerNames.contains(entry.getKey())) continue;
                reqBuilder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if ((body = request.body()) != null && (contentType = body.contentType()) != null) {
            reqBuilder.addHeader("Content-Type", contentType.toString());
        }
        this.account.addAuthHeaders(reqBuilder);
    }
}

