/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.interceptor;

import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.http.interceptor.HttpInterceptor;
import com.aliyun.datahub.client.impl.interceptor.DatahubAuthInterceptor;
import com.aliyun.datahub.client.util.JsonUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatahubResponseInterceptor
extends HttpInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatahubResponseInterceptor.class);
    private static String ipAddress = DatahubResponseInterceptor.getIpAddress();
    private static String processId = DatahubResponseInterceptor.getProcessId();
    private static String clientId = DatahubResponseInterceptor.getClientId();
    private String userAgent;
    private String traceIdPrefix;
    private AtomicInteger id = new AtomicInteger();

    private static String getIpAddress() {
        String ip = null;
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface element = interfaces.nextElement();
            Enumeration<InetAddress> addresses = element.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                ip = address.getHostAddress();
            }
        }
        return ip;
    }

    private static String getProcessId() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return processName.substring(0, processName.indexOf(64));
    }

    private static String getClientId() {
        String path = "META-INF/maven/com.aliyun.datahub/aliyun-sdk-datahub/pom.properties";
        Properties p = new Properties();
        try {
            p.load(DatahubAuthInterceptor.class.getClassLoader().getResourceAsStream(path));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String versionNumber = p.getProperty("version", "Unknown");
        return String.format(Locale.ENGLISH, "%s@%s-(Java-%s)", ipAddress, processId, versionNumber);
    }

    public DatahubResponseInterceptor(String userAgent) {
        if (clientId != null) {
            this.userAgent = userAgent == null ? clientId : clientId + "-" + userAgent;
        } else if (userAgent != null) {
            this.userAgent = userAgent;
        }
        this.traceIdPrefix = this.userAgent == null ? "00000000" : String.format("%08x", this.userAgent.hashCode());
    }

    String genClientTraceId() {
        return this.traceIdPrefix + String.format("%016x", System.currentTimeMillis() << 16 | (long)(this.id.getAndIncrement() & 0xFFFF));
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        String clientTraceId = this.genClientTraceId();
        Request request = this.addHeader(chain, clientTraceId);
        try {
            int status;
            Response response = chain.proceed(request);
            String requestId = response.header("x-datahub-request-id");
            if (requestId == null) {
                LOGGER.warn("requestId is null");
            }
            if ((status = response.code()) >= 400) {
                DatahubResponseError error = new DatahubResponseError();
                String contentType = response.header("Content-Type".toLowerCase());
                ResponseBody body = response.body();
                if (body != null) {
                    if ("application/json".equalsIgnoreCase(contentType)) {
                        String bodyStr = body.string();
                        error = JsonUtils.fromJson(bodyStr, DatahubResponseError.class);
                    } else {
                        error = new DatahubResponseError();
                        error.setMessage(body.string());
                    }
                }
                throw new DatahubClientException(status, requestId, clientTraceId, error == null ? "" : error.getCode(), error == null ? "" : error.getMessage());
            }
            return response;
        }
        catch (IOException e) {
            throw new DatahubClientException(5001, null, clientTraceId, null, e.getMessage() + ", url: " + request.url(), e);
        }
    }

    private Request addHeader(Interceptor.Chain chain, String clientTraceId) {
        Request.Builder reqBuilder = chain.request().newBuilder();
        if (ipAddress != null) {
            reqBuilder.addHeader("x-datahub-source-ip", ipAddress);
        }
        if (this.userAgent != null) {
            reqBuilder.addHeader("User-Agent", this.userAgent + "-" + clientTraceId);
        }
        return reqBuilder.build();
    }

    private static class DatahubResponseError {
        @JsonProperty(value="RequestId")
        private String requestId;
        @JsonProperty(value="ErrorCode")
        private String code;
        @JsonProperty(value="ErrorMessage")
        private String message;

        private DatahubResponseError() {
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

