/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.schemaregistry;

import com.aliyun.datahub.client.DatahubClient;
import com.aliyun.datahub.client.exception.DatahubClientException;
import com.aliyun.datahub.client.impl.schemaregistry.SchemaRegistryClient;
import com.aliyun.datahub.client.model.ListTopicSchemaResult;
import com.aliyun.datahub.client.model.RecordSchema;
import com.aliyun.datahub.client.model.RecordSchemaInfo;
import com.aliyun.datahub.client.util.JsonUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class SchemaRegistryClientImpl
implements SchemaRegistryClient {
    private DatahubClient client;
    private final LoadingCache<String, TopicSchemaMeta> schemaCache = CacheBuilder.newBuilder().refreshAfterWrite(10L, TimeUnit.MINUTES).concurrencyLevel(Runtime.getRuntime().availableProcessors()).build((CacheLoader)new CacheLoader<String, TopicSchemaMeta>(){

        public TopicSchemaMeta load(String topicKey) throws Exception {
            String[] segs = topicKey.split("/");
            if (segs.length != 2) {
                throw new DatahubClientException("TopicKey format error. key:" + topicKey);
            }
            return SchemaRegistryClientImpl.this.updateTopicSchemaMeta(segs[0], segs[1]);
        }
    });

    public SchemaRegistryClientImpl(DatahubClient client) {
        this.client = client;
    }

    public void setInnerClient(DatahubClient client) {
        this.client = client;
    }

    @Override
    public RecordSchema getSchema(String projectName, String topicName, int versionId) {
        String topicKey = projectName + "/" + topicName;
        try {
            TopicSchemaMeta schemaMeta = (TopicSchemaMeta)this.schemaCache.get((Object)topicKey);
            return schemaMeta.getSchema(versionId);
        }
        catch (Exception e) {
            throw new DatahubClientException(e.getMessage());
        }
    }

    @Override
    public int getVersionId(String projectName, String topicName, RecordSchema schema) {
        String topicKey = projectName + "/" + topicName;
        try {
            TopicSchemaMeta schemaMeta = (TopicSchemaMeta)this.schemaCache.get((Object)topicKey);
            return schemaMeta.getSchema(schema);
        }
        catch (Exception e) {
            throw new DatahubClientException(e.getMessage());
        }
    }

    private TopicSchemaMeta updateTopicSchemaMeta(String projectName, String topicName) {
        int totalPage;
        TopicSchemaMeta schemaMeta = new TopicSchemaMeta(projectName, topicName);
        int pageNumber = 0;
        int pageSize = 100;
        do {
            ListTopicSchemaResult result = this.client.listTopicSchema(projectName, topicName, ++pageNumber, pageSize);
            totalPage = result.getPageCount();
            for (RecordSchemaInfo info : result.getRecordSchemaInfoList()) {
                schemaMeta.addSchema((int)info.getVersionId(), info.getRecordSchema());
            }
        } while (pageNumber < totalPage);
        return schemaMeta;
    }

    private static class TopicSchemaMeta {
        private final String projectName;
        private final String topicName;
        private final TreeMap<Integer, RecordSchema> versionMap = new TreeMap();
        private final Map<RecordSchema, Integer> schemaMap = new HashMap<RecordSchema, Integer>();

        public TopicSchemaMeta(String projectName, String topicName) {
            this.projectName = projectName;
            this.topicName = topicName;
        }

        public synchronized RecordSchema getSchema(int versionId) {
            if (versionId == -1) {
                if (this.versionMap.isEmpty()) {
                    throw new DatahubClientException("Schema map is empty. project:" + this.projectName + ",topic:" + this.topicName);
                }
                Map.Entry<Integer, RecordSchema> entry = this.versionMap.lastEntry();
                return entry.getValue();
            }
            RecordSchema schema = this.versionMap.get(versionId);
            if (schema == null) {
                throw new DatahubClientException("Not found schema with the specified version. project:" + this.projectName + ",topic:" + this.topicName + ",version:" + versionId);
            }
            return schema;
        }

        public synchronized int getSchema(RecordSchema schema) {
            Integer versionId = this.schemaMap.get(schema);
            if (versionId == null) {
                throw new DatahubClientException("Schema not found. project:" + this.projectName + ",topic:" + this.topicName + ",schema:" + JsonUtils.toJson(schema));
            }
            return versionId;
        }

        public void addSchema(int versionId, RecordSchema schema) {
            this.versionMap.put(versionId, schema);
            this.schemaMap.put(schema, versionId);
        }
    }
}

