/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.serializer;

import com.aliyun.datahub.client.model.BinaryParserConfig;
import com.aliyun.datahub.client.model.BinaryParserType;
import com.aliyun.datahub.client.model.ConnectorConfig;
import com.aliyun.datahub.client.model.ConnectorState;
import com.aliyun.datahub.client.model.ConnectorType;
import com.aliyun.datahub.client.model.DelimiterParserConfig;
import com.aliyun.datahub.client.model.GetConnectorResult;
import com.aliyun.datahub.client.model.ShardContext;
import com.aliyun.datahub.client.model.SinkConfig;
import com.aliyun.datahub.client.model.SinkDatahubConfig;
import com.aliyun.datahub.client.model.SinkEsConfig;
import com.aliyun.datahub.client.model.SinkFcConfig;
import com.aliyun.datahub.client.model.SinkHologresConfig;
import com.aliyun.datahub.client.model.SinkMysqlConfig;
import com.aliyun.datahub.client.model.SinkOdpsConfig;
import com.aliyun.datahub.client.model.SinkOssConfig;
import com.aliyun.datahub.client.model.SinkOtsConfig;
import com.aliyun.datahub.client.model.SourceDtsConfig;
import com.aliyun.datahub.client.util.JsonUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GetConnectorResultDeserializer
extends JsonDeserializer<GetConnectorResult> {
    public GetConnectorResult deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Map.Entry entry;
        Iterator iter;
        GetConnectorResult result = new GetConnectorResult();
        JsonNode tree = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode node = tree.get("ConnectorId");
        if (node != null && !node.isNull()) {
            result.setConnectorId(node.asText());
        }
        if ((node = tree.get("ClusterAddress")) != null && !node.isNull()) {
            result.setClusterAddr(node.asText());
        }
        if ((node = tree.get("Creator")) != null && !node.isNull()) {
            result.setCreator(node.asText());
        }
        if ((node = tree.get("CreateTime")) != null && node.isNumber()) {
            result.setCreateTime(node.asLong());
        }
        if ((node = tree.get("LastModifyTime")) != null && node.isNumber()) {
            result.setLastModifyTime(node.asLong());
        }
        if ((node = tree.get("ColumnFields")) != null && node.isArray()) {
            ArrayList<String> columnFields = new ArrayList<String>();
            for (JsonNode fNode : node) {
                columnFields.add(fNode.asText());
            }
            result.setColumnFields(columnFields);
        }
        if ((node = tree.get("ColumnNameMap")) != null && node.isObject()) {
            HashMap<String, String> columnNameMap = new HashMap<String, String>();
            iter = node.fields();
            while (iter.hasNext()) {
                entry = (Map.Entry)iter.next();
                if (entry.getValue() == null || !((JsonNode)entry.getValue()).isTextual()) continue;
                columnNameMap.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
            result.setColumnNameMap(columnNameMap);
        }
        if ((node = tree.get("Type")) != null && !node.isNull()) {
            result.setType(ConnectorType.valueOf(node.asText().toUpperCase()));
        }
        if ((node = tree.get("State")) != null && !node.isNull()) {
            result.setState(ConnectorState.fromString(node.asText().toUpperCase()));
        }
        if ((node = tree.get("ShardContexts")) != null && node.isArray()) {
            ArrayList<ShardContext> shardContexts = new ArrayList<ShardContext>();
            for (JsonNode fNode : node) {
                ShardContext context = JsonUtils.fromJsonNode(fNode, ShardContext.class);
                if (context == null) {
                    throw new IOException("ShardContext format is invalid");
                }
                shardContexts.add(context);
            }
            result.setShardContexts(shardContexts);
        }
        if ((node = tree.get("ExtraInfo")) != null && node.isObject()) {
            HashMap<String, String> extraConfig = new HashMap<String, String>();
            iter = node.fields();
            while (iter.hasNext()) {
                entry = (Map.Entry)iter.next();
                if (entry.getValue() == null || !((JsonNode)entry.getValue()).isTextual()) continue;
                extraConfig.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
            if (!extraConfig.isEmpty()) {
                result.setExtraConfig(extraConfig);
                result.setSubId((String)extraConfig.get("SubscriptionId"));
            }
        }
        result.setConfig(this.deserializeConnectorConfig(result.getType(), tree));
        return result;
    }

    private ConnectorConfig deserializeConnectorConfig(ConnectorType type, JsonNode tree) {
        JsonNode node = tree.get("Config");
        ConnectorConfig config = null;
        if (node != null && node.isObject()) {
            switch (type) {
                case SINK_ODPS: {
                    config = this.deserializeSinkOdpsConfig(node);
                    break;
                }
                case SINK_ADS: 
                case SINK_MYSQL: {
                    config = this.deserializeSinkDatabaseConfig(node);
                    break;
                }
                case SINK_DATAHUB: {
                    config = this.deserializeSinkDatahubConfig(node);
                    break;
                }
                case SINK_HOLOGRES: {
                    config = this.deserializeSinkHologresConfig(node);
                    break;
                }
                case SINK_ES: {
                    config = this.deserializeSinkEsConfig(node);
                    break;
                }
                case SINK_FC: {
                    config = this.deserializeSinkFcConfig(node);
                    break;
                }
                case SINK_OTS: {
                    config = this.deserializeSinkOtsConfig(node);
                    break;
                }
                case SINK_OSS: {
                    config = this.deserializeSinkOssConfig(node);
                    break;
                }
                case SOURCE_DTS: {
                    config = this.deserializeSourceDtsConfig(node);
                }
            }
            this.deserializeCommonConfig(config, node);
        }
        return config;
    }

    private BinaryParserConfig parseBinaryParserConfig(JsonNode tree) {
        JsonNode node = tree.get("BinaryParserType");
        if (node == null || node.isNull()) {
            return null;
        }
        BinaryParserType type = BinaryParserType.fromString(node.asText());
        if (type == null) {
            return null;
        }
        JsonNode propertiesNode = tree.get("Properties");
        DelimiterParserConfig result = null;
        switch (type) {
            case DELIMITER_PARSER: {
                DelimiterParserConfig config = new DelimiterParserConfig();
                if (propertiesNode != null && propertiesNode.isObject()) {
                    node = propertiesNode.get("LineDelimiter");
                    if (node != null && node.isTextual()) {
                        config.setLineDelimiter(node.asText());
                    }
                    if ((node = propertiesNode.get("ColumnDelimiter")) != null && node.isTextual()) {
                        config.setColumnDelimiter(node.asText());
                    }
                    if ((node = propertiesNode.get("NullValue")) != null && node.isTextual()) {
                        config.setNullValue(node.asText());
                    }
                }
                result = config;
                break;
            }
            default: {
                return result;
            }
        }
        node = tree.get("ColumnNames");
        if (node != null && node.isArray()) {
            ArrayList<String> columnNames = new ArrayList<String>();
            for (JsonNode temp : node) {
                columnNames.add(temp.asText());
            }
            result.setColumnNames(columnNames);
        }
        return result;
    }

    private void deserializeCommonConfig(ConnectorConfig config, JsonNode tree) {
        JsonNode node = tree.get("TimestampUnit");
        if (node != null && node.isTextual()) {
            config.setTimestampUnit(ConnectorConfig.TimestampUnit.valueOf(node.asText().toUpperCase()));
        }
    }

    private ConnectorConfig deserializeSinkOdpsConfig(JsonNode tree) {
        SinkOdpsConfig config = new SinkOdpsConfig();
        JsonNode node = tree.get("Project");
        if (node != null && node.isTextual()) {
            config.setProject(node.asText());
        }
        if ((node = tree.get("Table")) != null && node.isTextual()) {
            config.setTable(node.asText());
        }
        if ((node = tree.get("AccessId")) != null && node.isTextual()) {
            config.setAccessId(node.asText());
        }
        if ((node = tree.get("OdpsEndpoint")) != null && node.isTextual()) {
            config.setEndpoint(node.asText());
        }
        if ((node = tree.get("TunnelEndpoint")) != null && node.isTextual()) {
            config.setTunnelEndpoint(node.asText());
        }
        if ((node = tree.get("PartitionMode")) != null && node.isTextual()) {
            config.setPartitionMode(SinkOdpsConfig.PartitionMode.valueOf(node.asText().toUpperCase()));
        }
        if ((node = tree.get("TimeRange")) != null && node.isTextual()) {
            config.setTimeRange(Integer.valueOf(node.asText()));
        }
        if ((node = tree.get("TimeZone")) != null && node.isTextual()) {
            config.setTimeZone(node.asText());
        }
        if ((node = tree.get("SinkCompressData")) != null && node.isTextual()) {
            config.getInternalConfig().setSinkCompressData(Boolean.valueOf(node.asText()));
        }
        if ((node = tree.get("AddTtHostLine")) != null && node.isTextual()) {
            config.getInternalConfig().setAddTtHostLine(Boolean.valueOf(node.asText()));
        }
        if ((node = tree.get("AplusDataType")) != null && node.isTextual()) {
            config.getInternalConfig().setAplusDataType(Boolean.valueOf(node.asText()));
        }
        if ((node = tree.get("Base64Encode")) != null && node.isTextual()) {
            config.setBase64Encode(Boolean.valueOf(node.asText()));
        }
        if ((node = tree.get("SplitKey")) != null && node.isTextual()) {
            config.setSplitKey(node.asText());
        }
        if ((node = tree.get("PartitionConfig")) != null && node.isTextual() && (node = JsonUtils.toJsonNode(node.asText())) != null && node.isArray()) {
            SinkOdpsConfig.PartitionConfig partitionConfig = new SinkOdpsConfig.PartitionConfig();
            for (JsonNode fNode : node) {
                JsonNode temp = fNode.get("key");
                String key = temp.asText();
                temp = fNode.get("value");
                String value = temp.asText();
                partitionConfig.addConfig(key, value);
            }
            config.setPartitionConfig(partitionConfig);
        }
        return config;
    }

    private ConnectorConfig deserializeSinkDatabaseConfig(JsonNode tree) {
        SinkMysqlConfig config = new SinkMysqlConfig();
        JsonNode node = tree.get("Host");
        if (node != null && node.isTextual()) {
            config.setHost(node.asText());
        }
        if ((node = tree.get("Port")) != null && node.isTextual()) {
            config.setPort(Integer.valueOf(node.asText()));
        }
        if ((node = tree.get("Database")) != null && node.isTextual()) {
            config.setDatabase(node.asText());
        }
        if ((node = tree.get("User")) != null && node.isTextual()) {
            config.setUser(node.asText());
        }
        if ((node = tree.get("Table")) != null && node.isTextual()) {
            config.setTable(node.asText());
        }
        if ((node = tree.get("Ignore")) != null && node.isTextual()) {
            config.setInsertMode(Boolean.valueOf(node.asText()) != false ? SinkMysqlConfig.InsertMode.IGNORE : SinkMysqlConfig.InsertMode.OVERWRITE);
        }
        return config;
    }

    private void deserializeSinkDatahubConfig(JsonNode tree, SinkDatahubConfig config) {
        JsonNode node = tree.get("Endpoint");
        if (node != null && node.isTextual()) {
            config.setEndpoint(node.asText());
        }
        if ((node = tree.get("Project")) != null && node.isTextual()) {
            config.setProjectName(node.asText());
        }
        if ((node = tree.get("Topic")) != null && node.isTextual()) {
            config.setTopicName(node.asText());
        }
        if ((node = tree.get("AuthMode")) != null && node.isTextual()) {
            config.setAuthMode(SinkConfig.AuthMode.valueOf(node.asText().toUpperCase()));
        }
        if ((node = tree.get("AccessId")) != null && node.isTextual()) {
            config.setAccessId(node.asText());
        }
    }

    private ConnectorConfig deserializeSinkDatahubConfig(JsonNode tree) {
        SinkDatahubConfig config = new SinkDatahubConfig();
        this.deserializeSinkDatahubConfig(tree, config);
        return config;
    }

    private ConnectorConfig deserializeSinkHologresConfig(JsonNode tree) {
        JsonNode binaryParserConfigNode;
        SinkHologresConfig config = new SinkHologresConfig();
        this.deserializeSinkDatahubConfig(tree, config);
        JsonNode node = tree.get("InstanceId");
        if (node != null && node.isTextual()) {
            config.setInstanceId(node.asText());
        }
        if ((node = tree.get("BinaryParserConfig")) != null && node.isTextual() && (binaryParserConfigNode = JsonUtils.toJsonNode(node.asText())) != null && binaryParserConfigNode.isObject()) {
            config.setBinaryParserConfig(this.parseBinaryParserConfig(binaryParserConfigNode));
        }
        return config;
    }

    private ConnectorConfig deserializeSinkEsConfig(JsonNode tree) {
        JsonNode fNode;
        SinkEsConfig config = new SinkEsConfig();
        JsonNode node = tree.get("Index");
        if (node != null && node.isTextual()) {
            config.setIndex(node.asText());
        }
        if ((node = tree.get("Endpoint")) != null && node.isTextual()) {
            config.setEndpoint(node.asText());
        }
        if ((node = tree.get("User")) != null && node.isTextual()) {
            config.setUser(node.asText());
        }
        if ((node = tree.get("IDFields")) != null && node.isTextual() && (fNode = JsonUtils.toJsonNode(node.asText())) != null && fNode.isArray()) {
            ArrayList<String> idFields = new ArrayList<String>();
            for (JsonNode temp : fNode) {
                idFields.add(temp.asText());
            }
            config.setIdFields(idFields);
        }
        if ((node = tree.get("TypeFields")) != null && node.isTextual() && (fNode = JsonUtils.toJsonNode(node.asText())) != null && fNode.isArray()) {
            ArrayList<String> typeFields = new ArrayList<String>();
            for (JsonNode temp : fNode) {
                typeFields.add(temp.asText());
            }
            config.setTypeFields(typeFields);
        }
        if ((node = tree.get("RouterFields")) != null && node.isTextual() && (fNode = JsonUtils.toJsonNode(node.asText())) != null && fNode.isArray()) {
            ArrayList<String> routerFields = new ArrayList<String>();
            for (JsonNode temp : fNode) {
                routerFields.add(temp.asText());
            }
            config.setRouterFields(routerFields);
        }
        if ((node = tree.get("ProxyMode")) != null && node.isTextual()) {
            config.setProxyMode(Boolean.valueOf(node.asText()));
        }
        return config;
    }

    private ConnectorConfig deserializeSinkFcConfig(JsonNode tree) {
        SinkFcConfig config = new SinkFcConfig();
        JsonNode node = tree.get("Endpoint");
        if (node != null && node.isTextual()) {
            config.setEndpoint(node.asText());
        }
        if ((node = tree.get("AccessId")) != null && node.isTextual()) {
            config.setAccessId(node.asText());
        }
        if ((node = tree.get("Service")) != null && node.isTextual()) {
            config.setService(node.asText());
        }
        if ((node = tree.get("Function")) != null && node.isTextual()) {
            config.setFunction(node.asText());
        }
        if ((node = tree.get("AuthMode")) != null && node.isTextual()) {
            config.setAuthMode(SinkConfig.AuthMode.valueOf(node.asText().toUpperCase()));
        }
        if ((node = tree.get("InvokeType")) != null && node.isTextual()) {
            config.setInvokeType(SinkFcConfig.InvokeType.valueOf(node.asText().toUpperCase()));
        }
        return config;
    }

    private ConnectorConfig deserializeSinkOtsConfig(JsonNode tree) {
        SinkOtsConfig config = new SinkOtsConfig();
        JsonNode node = tree.get("Endpoint");
        if (node != null && node.isTextual()) {
            config.setEndpoint(node.asText());
        }
        if ((node = tree.get("AccessId")) != null && node.isTextual()) {
            config.setAccessId(node.asText());
        }
        if ((node = tree.get("InstanceName")) != null && node.isTextual()) {
            config.setInstance(node.asText());
        }
        if ((node = tree.get("TableName")) != null && node.isTextual()) {
            config.setTable(node.asText());
        }
        if ((node = tree.get("WriteMode")) != null && node.isTextual()) {
            config.setWriteMode(SinkOtsConfig.WriteMode.valueOf(node.asText().toUpperCase()));
        }
        if ((node = tree.get("AuthMode")) != null && node.isTextual()) {
            config.setAuthMode(SinkConfig.AuthMode.valueOf(node.asText().toUpperCase()));
        }
        return config;
    }

    private ConnectorConfig deserializeSinkOssConfig(JsonNode tree) {
        SinkOssConfig config = new SinkOssConfig();
        JsonNode node = tree.get("Endpoint");
        if (node != null && node.isTextual()) {
            config.setEndpoint(node.asText());
        }
        if ((node = tree.get("AccessId")) != null && node.isTextual()) {
            config.setAccessId(node.asText());
        }
        if ((node = tree.get("Bucket")) != null && node.isTextual()) {
            config.setBucket(node.asText());
        }
        if ((node = tree.get("Prefix")) != null && node.isTextual()) {
            config.setPrefix(node.asText());
        }
        if ((node = tree.get("TimeFormat")) != null && node.isTextual()) {
            config.setTimeFormat(node.asText());
        }
        if ((node = tree.get("TimeRange")) != null && node.isTextual()) {
            config.setTimeRange(Integer.valueOf(node.asText()));
        }
        if ((node = tree.get("MaxFileSize")) != null && node.isTextual()) {
            config.setMaxFileSize(node.asLong());
        }
        if ((node = tree.get("AuthMode")) != null && node.isTextual()) {
            config.setAuthMode(SinkConfig.AuthMode.valueOf(node.asText().toUpperCase()));
        }
        return config;
    }

    private ConnectorConfig deserializeSourceDtsConfig(JsonNode tree) {
        JsonNode fNode;
        SourceDtsConfig config = new SourceDtsConfig();
        JsonNode node = tree.get("Endpoint");
        if (node != null && node.isTextual()) {
            config.setEndpoint(node.asText());
        }
        if ((node = tree.get("User")) != null && node.isTextual()) {
            config.setUser(node.asText());
        }
        if ((node = tree.get("Topic")) != null && node.isTextual()) {
            config.setTopic(node.asText());
        }
        if ((node = tree.get("SubId")) != null && node.isTextual()) {
            config.setSubId(node.asText());
        }
        if ((node = tree.get("IDFields")) != null && node.isTextual() && (fNode = JsonUtils.toJsonNode(node.asText())) != null && fNode.isArray()) {
            ArrayList<String> idFields = new ArrayList<String>();
            for (JsonNode temp : fNode) {
                idFields.add(temp.asText());
            }
            config.setIdFields(idFields);
        }
        return config;
    }
}

