/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.util;

import com.aliyun.datahub.client.exception.InvalidParameterException;
import java.math.BigDecimal;

public abstract class ValueCheckUtils {
    private static final long MIN_TIMESTAMP = -62135798400000000L;
    private static final long MAX_TIMESTAMP = 253402271999000000L;

    public static boolean checkString(Object value) {
        return value instanceof String;
    }

    public static boolean checkTinyInt(Object value) {
        return value instanceof Byte || value instanceof Integer && (Integer)value <= 127 && (Integer)value >= -128 || value instanceof Long && (Long)value <= 127L && (Long)value >= -128L;
    }

    public static boolean checkSmallInt(Object value) {
        return value instanceof Short || value instanceof Integer && (Integer)value <= Short.MAX_VALUE && (Integer)value >= Short.MIN_VALUE || value instanceof Long && (Long)value <= 32767L && (Long)value >= -32768L;
    }

    public static boolean checkInteger(Object value) {
        return value instanceof Integer || value instanceof Long && (Long)value <= Integer.MAX_VALUE && (Long)value >= Integer.MIN_VALUE;
    }

    public static boolean checkBigint(Object value) {
        return value instanceof Long || value instanceof Integer;
    }

    public static boolean checkFloat(Object value) {
        return value instanceof Float || value instanceof Double;
    }

    public static boolean checkDouble(Object value) {
        return value instanceof Double;
    }

    public static boolean checkBoolean(Object value) {
        return value instanceof Boolean;
    }

    public static boolean checkTimestamp(Object value) {
        long ts;
        boolean valid = ValueCheckUtils.checkBigint(value);
        if (valid && ((ts = ((Long)value).longValue()) < -62135798400000000L || ts > 253402271999000000L)) {
            throw new InvalidParameterException("Timestamp range error. min:-62135798400000000, max:253402271999000000");
        }
        return valid;
    }

    public static boolean checkDecimal(Object value) {
        return value instanceof BigDecimal;
    }
}

