/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.common.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class DateUtils {
    private static long TZ = 8L;
    private static Calendar CAL = Calendar.getInstance();
    private static final long _0001_01_01 = DateUtils.getTime(1, 1, 1, 0, 0, 0);
    private static final long _0000_03_01 = DateUtils.getTime(0, 3, 1, 0, 0, 0);
    private static final long _1928_01_01 = DateUtils.getTime(1928, 1, 1, 0, 0, 0);
    private static final long _1940_06_03_01 = DateUtils.getTime(1940, 6, 3, 1, 0, 0);
    private static final long _1940_10_01 = DateUtils.getTime(1940, 10, 1, 0, 0, 0);
    private static final long _1941_03_16_01 = DateUtils.getTime(1941, 3, 16, 1, 0, 0);
    private static final long _1941_10_01 = DateUtils.getTime(1941, 10, 1, 0, 0, 0);
    private static final long _1986_05_04_01 = DateUtils.getTime(1986, 5, 4, 1, 0, 0);
    private static final long _1986_09_14 = DateUtils.getTime(1986, 9, 14, 0, 0, 0);
    private static final long _1987_04_12_01 = DateUtils.getTime(1987, 4, 12, 1, 0, 0);
    private static final long _1987_09_13 = DateUtils.getTime(1987, 9, 13, 0, 0, 0);
    private static final long _1988_04_10_01 = DateUtils.getTime(1988, 4, 10, 1, 0, 0);
    private static final long _1988_09_11 = DateUtils.getTime(1988, 9, 11, 0, 0, 0);
    private static final long _1989_04_16_01 = DateUtils.getTime(1989, 4, 16, 1, 0, 0);
    private static final long _1989_09_17 = DateUtils.getTime(1989, 9, 17, 0, 0, 0);
    private static final long _1990_04_15_01 = DateUtils.getTime(1990, 4, 15, 1, 0, 0);
    private static final long _1990_09_16 = DateUtils.getTime(1990, 9, 16, 0, 0, 0);
    private static final long _1991_04_14_01 = DateUtils.getTime(1991, 4, 14, 1, 0, 0);
    private static final long _1991_09_15 = DateUtils.getTime(1991, 9, 15, 0, 0, 0);
    private static final long _0000_01_01_C = -62167248352L;
    private static final long _0000_03_01_C = -62162064352L;
    private static final long _0000_03_01_08_C = -62162035552L;
    private static final long _1927_12_31_23_59_59_C = -1325491553L;
    private static final long _1940_06_03_01_C = -933494400L;
    private static final long _1940_09_30_23_C = -923130000L;
    private static final long _1941_03_16_01_C = -908784000L;
    private static final long _1941_09_30_23_C = -891594000L;
    private static final long _1986_05_04_01_C = 515520000L;
    private static final long _1986_09_13_23_C = 527007600L;
    private static final long _1987_04_12_01_C = 545155200L;
    private static final long _1987_09_12_23_C = 558457200L;
    private static final long _1988_04_10_01_C = 576604800L;
    private static final long _1988_09_10_23_C = 589906800L;
    private static final long _1989_04_16_01_C = 608659200L;
    private static final long _1989_09_16_23_C = 621961200L;
    private static final long _1990_04_15_01_C = 640108800L;
    private static final long _1990_09_15_23_C = 653410800L;
    private static final long _1991_04_14_01_C = 671558400L;
    private static final long _1991_09_14_23_C = 684860400L;
    private static final String RFC822_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    private static long getTime(int year, int month, int day, int hour, int min, int sec) {
        Calendar c = (Calendar)CAL.clone();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        c.set(11, hour);
        c.set(12, min);
        c.set(13, sec);
        c.set(14, 0);
        return c.getTime().getTime();
    }

    public static long date2ms(Date date) {
        Calendar c = null;
        c = (Calendar)CAL.clone();
        c.setTime(date);
        long ms = c.get(14);
        return DateUtils.date2rawtime(date) * 1000L + ms;
    }

    public static Date ms2date(long ms) {
        Date d = DateUtils.rawtime2date(ms / 1000L);
        Calendar c = (Calendar)CAL.clone();
        c.setTime(d);
        c.set(14, (int)(ms % 1000L));
        return c.getTime();
    }

    public static long date2rawtime(Date date) {
        Calendar c = null;
        c = (Calendar)CAL.clone();
        c.setTime(date);
        c.set(14, 0);
        long rawtime = date.getTime();
        int year = c.get(1);
        if (rawtime < _0001_01_01) {
            year = 0;
        }
        int mon = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        int min = c.get(12);
        int sec = c.get(13);
        if (rawtime < _0000_03_01) {
            return -62167248352L + (long)(((((mon - 1) * 31 + (day - 1)) * 24 + hour) * 60 + min) * 60) + (long)sec;
        }
        if ((mon -= 2) <= 0) {
            mon += 12;
            --year;
        }
        long ans = year / 4 - year / 100 + year / 400 + 367 * mon / 12 + day;
        ans += (long)(year * 365 - 719499);
        ans = ((ans * 24L + (long)hour) * 60L + (long)min) * 60L + (long)sec;
        ans -= TZ * 3600L;
        if (rawtime < _1928_01_01) {
            ans -= 352L;
        } else if (rawtime >= _1940_06_03_01 && rawtime < _1940_10_01) {
            ans -= 3600L;
        } else if (rawtime >= _1941_03_16_01 && rawtime < _1941_10_01) {
            ans -= 3600L;
        } else if (rawtime >= _1986_05_04_01 && rawtime < _1986_09_14) {
            ans -= 3600L;
        } else if (rawtime >= _1987_04_12_01 && rawtime < _1987_09_13) {
            ans -= 3600L;
        } else if (rawtime >= _1988_04_10_01 && rawtime < _1988_09_11) {
            ans -= 3600L;
        } else if (rawtime >= _1989_04_16_01 && rawtime < _1989_09_17) {
            ans -= 3600L;
        } else if (rawtime >= _1990_04_15_01 && rawtime < _1990_09_16) {
            ans -= 3600L;
        } else if (rawtime >= _1991_04_14_01 && rawtime < _1991_09_15) {
            ans -= 3600L;
        }
        return ans;
    }

    public static Date rawtime2date(long rawtime) {
        int year;
        int day;
        int mon;
        int hour;
        int min;
        int sec;
        Calendar c = (Calendar)CAL.clone();
        if (rawtime < -62162064352L) {
            long offset = rawtime - -62167248352L;
            sec = (int)(offset % 60L);
            min = (int)((offset /= 60L) % 60L);
            hour = (int)((offset /= 60L) % 24L);
            mon = (int)((offset /= 24L) / 31L + 1L);
            day = (int)((offset %= 31L) + 1L);
            year = 0;
        } else {
            long offset = rawtime - -62162035552L;
            if (rawtime > -1325491553L) {
                offset -= 352L;
            }
            if (rawtime >= -933494400L && rawtime < -923130000L) {
                offset += 3600L;
            } else if (rawtime >= -908784000L && rawtime < -891594000L) {
                offset += 3600L;
            } else if (rawtime >= 515520000L && rawtime < 527007600L) {
                offset += 3600L;
            } else if (rawtime >= 545155200L && rawtime < 558457200L) {
                offset += 3600L;
            } else if (rawtime >= 576604800L && rawtime < 589906800L) {
                offset += 3600L;
            } else if (rawtime >= 608659200L && rawtime < 621961200L) {
                offset += 3600L;
            } else if (rawtime >= 640108800L && rawtime < 653410800L) {
                offset += 3600L;
            } else if (rawtime >= 671558400L && rawtime < 684860400L) {
                offset += 3600L;
            }
            sec = (int)((offset += TZ * 60L * 60L) % 60L);
            min = (int)((offset /= 60L) % 60L);
            hour = (int)((offset /= 60L) % 24L);
            year = (int)((offset /= 24L) / 365L);
            int leap = year / 4 - year / 100 + year / 400;
            while ((long)(year * 365 + leap) > offset) {
                leap = --year / 4 - year / 100 + year / 400;
            }
            offset -= (long)(year * 365 + leap);
            int i = 12;
            while (offset < (long)(367 * i / 12 - 30)) {
                --i;
            }
            offset -= (long)(367 * i / 12 - 30);
            mon = i + 2;
            if (mon > 12) {
                mon -= 12;
                ++year;
            }
            day = (int)(offset + 1L);
        }
        c.set(1, year);
        c.set(2, mon - 1);
        c.set(5, day);
        c.set(11, hour);
        c.set(12, min);
        c.set(13, sec);
        c.set(14, 0);
        return c.getTime();
    }

    public static String formatRfc822Date(Date date) {
        return DateUtils.getRfc822DateFormat().format(date);
    }

    public static Date parseRfc822Date(String dateString) throws ParseException {
        return DateUtils.getRfc822DateFormat().parse(dateString);
    }

    private static DateFormat getRfc822DateFormat() {
        SimpleDateFormat rfc822DateFormat = new SimpleDateFormat(RFC822_DATE_FORMAT, Locale.US);
        rfc822DateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return rfc822DateFormat;
    }
}

