/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model;

import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.ConnectorConfig;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class DatabaseDesc
extends ConnectorConfig {
    private String host;
    private Integer port;
    private String database;
    private String user;
    private String password;
    private String table;
    private boolean ignore = true;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    @Override
    public ObjectNode toJsonNode() {
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode dbNode = mapper.createObjectNode();
        dbNode.put("Host", this.host);
        dbNode.put("Port", String.valueOf(this.port));
        dbNode.put("Ignore", String.valueOf(this.ignore));
        dbNode.put("Database", this.database);
        dbNode.put("User", this.user);
        dbNode.put("Password", this.password);
        dbNode.put("Table", this.table);
        return dbNode;
    }

    @Override
    public void ParseFromJsonNode(JsonNode node) {
        if (node != null && !node.isNull()) {
            JsonNode config = node.get("Host");
            if (config != null && !config.isNull()) {
                this.setHost(config.asText());
            }
            if ((config = node.get("Port")) != null && !config.isNull()) {
                this.setPort(Integer.valueOf(config.asText()));
            }
            if ((config = node.get("Ignore")) != null && !config.isNull()) {
                this.setIgnore(Boolean.valueOf(config.asText()));
            }
            if ((config = node.get("Database")) != null && !config.isNull()) {
                this.setDatabase(config.asText());
            }
            if ((config = node.get("Table")) != null && !config.isNull()) {
                this.setTable(config.asText());
            }
        } else {
            throw new DatahubClientException("Invalid response, missing config.");
        }
    }
}

