/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model;

import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.ConnectorConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class ElasticSearchDesc
extends ConnectorConfig {
    private String index;
    private String endpoint;
    private String user;
    private String password;
    private List<String> idFields = new ArrayList<String>();
    private List<String> typeFields = new ArrayList<String>();

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<String> getIdFields() {
        return this.idFields;
    }

    public void setIdFields(List<String> idFields) {
        this.idFields = idFields;
    }

    public List<String> getTypeFields() {
        return this.typeFields;
    }

    public void setTypeFields(List<String> typeFields) {
        this.typeFields = typeFields;
    }

    @Override
    public ObjectNode toJsonNode() {
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode esNode = mapper.createObjectNode();
        esNode.put("Index", this.index);
        esNode.put("Endpoint", this.endpoint);
        esNode.put("User", this.user);
        esNode.put("Password", this.password);
        ArrayNode ids = mapper.createArrayNode();
        for (String i : this.idFields) {
            ids.add(i);
        }
        esNode.put("IDFields", (JsonNode)ids);
        ArrayNode types = mapper.createArrayNode();
        for (String i : this.typeFields) {
            types.add(i);
        }
        esNode.put("TypeFields", (JsonNode)types);
        return esNode;
    }

    @Override
    public void ParseFromJsonNode(JsonNode node) {
        if (node != null && !node.isNull()) {
            JsonNode field;
            Iterator it;
            JsonNode tree;
            ObjectMapper mapper;
            String fields;
            JsonNode config = node.get("Index");
            if (config != null && !config.isNull()) {
                this.setIndex(config.asText());
            }
            if ((config = node.get("Endpoint")) != null && !config.isNull()) {
                this.setEndpoint(config.asText());
            }
            if ((config = node.get("IDFields")) != null && !config.isNull()) {
                fields = config.asText();
                mapper = JacksonParser.getObjectMapper();
                tree = null;
                try {
                    tree = mapper.readTree(fields);
                }
                catch (IOException e) {
                    throw new DatahubServiceException("Parse IDFields failed:" + fields);
                }
                ArrayList<String> idFields = new ArrayList<String>();
                if (tree != null && !tree.isNull() && tree.isArray()) {
                    it = tree.getElements();
                    while (it.hasNext()) {
                        field = (JsonNode)it.next();
                        idFields.add(field.asText());
                    }
                }
                this.setIdFields(idFields);
            }
            if ((config = node.get("TypeFields")) != null && !config.isNull()) {
                fields = config.asText();
                mapper = JacksonParser.getObjectMapper();
                tree = null;
                try {
                    tree = mapper.readTree(fields);
                }
                catch (IOException e) {
                    throw new DatahubServiceException("Parse typeFields failed:" + fields);
                }
                ArrayList<String> typeFields = new ArrayList<String>();
                if (tree != null && !tree.isNull() && tree.isArray()) {
                    it = tree.getElements();
                    while (it.hasNext()) {
                        field = (JsonNode)it.next();
                        typeFields.add(field.asText());
                    }
                }
                this.setTypeFields(typeFields);
            }
        } else {
            throw new DatahubClientException("Invalid response, missing config.");
        }
    }
}

