/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model;

import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.ConnectorConfig;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class FcDesc
extends ConnectorConfig {
    private String endpoint;
    private String service;
    private String function;
    private String invocationRole;
    private int batchSize;
    private String startPosition;
    private Long startTimestamp;
    private String authMode = "sts";
    private String accessId;
    private String accessKey;

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getInvocationRole() {
        return this.invocationRole;
    }

    public void setInvocationRole(String invocationRole) {
        this.invocationRole = invocationRole;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    public Long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(Long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public String getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(String authMode) {
        this.authMode = authMode;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Override
    public ObjectNode toJsonNode() {
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode fcDesc = mapper.createObjectNode();
        fcDesc.put("Endpoint", this.endpoint);
        fcDesc.put("Service", this.service);
        fcDesc.put("Function", this.function);
        fcDesc.put("BatchSize", this.batchSize);
        fcDesc.put("StartPosition", this.startPosition);
        if (this.startPosition != null && this.startPosition.equals("SYSTEM_TIME")) {
            fcDesc.put("StartTimestamp", this.startTimestamp);
        }
        fcDesc.put("AuthMode", this.authMode);
        if (this.authMode.equals("ak")) {
            fcDesc.put("AccessId", this.accessId);
            fcDesc.put("AccessKey", this.accessKey);
        } else if (this.authMode.equals("sts") && this.invocationRole != null && !this.invocationRole.isEmpty()) {
            fcDesc.put("InvocationRole", this.invocationRole);
        }
        return fcDesc;
    }

    @Override
    public void ParseFromJsonNode(JsonNode node) {
        if (node != null && !node.isNull()) {
            JsonNode sub = node.get("Endpoint");
            if (sub != null && !sub.isNull()) {
                this.endpoint = sub.asText();
            }
            if ((sub = node.get("Service")) != null && !sub.isNull()) {
                this.service = sub.asText();
            }
            if ((sub = node.get("Function")) != null && !sub.isNull()) {
                this.function = sub.asText();
            }
            if ((sub = node.get("InvocationRole")) != null && !sub.isNull()) {
                this.invocationRole = sub.asText();
            }
            if ((sub = node.get("BatchSize")) != null && !sub.isNull()) {
                this.batchSize = sub.asInt();
            }
            if ((sub = node.get("StartPosition")) != null && !sub.isNull()) {
                this.startPosition = sub.asText();
            }
            if ((sub = node.get("StartTimestamp")) != null && !sub.isNull()) {
                this.startTimestamp = sub.asLong();
            }
        } else {
            throw new DatahubClientException("Invalid response, missing config.");
        }
    }
}

