/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.model;

import com.aliyun.datahub.common.util.JacksonParser;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.exception.DatahubServiceException;
import com.aliyun.datahub.model.ConnectorConfig;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class OdpsDesc
extends ConnectorConfig {
    private String projectName;
    private String tableName;
    private String odpsEndpoint;
    private String tunnelEndpoint;
    private String accessId;
    private String accessKey;
    private PartitionMode partitionMode = PartitionMode.USER_DEFINE;
    private int timeRange;
    private Map<String, String> partitionConfig = new LinkedHashMap<String, String>();

    public String getProject() {
        return this.projectName;
    }

    public void setProject(String projectName) {
        this.projectName = projectName;
    }

    public String getTable() {
        return this.tableName;
    }

    public void setTable(String tableName) {
        this.tableName = tableName;
    }

    public String getOdpsEndpoint() {
        return this.odpsEndpoint;
    }

    public void setOdpsEndpoint(String odpsEndpoint) {
        this.odpsEndpoint = odpsEndpoint;
    }

    public String getTunnelEndpoint() {
        return this.tunnelEndpoint;
    }

    public void setTunnelEndpoint(String tunnelEndpoint) {
        this.tunnelEndpoint = tunnelEndpoint;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public PartitionMode getPartitionMode() {
        return this.partitionMode;
    }

    public void setPartitionMode(PartitionMode partitionMode) {
        this.partitionMode = partitionMode;
    }

    public int getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(int timeRange) {
        this.timeRange = timeRange;
    }

    public Map<String, String> getPartitionConfig() {
        return this.partitionConfig;
    }

    public void setPartitionConfig(Map<String, String> partitionConfig) {
        this.partitionConfig = partitionConfig;
    }

    @Override
    public ObjectNode toJsonNode() {
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        ObjectNode odpsDesc = mapper.createObjectNode();
        odpsDesc.put("Project", this.projectName);
        odpsDesc.put("Table", this.tableName);
        odpsDesc.put("OdpsEndpoint", this.odpsEndpoint);
        if (!this.tunnelEndpoint.isEmpty()) {
            odpsDesc.put("TunnelEndpoint", this.tunnelEndpoint);
        }
        odpsDesc.put("AccessId", this.accessId);
        odpsDesc.put("AccessKey", this.accessKey);
        odpsDesc.put("PartitionMode", this.partitionMode.toString());
        odpsDesc.put("TimeRange", this.timeRange);
        ObjectNode config = mapper.createObjectNode();
        for (Map.Entry<String, String> entry : this.partitionConfig.entrySet()) {
            config.put(entry.getKey(), entry.getValue());
        }
        odpsDesc.put("PartitionConfig", (JsonNode)config);
        return odpsDesc;
    }

    @Override
    public void ParseFromJsonNode(JsonNode node) {
        if (node != null && !node.isNull()) {
            JsonNode odps = node.get("Project");
            if (odps != null && !odps.isNull()) {
                this.setProject(odps.asText());
            }
            if ((odps = node.get("Table")) != null && !odps.isNull()) {
                this.setTable(odps.asText());
            }
            if ((odps = node.get("OdpsEndpoint")) != null && !odps.isNull()) {
                this.setOdpsEndpoint(odps.asText());
            }
            if ((odps = node.get("TunnelEndpoint")) != null && !odps.isNull()) {
                this.setTunnelEndpoint(odps.asText());
            }
            if ((odps = node.get("TunnelEndpoint")) != null && !odps.isNull()) {
                this.setTunnelEndpoint(odps.asText());
            }
            if ((odps = node.get("PartitionMode")) != null && !odps.isNull()) {
                this.setPartitionMode(PartitionMode.valueOf(odps.asText()));
            }
            if ((odps = node.get("TimeRange")) != null && !odps.isNull()) {
                this.setTimeRange(Integer.valueOf(odps.asText()));
            }
            if ((odps = node.get("PartitionConfig")) != null && !odps.isNull()) {
                String text = odps.asText();
                ObjectMapper mapper = JacksonParser.getObjectMapper();
                JsonNode tree = null;
                try {
                    tree = mapper.readTree(text);
                }
                catch (IOException e) {
                    throw new DatahubServiceException("Parse partition config failed:" + text);
                }
                LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
                if (tree != null && !tree.isNull() && tree.isArray()) {
                    Iterator it = tree.getElements();
                    while (it.hasNext()) {
                        JsonNode configItem = (JsonNode)it.next();
                        config.put(configItem.get("key").asText(), configItem.get("value").asText());
                    }
                }
                this.setPartitionConfig(config);
            }
        } else {
            throw new DatahubClientException("Invalid response, missing config.");
        }
    }

    public static enum PartitionMode {
        USER_DEFINE,
        SYSTEM_TIME,
        EVENT_TIME;

    }
}

